package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GroupStrategyFluent<A extends GroupStrategyFluent<A>> extends BaseFluent<A>{
  public GroupStrategyFluent() {
  }
  
  public GroupStrategyFluent(GroupStrategy instance) {
    this.copyInstance(instance);
  }
  private IntOrStringBuilder clustersPerDecisionGroup;
  private ArrayList<DecisionGroupBuilder> decisionGroups = new ArrayList<DecisionGroupBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GroupStrategy instance) {
    instance = (instance != null ? instance : new GroupStrategy());
    if (instance != null) {
          this.withClustersPerDecisionGroup(instance.getClustersPerDecisionGroup());
          this.withDecisionGroups(instance.getDecisionGroups());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IntOrString buildClustersPerDecisionGroup() {
    return this.clustersPerDecisionGroup != null ? this.clustersPerDecisionGroup.build() : null;
  }
  
  public A withClustersPerDecisionGroup(IntOrString clustersPerDecisionGroup) {
    this._visitables.remove("clustersPerDecisionGroup");
    if (clustersPerDecisionGroup != null) {
        this.clustersPerDecisionGroup = new IntOrStringBuilder(clustersPerDecisionGroup);
        this._visitables.get("clustersPerDecisionGroup").add(this.clustersPerDecisionGroup);
    } else {
        this.clustersPerDecisionGroup = null;
        this._visitables.get("clustersPerDecisionGroup").remove(this.clustersPerDecisionGroup);
    }
    return (A) this;
  }
  
  public boolean hasClustersPerDecisionGroup() {
    return this.clustersPerDecisionGroup != null;
  }
  
  public A withNewClustersPerDecisionGroup(Object value) {
    return (A)withClustersPerDecisionGroup(new IntOrString(value));
  }
  
  public ClustersPerDecisionGroupNested<A> withNewClustersPerDecisionGroup() {
    return new ClustersPerDecisionGroupNested(null);
  }
  
  public ClustersPerDecisionGroupNested<A> withNewClustersPerDecisionGroupLike(IntOrString item) {
    return new ClustersPerDecisionGroupNested(item);
  }
  
  public ClustersPerDecisionGroupNested<A> editClustersPerDecisionGroup() {
    return withNewClustersPerDecisionGroupLike(java.util.Optional.ofNullable(buildClustersPerDecisionGroup()).orElse(null));
  }
  
  public ClustersPerDecisionGroupNested<A> editOrNewClustersPerDecisionGroup() {
    return withNewClustersPerDecisionGroupLike(java.util.Optional.ofNullable(buildClustersPerDecisionGroup()).orElse(new IntOrStringBuilder().build()));
  }
  
  public ClustersPerDecisionGroupNested<A> editOrNewClustersPerDecisionGroupLike(IntOrString item) {
    return withNewClustersPerDecisionGroupLike(java.util.Optional.ofNullable(buildClustersPerDecisionGroup()).orElse(item));
  }
  
  public A addToDecisionGroups(int index,DecisionGroup item) {
    if (this.decisionGroups == null) {this.decisionGroups = new ArrayList<DecisionGroupBuilder>();}
    DecisionGroupBuilder builder = new DecisionGroupBuilder(item);
    if (index < 0 || index >= decisionGroups.size()) { _visitables.get("decisionGroups").add(builder); decisionGroups.add(builder); } else { _visitables.get("decisionGroups").add(index, builder); decisionGroups.add(index, builder);}
    return (A)this;
  }
  
  public A setToDecisionGroups(int index,DecisionGroup item) {
    if (this.decisionGroups == null) {this.decisionGroups = new ArrayList<DecisionGroupBuilder>();}
    DecisionGroupBuilder builder = new DecisionGroupBuilder(item);
    if (index < 0 || index >= decisionGroups.size()) { _visitables.get("decisionGroups").add(builder); decisionGroups.add(builder); } else { _visitables.get("decisionGroups").set(index, builder); decisionGroups.set(index, builder);}
    return (A)this;
  }
  
  public A addToDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroup... items) {
    if (this.decisionGroups == null) {this.decisionGroups = new ArrayList<DecisionGroupBuilder>();}
    for (DecisionGroup item : items) {DecisionGroupBuilder builder = new DecisionGroupBuilder(item);_visitables.get("decisionGroups").add(builder);this.decisionGroups.add(builder);} return (A)this;
  }
  
  public A addAllToDecisionGroups(Collection<DecisionGroup> items) {
    if (this.decisionGroups == null) {this.decisionGroups = new ArrayList<DecisionGroupBuilder>();}
    for (DecisionGroup item : items) {DecisionGroupBuilder builder = new DecisionGroupBuilder(item);_visitables.get("decisionGroups").add(builder);this.decisionGroups.add(builder);} return (A)this;
  }
  
  public A removeFromDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroup... items) {
    if (this.decisionGroups == null) return (A)this;
    for (DecisionGroup item : items) {DecisionGroupBuilder builder = new DecisionGroupBuilder(item);_visitables.get("decisionGroups").remove(builder); this.decisionGroups.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDecisionGroups(Collection<DecisionGroup> items) {
    if (this.decisionGroups == null) return (A)this;
    for (DecisionGroup item : items) {DecisionGroupBuilder builder = new DecisionGroupBuilder(item);_visitables.get("decisionGroups").remove(builder); this.decisionGroups.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDecisionGroups(Predicate<DecisionGroupBuilder> predicate) {
    if (decisionGroups == null) return (A) this;
    final Iterator<DecisionGroupBuilder> each = decisionGroups.iterator();
    final List visitables = _visitables.get("decisionGroups");
    while (each.hasNext()) {
      DecisionGroupBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DecisionGroup> buildDecisionGroups() {
    return this.decisionGroups != null ? build(decisionGroups) : null;
  }
  
  public DecisionGroup buildDecisionGroup(int index) {
    return this.decisionGroups.get(index).build();
  }
  
  public DecisionGroup buildFirstDecisionGroup() {
    return this.decisionGroups.get(0).build();
  }
  
  public DecisionGroup buildLastDecisionGroup() {
    return this.decisionGroups.get(decisionGroups.size() - 1).build();
  }
  
  public DecisionGroup buildMatchingDecisionGroup(Predicate<DecisionGroupBuilder> predicate) {
      for (DecisionGroupBuilder item : decisionGroups) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDecisionGroup(Predicate<DecisionGroupBuilder> predicate) {
      for (DecisionGroupBuilder item : decisionGroups) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDecisionGroups(List<DecisionGroup> decisionGroups) {
    if (this.decisionGroups != null) {
      this._visitables.get("decisionGroups").clear();
    }
    if (decisionGroups != null) {
        this.decisionGroups = new ArrayList();
        for (DecisionGroup item : decisionGroups) {
          this.addToDecisionGroups(item);
        }
    } else {
      this.decisionGroups = null;
    }
    return (A) this;
  }
  
  public A withDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroup... decisionGroups) {
    if (this.decisionGroups != null) {
        this.decisionGroups.clear();
        _visitables.remove("decisionGroups");
    }
    if (decisionGroups != null) {
      for (DecisionGroup item : decisionGroups) {
        this.addToDecisionGroups(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDecisionGroups() {
    return this.decisionGroups != null && !this.decisionGroups.isEmpty();
  }
  
  public DecisionGroupsNested<A> addNewDecisionGroup() {
    return new DecisionGroupsNested(-1, null);
  }
  
  public DecisionGroupsNested<A> addNewDecisionGroupLike(DecisionGroup item) {
    return new DecisionGroupsNested(-1, item);
  }
  
  public DecisionGroupsNested<A> setNewDecisionGroupLike(int index,DecisionGroup item) {
    return new DecisionGroupsNested(index, item);
  }
  
  public DecisionGroupsNested<A> editDecisionGroup(int index) {
    if (decisionGroups.size() <= index) throw new RuntimeException("Can't edit decisionGroups. Index exceeds size.");
    return setNewDecisionGroupLike(index, buildDecisionGroup(index));
  }
  
  public DecisionGroupsNested<A> editFirstDecisionGroup() {
    if (decisionGroups.size() == 0) throw new RuntimeException("Can't edit first decisionGroups. The list is empty.");
    return setNewDecisionGroupLike(0, buildDecisionGroup(0));
  }
  
  public DecisionGroupsNested<A> editLastDecisionGroup() {
    int index = decisionGroups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last decisionGroups. The list is empty.");
    return setNewDecisionGroupLike(index, buildDecisionGroup(index));
  }
  
  public DecisionGroupsNested<A> editMatchingDecisionGroup(Predicate<DecisionGroupBuilder> predicate) {
    int index = -1;
    for (int i=0;i<decisionGroups.size();i++) { 
    if (predicate.test(decisionGroups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching decisionGroups. No match found.");
    return setNewDecisionGroupLike(index, buildDecisionGroup(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GroupStrategyFluent that = (GroupStrategyFluent) o;
    if (!java.util.Objects.equals(clustersPerDecisionGroup, that.clustersPerDecisionGroup)) return false;
    if (!java.util.Objects.equals(decisionGroups, that.decisionGroups)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clustersPerDecisionGroup,  decisionGroups,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clustersPerDecisionGroup != null) { sb.append("clustersPerDecisionGroup:"); sb.append(clustersPerDecisionGroup + ","); }
    if (decisionGroups != null && !decisionGroups.isEmpty()) { sb.append("decisionGroups:"); sb.append(decisionGroups + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClustersPerDecisionGroupNested<N> extends IntOrStringFluent<ClustersPerDecisionGroupNested<N>> implements Nested<N>{
    ClustersPerDecisionGroupNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) GroupStrategyFluent.this.withClustersPerDecisionGroup(builder.build());
    }
    
    public N endClustersPerDecisionGroup() {
      return and();
    }
    
  
  }
  public class DecisionGroupsNested<N> extends DecisionGroupFluent<DecisionGroupsNested<N>> implements Nested<N>{
    DecisionGroupsNested(int index,DecisionGroup item) {
      this.index = index;
      this.builder = new DecisionGroupBuilder(this, item);
    }
    DecisionGroupBuilder builder;
    int index;
    
    public N and() {
      return (N) GroupStrategyFluent.this.setToDecisionGroups(index,builder.build());
    }
    
    public N endDecisionGroup() {
      return and();
    }
    
  
  }

}