package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlacementSpecFluent<A extends PlacementSpecFluent<A>> extends BaseFluent<A>{
  public PlacementSpecFluent() {
  }
  
  public PlacementSpecFluent(PlacementSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> clusterSets = new ArrayList<String>();
  private DecisionStrategyBuilder decisionStrategy;
  private Integer numberOfClusters;
  private ArrayList<ClusterPredicateBuilder> predicates = new ArrayList<ClusterPredicateBuilder>();
  private PrioritizerPolicyBuilder prioritizerPolicy;
  private SpreadPolicyBuilder spreadPolicy;
  private ArrayList<TolerationBuilder> tolerations = new ArrayList<TolerationBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PlacementSpec instance) {
    instance = (instance != null ? instance : new PlacementSpec());
    if (instance != null) {
          this.withClusterSets(instance.getClusterSets());
          this.withDecisionStrategy(instance.getDecisionStrategy());
          this.withNumberOfClusters(instance.getNumberOfClusters());
          this.withPredicates(instance.getPredicates());
          this.withPrioritizerPolicy(instance.getPrioritizerPolicy());
          this.withSpreadPolicy(instance.getSpreadPolicy());
          this.withTolerations(instance.getTolerations());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToClusterSets(int index,String item) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    this.clusterSets.add(index, item);
    return (A)this;
  }
  
  public A setToClusterSets(int index,String item) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    this.clusterSets.set(index, item); return (A)this;
  }
  
  public A addToClusterSets(java.lang.String... items) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    for (String item : items) {this.clusterSets.add(item);} return (A)this;
  }
  
  public A addAllToClusterSets(Collection<String> items) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    for (String item : items) {this.clusterSets.add(item);} return (A)this;
  }
  
  public A removeFromClusterSets(java.lang.String... items) {
    if (this.clusterSets == null) return (A)this;
    for (String item : items) { this.clusterSets.remove(item);} return (A)this;
  }
  
  public A removeAllFromClusterSets(Collection<String> items) {
    if (this.clusterSets == null) return (A)this;
    for (String item : items) { this.clusterSets.remove(item);} return (A)this;
  }
  
  public List<String> getClusterSets() {
    return this.clusterSets;
  }
  
  public String getClusterSet(int index) {
    return this.clusterSets.get(index);
  }
  
  public String getFirstClusterSet() {
    return this.clusterSets.get(0);
  }
  
  public String getLastClusterSet() {
    return this.clusterSets.get(clusterSets.size() - 1);
  }
  
  public String getMatchingClusterSet(Predicate<String> predicate) {
      for (String item : clusterSets) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingClusterSet(Predicate<String> predicate) {
      for (String item : clusterSets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusterSets(List<String> clusterSets) {
    if (clusterSets != null) {
        this.clusterSets = new ArrayList();
        for (String item : clusterSets) {
          this.addToClusterSets(item);
        }
    } else {
      this.clusterSets = null;
    }
    return (A) this;
  }
  
  public A withClusterSets(java.lang.String... clusterSets) {
    if (this.clusterSets != null) {
        this.clusterSets.clear();
        _visitables.remove("clusterSets");
    }
    if (clusterSets != null) {
      for (String item : clusterSets) {
        this.addToClusterSets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusterSets() {
    return this.clusterSets != null && !this.clusterSets.isEmpty();
  }
  
  public DecisionStrategy buildDecisionStrategy() {
    return this.decisionStrategy != null ? this.decisionStrategy.build() : null;
  }
  
  public A withDecisionStrategy(DecisionStrategy decisionStrategy) {
    this._visitables.remove("decisionStrategy");
    if (decisionStrategy != null) {
        this.decisionStrategy = new DecisionStrategyBuilder(decisionStrategy);
        this._visitables.get("decisionStrategy").add(this.decisionStrategy);
    } else {
        this.decisionStrategy = null;
        this._visitables.get("decisionStrategy").remove(this.decisionStrategy);
    }
    return (A) this;
  }
  
  public boolean hasDecisionStrategy() {
    return this.decisionStrategy != null;
  }
  
  public DecisionStrategyNested<A> withNewDecisionStrategy() {
    return new DecisionStrategyNested(null);
  }
  
  public DecisionStrategyNested<A> withNewDecisionStrategyLike(DecisionStrategy item) {
    return new DecisionStrategyNested(item);
  }
  
  public DecisionStrategyNested<A> editDecisionStrategy() {
    return withNewDecisionStrategyLike(java.util.Optional.ofNullable(buildDecisionStrategy()).orElse(null));
  }
  
  public DecisionStrategyNested<A> editOrNewDecisionStrategy() {
    return withNewDecisionStrategyLike(java.util.Optional.ofNullable(buildDecisionStrategy()).orElse(new DecisionStrategyBuilder().build()));
  }
  
  public DecisionStrategyNested<A> editOrNewDecisionStrategyLike(DecisionStrategy item) {
    return withNewDecisionStrategyLike(java.util.Optional.ofNullable(buildDecisionStrategy()).orElse(item));
  }
  
  public Integer getNumberOfClusters() {
    return this.numberOfClusters;
  }
  
  public A withNumberOfClusters(Integer numberOfClusters) {
    this.numberOfClusters = numberOfClusters;
    return (A) this;
  }
  
  public boolean hasNumberOfClusters() {
    return this.numberOfClusters != null;
  }
  
  public A addToPredicates(int index,ClusterPredicate item) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
    if (index < 0 || index >= predicates.size()) { _visitables.get("predicates").add(builder); predicates.add(builder); } else { _visitables.get("predicates").add(index, builder); predicates.add(index, builder);}
    return (A)this;
  }
  
  public A setToPredicates(int index,ClusterPredicate item) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
    if (index < 0 || index >= predicates.size()) { _visitables.get("predicates").add(builder); predicates.add(builder); } else { _visitables.get("predicates").set(index, builder); predicates.set(index, builder);}
    return (A)this;
  }
  
  public A addToPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.ClusterPredicate... items) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").add(builder);this.predicates.add(builder);} return (A)this;
  }
  
  public A addAllToPredicates(Collection<ClusterPredicate> items) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").add(builder);this.predicates.add(builder);} return (A)this;
  }
  
  public A removeFromPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.ClusterPredicate... items) {
    if (this.predicates == null) return (A)this;
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").remove(builder); this.predicates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPredicates(Collection<ClusterPredicate> items) {
    if (this.predicates == null) return (A)this;
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").remove(builder); this.predicates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPredicates(Predicate<ClusterPredicateBuilder> predicate) {
    if (predicates == null) return (A) this;
    final Iterator<ClusterPredicateBuilder> each = predicates.iterator();
    final List visitables = _visitables.get("predicates");
    while (each.hasNext()) {
      ClusterPredicateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterPredicate> buildPredicates() {
    return this.predicates != null ? build(predicates) : null;
  }
  
  public ClusterPredicate buildPredicate(int index) {
    return this.predicates.get(index).build();
  }
  
  public ClusterPredicate buildFirstPredicate() {
    return this.predicates.get(0).build();
  }
  
  public ClusterPredicate buildLastPredicate() {
    return this.predicates.get(predicates.size() - 1).build();
  }
  
  public ClusterPredicate buildMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
      for (ClusterPredicateBuilder item : predicates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
      for (ClusterPredicateBuilder item : predicates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPredicates(List<ClusterPredicate> predicates) {
    if (this.predicates != null) {
      this._visitables.get("predicates").clear();
    }
    if (predicates != null) {
        this.predicates = new ArrayList();
        for (ClusterPredicate item : predicates) {
          this.addToPredicates(item);
        }
    } else {
      this.predicates = null;
    }
    return (A) this;
  }
  
  public A withPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.ClusterPredicate... predicates) {
    if (this.predicates != null) {
        this.predicates.clear();
        _visitables.remove("predicates");
    }
    if (predicates != null) {
      for (ClusterPredicate item : predicates) {
        this.addToPredicates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPredicates() {
    return this.predicates != null && !this.predicates.isEmpty();
  }
  
  public PredicatesNested<A> addNewPredicate() {
    return new PredicatesNested(-1, null);
  }
  
  public PredicatesNested<A> addNewPredicateLike(ClusterPredicate item) {
    return new PredicatesNested(-1, item);
  }
  
  public PredicatesNested<A> setNewPredicateLike(int index,ClusterPredicate item) {
    return new PredicatesNested(index, item);
  }
  
  public PredicatesNested<A> editPredicate(int index) {
    if (predicates.size() <= index) throw new RuntimeException("Can't edit predicates. Index exceeds size.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  
  public PredicatesNested<A> editFirstPredicate() {
    if (predicates.size() == 0) throw new RuntimeException("Can't edit first predicates. The list is empty.");
    return setNewPredicateLike(0, buildPredicate(0));
  }
  
  public PredicatesNested<A> editLastPredicate() {
    int index = predicates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last predicates. The list is empty.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  
  public PredicatesNested<A> editMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<predicates.size();i++) { 
    if (predicate.test(predicates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching predicates. No match found.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  
  public PrioritizerPolicy buildPrioritizerPolicy() {
    return this.prioritizerPolicy != null ? this.prioritizerPolicy.build() : null;
  }
  
  public A withPrioritizerPolicy(PrioritizerPolicy prioritizerPolicy) {
    this._visitables.remove("prioritizerPolicy");
    if (prioritizerPolicy != null) {
        this.prioritizerPolicy = new PrioritizerPolicyBuilder(prioritizerPolicy);
        this._visitables.get("prioritizerPolicy").add(this.prioritizerPolicy);
    } else {
        this.prioritizerPolicy = null;
        this._visitables.get("prioritizerPolicy").remove(this.prioritizerPolicy);
    }
    return (A) this;
  }
  
  public boolean hasPrioritizerPolicy() {
    return this.prioritizerPolicy != null;
  }
  
  public PrioritizerPolicyNested<A> withNewPrioritizerPolicy() {
    return new PrioritizerPolicyNested(null);
  }
  
  public PrioritizerPolicyNested<A> withNewPrioritizerPolicyLike(PrioritizerPolicy item) {
    return new PrioritizerPolicyNested(item);
  }
  
  public PrioritizerPolicyNested<A> editPrioritizerPolicy() {
    return withNewPrioritizerPolicyLike(java.util.Optional.ofNullable(buildPrioritizerPolicy()).orElse(null));
  }
  
  public PrioritizerPolicyNested<A> editOrNewPrioritizerPolicy() {
    return withNewPrioritizerPolicyLike(java.util.Optional.ofNullable(buildPrioritizerPolicy()).orElse(new PrioritizerPolicyBuilder().build()));
  }
  
  public PrioritizerPolicyNested<A> editOrNewPrioritizerPolicyLike(PrioritizerPolicy item) {
    return withNewPrioritizerPolicyLike(java.util.Optional.ofNullable(buildPrioritizerPolicy()).orElse(item));
  }
  
  public SpreadPolicy buildSpreadPolicy() {
    return this.spreadPolicy != null ? this.spreadPolicy.build() : null;
  }
  
  public A withSpreadPolicy(SpreadPolicy spreadPolicy) {
    this._visitables.remove("spreadPolicy");
    if (spreadPolicy != null) {
        this.spreadPolicy = new SpreadPolicyBuilder(spreadPolicy);
        this._visitables.get("spreadPolicy").add(this.spreadPolicy);
    } else {
        this.spreadPolicy = null;
        this._visitables.get("spreadPolicy").remove(this.spreadPolicy);
    }
    return (A) this;
  }
  
  public boolean hasSpreadPolicy() {
    return this.spreadPolicy != null;
  }
  
  public SpreadPolicyNested<A> withNewSpreadPolicy() {
    return new SpreadPolicyNested(null);
  }
  
  public SpreadPolicyNested<A> withNewSpreadPolicyLike(SpreadPolicy item) {
    return new SpreadPolicyNested(item);
  }
  
  public SpreadPolicyNested<A> editSpreadPolicy() {
    return withNewSpreadPolicyLike(java.util.Optional.ofNullable(buildSpreadPolicy()).orElse(null));
  }
  
  public SpreadPolicyNested<A> editOrNewSpreadPolicy() {
    return withNewSpreadPolicyLike(java.util.Optional.ofNullable(buildSpreadPolicy()).orElse(new SpreadPolicyBuilder().build()));
  }
  
  public SpreadPolicyNested<A> editOrNewSpreadPolicyLike(SpreadPolicy item) {
    return withNewSpreadPolicyLike(java.util.Optional.ofNullable(buildSpreadPolicy()).orElse(item));
  }
  
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
    TolerationBuilder builder = new TolerationBuilder(item);
    if (index < 0 || index >= tolerations.size()) { _visitables.get("tolerations").add(builder); tolerations.add(builder); } else { _visitables.get("tolerations").add(index, builder); tolerations.add(index, builder);}
    return (A)this;
  }
  
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
    TolerationBuilder builder = new TolerationBuilder(item);
    if (index < 0 || index >= tolerations.size()) { _visitables.get("tolerations").add(builder); tolerations.add(builder); } else { _visitables.get("tolerations").set(index, builder); tolerations.set(index, builder);}
    return (A)this;
  }
  
  public A addToTolerations(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
    for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").add(builder);this.tolerations.add(builder);} return (A)this;
  }
  
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
    for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").add(builder);this.tolerations.add(builder);} return (A)this;
  }
  
  public A removeFromTolerations(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.Toleration... items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").remove(builder); this.tolerations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").remove(builder); this.tolerations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTolerations(Predicate<TolerationBuilder> predicate) {
    if (tolerations == null) return (A) this;
    final Iterator<TolerationBuilder> each = tolerations.iterator();
    final List visitables = _visitables.get("tolerations");
    while (each.hasNext()) {
      TolerationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Toleration> buildTolerations() {
    return this.tolerations != null ? build(tolerations) : null;
  }
  
  public Toleration buildToleration(int index) {
    return this.tolerations.get(index).build();
  }
  
  public Toleration buildFirstToleration() {
    return this.tolerations.get(0).build();
  }
  
  public Toleration buildLastToleration() {
    return this.tolerations.get(tolerations.size() - 1).build();
  }
  
  public Toleration buildMatchingToleration(Predicate<TolerationBuilder> predicate) {
      for (TolerationBuilder item : tolerations) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingToleration(Predicate<TolerationBuilder> predicate) {
      for (TolerationBuilder item : tolerations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTolerations(List<Toleration> tolerations) {
    if (this.tolerations != null) {
      this._visitables.get("tolerations").clear();
    }
    if (tolerations != null) {
        this.tolerations = new ArrayList();
        for (Toleration item : tolerations) {
          this.addToTolerations(item);
        }
    } else {
      this.tolerations = null;
    }
    return (A) this;
  }
  
  public A withTolerations(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.Toleration... tolerations) {
    if (this.tolerations != null) {
        this.tolerations.clear();
        _visitables.remove("tolerations");
    }
    if (tolerations != null) {
      for (Toleration item : tolerations) {
        this.addToTolerations(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTolerations() {
    return this.tolerations != null && !this.tolerations.isEmpty();
  }
  
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  
  public TolerationsNested<A> addNewToleration() {
    return new TolerationsNested(-1, null);
  }
  
  public TolerationsNested<A> addNewTolerationLike(Toleration item) {
    return new TolerationsNested(-1, item);
  }
  
  public TolerationsNested<A> setNewTolerationLike(int index,Toleration item) {
    return new TolerationsNested(index, item);
  }
  
  public TolerationsNested<A> editToleration(int index) {
    if (tolerations.size() <= index) throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  
  public TolerationsNested<A> editFirstToleration() {
    if (tolerations.size() == 0) throw new RuntimeException("Can't edit first tolerations. The list is empty.");
    return setNewTolerationLike(0, buildToleration(0));
  }
  
  public TolerationsNested<A> editLastToleration() {
    int index = tolerations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tolerations. The list is empty.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  
  public TolerationsNested<A> editMatchingToleration(Predicate<TolerationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tolerations.size();i++) { 
    if (predicate.test(tolerations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tolerations. No match found.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementSpecFluent that = (PlacementSpecFluent) o;
    if (!java.util.Objects.equals(clusterSets, that.clusterSets)) return false;
    if (!java.util.Objects.equals(decisionStrategy, that.decisionStrategy)) return false;
    if (!java.util.Objects.equals(numberOfClusters, that.numberOfClusters)) return false;
    if (!java.util.Objects.equals(predicates, that.predicates)) return false;
    if (!java.util.Objects.equals(prioritizerPolicy, that.prioritizerPolicy)) return false;
    if (!java.util.Objects.equals(spreadPolicy, that.spreadPolicy)) return false;
    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterSets,  decisionStrategy,  numberOfClusters,  predicates,  prioritizerPolicy,  spreadPolicy,  tolerations,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterSets != null && !clusterSets.isEmpty()) { sb.append("clusterSets:"); sb.append(clusterSets + ","); }
    if (decisionStrategy != null) { sb.append("decisionStrategy:"); sb.append(decisionStrategy + ","); }
    if (numberOfClusters != null) { sb.append("numberOfClusters:"); sb.append(numberOfClusters + ","); }
    if (predicates != null && !predicates.isEmpty()) { sb.append("predicates:"); sb.append(predicates + ","); }
    if (prioritizerPolicy != null) { sb.append("prioritizerPolicy:"); sb.append(prioritizerPolicy + ","); }
    if (spreadPolicy != null) { sb.append("spreadPolicy:"); sb.append(spreadPolicy + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DecisionStrategyNested<N> extends DecisionStrategyFluent<DecisionStrategyNested<N>> implements Nested<N>{
    DecisionStrategyNested(DecisionStrategy item) {
      this.builder = new DecisionStrategyBuilder(this, item);
    }
    DecisionStrategyBuilder builder;
    
    public N and() {
      return (N) PlacementSpecFluent.this.withDecisionStrategy(builder.build());
    }
    
    public N endDecisionStrategy() {
      return and();
    }
    
  
  }
  public class PredicatesNested<N> extends ClusterPredicateFluent<PredicatesNested<N>> implements Nested<N>{
    PredicatesNested(int index,ClusterPredicate item) {
      this.index = index;
      this.builder = new ClusterPredicateBuilder(this, item);
    }
    ClusterPredicateBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementSpecFluent.this.setToPredicates(index,builder.build());
    }
    
    public N endPredicate() {
      return and();
    }
    
  
  }
  public class PrioritizerPolicyNested<N> extends PrioritizerPolicyFluent<PrioritizerPolicyNested<N>> implements Nested<N>{
    PrioritizerPolicyNested(PrioritizerPolicy item) {
      this.builder = new PrioritizerPolicyBuilder(this, item);
    }
    PrioritizerPolicyBuilder builder;
    
    public N and() {
      return (N) PlacementSpecFluent.this.withPrioritizerPolicy(builder.build());
    }
    
    public N endPrioritizerPolicy() {
      return and();
    }
    
  
  }
  public class SpreadPolicyNested<N> extends SpreadPolicyFluent<SpreadPolicyNested<N>> implements Nested<N>{
    SpreadPolicyNested(SpreadPolicy item) {
      this.builder = new SpreadPolicyBuilder(this, item);
    }
    SpreadPolicyBuilder builder;
    
    public N and() {
      return (N) PlacementSpecFluent.this.withSpreadPolicy(builder.build());
    }
    
    public N endSpreadPolicy() {
      return and();
    }
    
  
  }
  public class TolerationsNested<N> extends TolerationFluent<TolerationsNested<N>> implements Nested<N>{
    TolerationsNested(int index,Toleration item) {
      this.index = index;
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementSpecFluent.this.setToTolerations(index,builder.build());
    }
    
    public N endToleration() {
      return and();
    }
    
  
  }

}