package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlacementStatusFluent<A extends PlacementStatusFluent<A>> extends BaseFluent<A>{
  public PlacementStatusFluent() {
  }
  
  public PlacementStatusFluent(PlacementStatus instance) {
    this.copyInstance(instance);
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private ArrayList<DecisionGroupStatusBuilder> decisionGroups = new ArrayList<DecisionGroupStatusBuilder>();
  private Integer numberOfSelectedClusters;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PlacementStatus instance) {
    instance = (instance != null ? instance : new PlacementStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withDecisionGroups(instance.getDecisionGroups());
          this.withNumberOfSelectedClusters(instance.getNumberOfSelectedClusters());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addToDecisionGroups(int index,DecisionGroupStatus item) {
    if (this.decisionGroups == null) {this.decisionGroups = new ArrayList<DecisionGroupStatusBuilder>();}
    DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);
    if (index < 0 || index >= decisionGroups.size()) { _visitables.get("decisionGroups").add(builder); decisionGroups.add(builder); } else { _visitables.get("decisionGroups").add(index, builder); decisionGroups.add(index, builder);}
    return (A)this;
  }
  
  public A setToDecisionGroups(int index,DecisionGroupStatus item) {
    if (this.decisionGroups == null) {this.decisionGroups = new ArrayList<DecisionGroupStatusBuilder>();}
    DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);
    if (index < 0 || index >= decisionGroups.size()) { _visitables.get("decisionGroups").add(builder); decisionGroups.add(builder); } else { _visitables.get("decisionGroups").set(index, builder); decisionGroups.set(index, builder);}
    return (A)this;
  }
  
  public A addToDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupStatus... items) {
    if (this.decisionGroups == null) {this.decisionGroups = new ArrayList<DecisionGroupStatusBuilder>();}
    for (DecisionGroupStatus item : items) {DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);_visitables.get("decisionGroups").add(builder);this.decisionGroups.add(builder);} return (A)this;
  }
  
  public A addAllToDecisionGroups(Collection<DecisionGroupStatus> items) {
    if (this.decisionGroups == null) {this.decisionGroups = new ArrayList<DecisionGroupStatusBuilder>();}
    for (DecisionGroupStatus item : items) {DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);_visitables.get("decisionGroups").add(builder);this.decisionGroups.add(builder);} return (A)this;
  }
  
  public A removeFromDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupStatus... items) {
    if (this.decisionGroups == null) return (A)this;
    for (DecisionGroupStatus item : items) {DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);_visitables.get("decisionGroups").remove(builder); this.decisionGroups.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDecisionGroups(Collection<DecisionGroupStatus> items) {
    if (this.decisionGroups == null) return (A)this;
    for (DecisionGroupStatus item : items) {DecisionGroupStatusBuilder builder = new DecisionGroupStatusBuilder(item);_visitables.get("decisionGroups").remove(builder); this.decisionGroups.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDecisionGroups(Predicate<DecisionGroupStatusBuilder> predicate) {
    if (decisionGroups == null) return (A) this;
    final Iterator<DecisionGroupStatusBuilder> each = decisionGroups.iterator();
    final List visitables = _visitables.get("decisionGroups");
    while (each.hasNext()) {
      DecisionGroupStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DecisionGroupStatus> buildDecisionGroups() {
    return this.decisionGroups != null ? build(decisionGroups) : null;
  }
  
  public DecisionGroupStatus buildDecisionGroup(int index) {
    return this.decisionGroups.get(index).build();
  }
  
  public DecisionGroupStatus buildFirstDecisionGroup() {
    return this.decisionGroups.get(0).build();
  }
  
  public DecisionGroupStatus buildLastDecisionGroup() {
    return this.decisionGroups.get(decisionGroups.size() - 1).build();
  }
  
  public DecisionGroupStatus buildMatchingDecisionGroup(Predicate<DecisionGroupStatusBuilder> predicate) {
      for (DecisionGroupStatusBuilder item : decisionGroups) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDecisionGroup(Predicate<DecisionGroupStatusBuilder> predicate) {
      for (DecisionGroupStatusBuilder item : decisionGroups) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDecisionGroups(List<DecisionGroupStatus> decisionGroups) {
    if (this.decisionGroups != null) {
      this._visitables.get("decisionGroups").clear();
    }
    if (decisionGroups != null) {
        this.decisionGroups = new ArrayList();
        for (DecisionGroupStatus item : decisionGroups) {
          this.addToDecisionGroups(item);
        }
    } else {
      this.decisionGroups = null;
    }
    return (A) this;
  }
  
  public A withDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.DecisionGroupStatus... decisionGroups) {
    if (this.decisionGroups != null) {
        this.decisionGroups.clear();
        _visitables.remove("decisionGroups");
    }
    if (decisionGroups != null) {
      for (DecisionGroupStatus item : decisionGroups) {
        this.addToDecisionGroups(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDecisionGroups() {
    return this.decisionGroups != null && !this.decisionGroups.isEmpty();
  }
  
  public DecisionGroupsNested<A> addNewDecisionGroup() {
    return new DecisionGroupsNested(-1, null);
  }
  
  public DecisionGroupsNested<A> addNewDecisionGroupLike(DecisionGroupStatus item) {
    return new DecisionGroupsNested(-1, item);
  }
  
  public DecisionGroupsNested<A> setNewDecisionGroupLike(int index,DecisionGroupStatus item) {
    return new DecisionGroupsNested(index, item);
  }
  
  public DecisionGroupsNested<A> editDecisionGroup(int index) {
    if (decisionGroups.size() <= index) throw new RuntimeException("Can't edit decisionGroups. Index exceeds size.");
    return setNewDecisionGroupLike(index, buildDecisionGroup(index));
  }
  
  public DecisionGroupsNested<A> editFirstDecisionGroup() {
    if (decisionGroups.size() == 0) throw new RuntimeException("Can't edit first decisionGroups. The list is empty.");
    return setNewDecisionGroupLike(0, buildDecisionGroup(0));
  }
  
  public DecisionGroupsNested<A> editLastDecisionGroup() {
    int index = decisionGroups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last decisionGroups. The list is empty.");
    return setNewDecisionGroupLike(index, buildDecisionGroup(index));
  }
  
  public DecisionGroupsNested<A> editMatchingDecisionGroup(Predicate<DecisionGroupStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<decisionGroups.size();i++) { 
    if (predicate.test(decisionGroups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching decisionGroups. No match found.");
    return setNewDecisionGroupLike(index, buildDecisionGroup(index));
  }
  
  public Integer getNumberOfSelectedClusters() {
    return this.numberOfSelectedClusters;
  }
  
  public A withNumberOfSelectedClusters(Integer numberOfSelectedClusters) {
    this.numberOfSelectedClusters = numberOfSelectedClusters;
    return (A) this;
  }
  
  public boolean hasNumberOfSelectedClusters() {
    return this.numberOfSelectedClusters != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementStatusFluent that = (PlacementStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(decisionGroups, that.decisionGroups)) return false;
    if (!java.util.Objects.equals(numberOfSelectedClusters, that.numberOfSelectedClusters)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  decisionGroups,  numberOfSelectedClusters,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (decisionGroups != null && !decisionGroups.isEmpty()) { sb.append("decisionGroups:"); sb.append(decisionGroups + ","); }
    if (numberOfSelectedClusters != null) { sb.append("numberOfSelectedClusters:"); sb.append(numberOfSelectedClusters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DecisionGroupsNested<N> extends DecisionGroupStatusFluent<DecisionGroupsNested<N>> implements Nested<N>{
    DecisionGroupsNested(int index,DecisionGroupStatus item) {
      this.index = index;
      this.builder = new DecisionGroupStatusBuilder(this, item);
    }
    DecisionGroupStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementStatusFluent.this.setToDecisionGroups(index,builder.build());
    }
    
    public N endDecisionGroup() {
      return and();
    }
    
  
  }

}