package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SpreadPolicyFluent<A extends SpreadPolicyFluent<A>> extends BaseFluent<A>{
  public SpreadPolicyFluent() {
  }
  
  public SpreadPolicyFluent(SpreadPolicy instance) {
    this.copyInstance(instance);
  }
  private ArrayList<SpreadConstraintsTermBuilder> spreadConstraints = new ArrayList<SpreadConstraintsTermBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SpreadPolicy instance) {
    instance = (instance != null ? instance : new SpreadPolicy());
    if (instance != null) {
          this.withSpreadConstraints(instance.getSpreadConstraints());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToSpreadConstraints(int index,SpreadConstraintsTerm item) {
    if (this.spreadConstraints == null) {this.spreadConstraints = new ArrayList<SpreadConstraintsTermBuilder>();}
    SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);
    if (index < 0 || index >= spreadConstraints.size()) { _visitables.get("spreadConstraints").add(builder); spreadConstraints.add(builder); } else { _visitables.get("spreadConstraints").add(index, builder); spreadConstraints.add(index, builder);}
    return (A)this;
  }
  
  public A setToSpreadConstraints(int index,SpreadConstraintsTerm item) {
    if (this.spreadConstraints == null) {this.spreadConstraints = new ArrayList<SpreadConstraintsTermBuilder>();}
    SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);
    if (index < 0 || index >= spreadConstraints.size()) { _visitables.get("spreadConstraints").add(builder); spreadConstraints.add(builder); } else { _visitables.get("spreadConstraints").set(index, builder); spreadConstraints.set(index, builder);}
    return (A)this;
  }
  
  public A addToSpreadConstraints(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.SpreadConstraintsTerm... items) {
    if (this.spreadConstraints == null) {this.spreadConstraints = new ArrayList<SpreadConstraintsTermBuilder>();}
    for (SpreadConstraintsTerm item : items) {SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);_visitables.get("spreadConstraints").add(builder);this.spreadConstraints.add(builder);} return (A)this;
  }
  
  public A addAllToSpreadConstraints(Collection<SpreadConstraintsTerm> items) {
    if (this.spreadConstraints == null) {this.spreadConstraints = new ArrayList<SpreadConstraintsTermBuilder>();}
    for (SpreadConstraintsTerm item : items) {SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);_visitables.get("spreadConstraints").add(builder);this.spreadConstraints.add(builder);} return (A)this;
  }
  
  public A removeFromSpreadConstraints(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.SpreadConstraintsTerm... items) {
    if (this.spreadConstraints == null) return (A)this;
    for (SpreadConstraintsTerm item : items) {SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);_visitables.get("spreadConstraints").remove(builder); this.spreadConstraints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSpreadConstraints(Collection<SpreadConstraintsTerm> items) {
    if (this.spreadConstraints == null) return (A)this;
    for (SpreadConstraintsTerm item : items) {SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);_visitables.get("spreadConstraints").remove(builder); this.spreadConstraints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSpreadConstraints(Predicate<SpreadConstraintsTermBuilder> predicate) {
    if (spreadConstraints == null) return (A) this;
    final Iterator<SpreadConstraintsTermBuilder> each = spreadConstraints.iterator();
    final List visitables = _visitables.get("spreadConstraints");
    while (each.hasNext()) {
      SpreadConstraintsTermBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SpreadConstraintsTerm> buildSpreadConstraints() {
    return this.spreadConstraints != null ? build(spreadConstraints) : null;
  }
  
  public SpreadConstraintsTerm buildSpreadConstraint(int index) {
    return this.spreadConstraints.get(index).build();
  }
  
  public SpreadConstraintsTerm buildFirstSpreadConstraint() {
    return this.spreadConstraints.get(0).build();
  }
  
  public SpreadConstraintsTerm buildLastSpreadConstraint() {
    return this.spreadConstraints.get(spreadConstraints.size() - 1).build();
  }
  
  public SpreadConstraintsTerm buildMatchingSpreadConstraint(Predicate<SpreadConstraintsTermBuilder> predicate) {
      for (SpreadConstraintsTermBuilder item : spreadConstraints) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSpreadConstraint(Predicate<SpreadConstraintsTermBuilder> predicate) {
      for (SpreadConstraintsTermBuilder item : spreadConstraints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSpreadConstraints(List<SpreadConstraintsTerm> spreadConstraints) {
    if (this.spreadConstraints != null) {
      this._visitables.get("spreadConstraints").clear();
    }
    if (spreadConstraints != null) {
        this.spreadConstraints = new ArrayList();
        for (SpreadConstraintsTerm item : spreadConstraints) {
          this.addToSpreadConstraints(item);
        }
    } else {
      this.spreadConstraints = null;
    }
    return (A) this;
  }
  
  public A withSpreadConstraints(io.fabric8.openclustermanagement.api.model.cluster.v1beta1.SpreadConstraintsTerm... spreadConstraints) {
    if (this.spreadConstraints != null) {
        this.spreadConstraints.clear();
        _visitables.remove("spreadConstraints");
    }
    if (spreadConstraints != null) {
      for (SpreadConstraintsTerm item : spreadConstraints) {
        this.addToSpreadConstraints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSpreadConstraints() {
    return this.spreadConstraints != null && !this.spreadConstraints.isEmpty();
  }
  
  public A addNewSpreadConstraint(Integer maxSkew,String topologyKey,String topologyKeyType,String whenUnsatisfiable) {
    return (A)addToSpreadConstraints(new SpreadConstraintsTerm(maxSkew, topologyKey, topologyKeyType, whenUnsatisfiable));
  }
  
  public SpreadConstraintsNested<A> addNewSpreadConstraint() {
    return new SpreadConstraintsNested(-1, null);
  }
  
  public SpreadConstraintsNested<A> addNewSpreadConstraintLike(SpreadConstraintsTerm item) {
    return new SpreadConstraintsNested(-1, item);
  }
  
  public SpreadConstraintsNested<A> setNewSpreadConstraintLike(int index,SpreadConstraintsTerm item) {
    return new SpreadConstraintsNested(index, item);
  }
  
  public SpreadConstraintsNested<A> editSpreadConstraint(int index) {
    if (spreadConstraints.size() <= index) throw new RuntimeException("Can't edit spreadConstraints. Index exceeds size.");
    return setNewSpreadConstraintLike(index, buildSpreadConstraint(index));
  }
  
  public SpreadConstraintsNested<A> editFirstSpreadConstraint() {
    if (spreadConstraints.size() == 0) throw new RuntimeException("Can't edit first spreadConstraints. The list is empty.");
    return setNewSpreadConstraintLike(0, buildSpreadConstraint(0));
  }
  
  public SpreadConstraintsNested<A> editLastSpreadConstraint() {
    int index = spreadConstraints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last spreadConstraints. The list is empty.");
    return setNewSpreadConstraintLike(index, buildSpreadConstraint(index));
  }
  
  public SpreadConstraintsNested<A> editMatchingSpreadConstraint(Predicate<SpreadConstraintsTermBuilder> predicate) {
    int index = -1;
    for (int i=0;i<spreadConstraints.size();i++) { 
    if (predicate.test(spreadConstraints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching spreadConstraints. No match found.");
    return setNewSpreadConstraintLike(index, buildSpreadConstraint(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SpreadPolicyFluent that = (SpreadPolicyFluent) o;
    if (!java.util.Objects.equals(spreadConstraints, that.spreadConstraints)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(spreadConstraints,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (spreadConstraints != null && !spreadConstraints.isEmpty()) { sb.append("spreadConstraints:"); sb.append(spreadConstraints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SpreadConstraintsNested<N> extends SpreadConstraintsTermFluent<SpreadConstraintsNested<N>> implements Nested<N>{
    SpreadConstraintsNested(int index,SpreadConstraintsTerm item) {
      this.index = index;
      this.builder = new SpreadConstraintsTermBuilder(this, item);
    }
    SpreadConstraintsTermBuilder builder;
    int index;
    
    public N and() {
      return (N) SpreadPolicyFluent.this.setToSpreadConstraints(index,builder.build());
    }
    
    public N endSpreadConstraint() {
      return and();
    }
    
  
  }

}