package io.fabric8.openclustermanagement.api.model.cluster.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ManagedClusterSelectorBuilder extends ManagedClusterSelectorFluent<ManagedClusterSelectorBuilder> implements VisitableBuilder<ManagedClusterSelector,ManagedClusterSelectorBuilder>{
  public ManagedClusterSelectorBuilder() {
    this(new ManagedClusterSelector());
  }
  
  public ManagedClusterSelectorBuilder(ManagedClusterSelectorFluent<?> fluent) {
    this(fluent, new ManagedClusterSelector());
  }
  
  public ManagedClusterSelectorBuilder(ManagedClusterSelectorFluent<?> fluent,ManagedClusterSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ManagedClusterSelectorBuilder(ManagedClusterSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ManagedClusterSelectorFluent<?> fluent;
  
  public ManagedClusterSelector build() {
    ManagedClusterSelector buildable = new ManagedClusterSelector(fluent.buildLabelSelector(),fluent.getSelectorType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}