package io.fabric8.openclustermanagement.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DiscoveredClusterSpecBuilder extends DiscoveredClusterSpecFluent<DiscoveredClusterSpecBuilder> implements VisitableBuilder<DiscoveredClusterSpec,DiscoveredClusterSpecBuilder>{
  public DiscoveredClusterSpecBuilder() {
    this(new DiscoveredClusterSpec());
  }
  
  public DiscoveredClusterSpecBuilder(DiscoveredClusterSpecFluent<?> fluent) {
    this(fluent, new DiscoveredClusterSpec());
  }
  
  public DiscoveredClusterSpecBuilder(DiscoveredClusterSpecFluent<?> fluent,DiscoveredClusterSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DiscoveredClusterSpecBuilder(DiscoveredClusterSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DiscoveredClusterSpecFluent<?> fluent;
  
  public DiscoveredClusterSpec build() {
    DiscoveredClusterSpec buildable = new DiscoveredClusterSpec(fluent.getActivityTimestamp(),fluent.getApiUrl(),fluent.getCloudProvider(),fluent.getConsole(),fluent.getCreationTimestamp(),fluent.buildCredential(),fluent.getDisplayName(),fluent.getImportAsManagedCluster(),fluent.getIsManagedCluster(),fluent.getName(),fluent.getOcpClusterId(),fluent.getOpenshiftVersion(),fluent.getOwner(),fluent.getRegion(),fluent.getRhocmClusterId(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}