package io.fabric8.openclustermanagement.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FilterBuilder extends FilterFluent<FilterBuilder> implements VisitableBuilder<Filter,FilterBuilder>{
  public FilterBuilder() {
    this(new Filter());
  }
  
  public FilterBuilder(FilterFluent<?> fluent) {
    this(fluent, new Filter());
  }
  
  public FilterBuilder(FilterFluent<?> fluent,Filter instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FilterBuilder(Filter instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FilterFluent<?> fluent;
  
  public Filter build() {
    Filter buildable = new Filter(fluent.getLastActive(),fluent.getOpenShiftVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}