package io.fabric8.openclustermanagement.api.model.observability.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StorageConfigObjectBuilder extends StorageConfigObjectFluent<StorageConfigObjectBuilder> implements VisitableBuilder<StorageConfigObject,StorageConfigObjectBuilder>{
  public StorageConfigObjectBuilder() {
    this(new StorageConfigObject());
  }
  
  public StorageConfigObjectBuilder(StorageConfigObjectFluent<?> fluent) {
    this(fluent, new StorageConfigObject());
  }
  
  public StorageConfigObjectBuilder(StorageConfigObjectFluent<?> fluent,StorageConfigObject instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StorageConfigObjectBuilder(StorageConfigObject instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StorageConfigObjectFluent<?> fluent;
  
  public StorageConfigObject build() {
    StorageConfigObject buildable = new StorageConfigObject(fluent.buildMetricObjectStorage(),fluent.getStatefulSetSize(),fluent.getStatefulSetStorageClass());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}