package io.fabric8.openclustermanagement.api.model.observability.v1beta2;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AdvancedConfigFluent<A extends AdvancedConfigFluent<A>> extends BaseFluent<A>{
  public AdvancedConfigFluent() {
  }
  
  public AdvancedConfigFluent(AdvancedConfig instance) {
    this.copyInstance(instance);
  }
  private AlertmanagerSpecBuilder alertmanager;
  private CompactSpecBuilder compact;
  private String customAlertmanagerHubURL;
  private String customObservabilityHubURL;
  private CommonSpecBuilder grafana;
  private CommonSpecBuilder multiClusterObservabilityAddon;
  private CommonSpecBuilder observatoriumAPI;
  private QuerySpecBuilder query;
  private QueryFrontendSpecBuilder queryFrontend;
  private CacheConfigBuilder queryFrontendMemcached;
  private CommonSpecBuilder rbacQueryProxy;
  private ReceiveSpecBuilder receive;
  private RetentionConfigBuilder retentionConfig;
  private RuleSpecBuilder rule;
  private StoreSpecBuilder store;
  private CacheConfigBuilder storeMemcached;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AdvancedConfig instance) {
    instance = (instance != null ? instance : new AdvancedConfig());
    if (instance != null) {
          this.withAlertmanager(instance.getAlertmanager());
          this.withCompact(instance.getCompact());
          this.withCustomAlertmanagerHubURL(instance.getCustomAlertmanagerHubURL());
          this.withCustomObservabilityHubURL(instance.getCustomObservabilityHubURL());
          this.withGrafana(instance.getGrafana());
          this.withMultiClusterObservabilityAddon(instance.getMultiClusterObservabilityAddon());
          this.withObservatoriumAPI(instance.getObservatoriumAPI());
          this.withQuery(instance.getQuery());
          this.withQueryFrontend(instance.getQueryFrontend());
          this.withQueryFrontendMemcached(instance.getQueryFrontendMemcached());
          this.withRbacQueryProxy(instance.getRbacQueryProxy());
          this.withReceive(instance.getReceive());
          this.withRetentionConfig(instance.getRetentionConfig());
          this.withRule(instance.getRule());
          this.withStore(instance.getStore());
          this.withStoreMemcached(instance.getStoreMemcached());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AlertmanagerSpec buildAlertmanager() {
    return this.alertmanager != null ? this.alertmanager.build() : null;
  }
  
  public A withAlertmanager(AlertmanagerSpec alertmanager) {
    this._visitables.remove("alertmanager");
    if (alertmanager != null) {
        this.alertmanager = new AlertmanagerSpecBuilder(alertmanager);
        this._visitables.get("alertmanager").add(this.alertmanager);
    } else {
        this.alertmanager = null;
        this._visitables.get("alertmanager").remove(this.alertmanager);
    }
    return (A) this;
  }
  
  public boolean hasAlertmanager() {
    return this.alertmanager != null;
  }
  
  public AlertmanagerNested<A> withNewAlertmanager() {
    return new AlertmanagerNested(null);
  }
  
  public AlertmanagerNested<A> withNewAlertmanagerLike(AlertmanagerSpec item) {
    return new AlertmanagerNested(item);
  }
  
  public AlertmanagerNested<A> editAlertmanager() {
    return withNewAlertmanagerLike(java.util.Optional.ofNullable(buildAlertmanager()).orElse(null));
  }
  
  public AlertmanagerNested<A> editOrNewAlertmanager() {
    return withNewAlertmanagerLike(java.util.Optional.ofNullable(buildAlertmanager()).orElse(new AlertmanagerSpecBuilder().build()));
  }
  
  public AlertmanagerNested<A> editOrNewAlertmanagerLike(AlertmanagerSpec item) {
    return withNewAlertmanagerLike(java.util.Optional.ofNullable(buildAlertmanager()).orElse(item));
  }
  
  public CompactSpec buildCompact() {
    return this.compact != null ? this.compact.build() : null;
  }
  
  public A withCompact(CompactSpec compact) {
    this._visitables.remove("compact");
    if (compact != null) {
        this.compact = new CompactSpecBuilder(compact);
        this._visitables.get("compact").add(this.compact);
    } else {
        this.compact = null;
        this._visitables.get("compact").remove(this.compact);
    }
    return (A) this;
  }
  
  public boolean hasCompact() {
    return this.compact != null;
  }
  
  public CompactNested<A> withNewCompact() {
    return new CompactNested(null);
  }
  
  public CompactNested<A> withNewCompactLike(CompactSpec item) {
    return new CompactNested(item);
  }
  
  public CompactNested<A> editCompact() {
    return withNewCompactLike(java.util.Optional.ofNullable(buildCompact()).orElse(null));
  }
  
  public CompactNested<A> editOrNewCompact() {
    return withNewCompactLike(java.util.Optional.ofNullable(buildCompact()).orElse(new CompactSpecBuilder().build()));
  }
  
  public CompactNested<A> editOrNewCompactLike(CompactSpec item) {
    return withNewCompactLike(java.util.Optional.ofNullable(buildCompact()).orElse(item));
  }
  
  public String getCustomAlertmanagerHubURL() {
    return this.customAlertmanagerHubURL;
  }
  
  public A withCustomAlertmanagerHubURL(String customAlertmanagerHubURL) {
    this.customAlertmanagerHubURL = customAlertmanagerHubURL;
    return (A) this;
  }
  
  public boolean hasCustomAlertmanagerHubURL() {
    return this.customAlertmanagerHubURL != null;
  }
  
  public String getCustomObservabilityHubURL() {
    return this.customObservabilityHubURL;
  }
  
  public A withCustomObservabilityHubURL(String customObservabilityHubURL) {
    this.customObservabilityHubURL = customObservabilityHubURL;
    return (A) this;
  }
  
  public boolean hasCustomObservabilityHubURL() {
    return this.customObservabilityHubURL != null;
  }
  
  public CommonSpec buildGrafana() {
    return this.grafana != null ? this.grafana.build() : null;
  }
  
  public A withGrafana(CommonSpec grafana) {
    this._visitables.remove("grafana");
    if (grafana != null) {
        this.grafana = new CommonSpecBuilder(grafana);
        this._visitables.get("grafana").add(this.grafana);
    } else {
        this.grafana = null;
        this._visitables.get("grafana").remove(this.grafana);
    }
    return (A) this;
  }
  
  public boolean hasGrafana() {
    return this.grafana != null;
  }
  
  public GrafanaNested<A> withNewGrafana() {
    return new GrafanaNested(null);
  }
  
  public GrafanaNested<A> withNewGrafanaLike(CommonSpec item) {
    return new GrafanaNested(item);
  }
  
  public GrafanaNested<A> editGrafana() {
    return withNewGrafanaLike(java.util.Optional.ofNullable(buildGrafana()).orElse(null));
  }
  
  public GrafanaNested<A> editOrNewGrafana() {
    return withNewGrafanaLike(java.util.Optional.ofNullable(buildGrafana()).orElse(new CommonSpecBuilder().build()));
  }
  
  public GrafanaNested<A> editOrNewGrafanaLike(CommonSpec item) {
    return withNewGrafanaLike(java.util.Optional.ofNullable(buildGrafana()).orElse(item));
  }
  
  public CommonSpec buildMultiClusterObservabilityAddon() {
    return this.multiClusterObservabilityAddon != null ? this.multiClusterObservabilityAddon.build() : null;
  }
  
  public A withMultiClusterObservabilityAddon(CommonSpec multiClusterObservabilityAddon) {
    this._visitables.remove("multiClusterObservabilityAddon");
    if (multiClusterObservabilityAddon != null) {
        this.multiClusterObservabilityAddon = new CommonSpecBuilder(multiClusterObservabilityAddon);
        this._visitables.get("multiClusterObservabilityAddon").add(this.multiClusterObservabilityAddon);
    } else {
        this.multiClusterObservabilityAddon = null;
        this._visitables.get("multiClusterObservabilityAddon").remove(this.multiClusterObservabilityAddon);
    }
    return (A) this;
  }
  
  public boolean hasMultiClusterObservabilityAddon() {
    return this.multiClusterObservabilityAddon != null;
  }
  
  public MultiClusterObservabilityAddonNested<A> withNewMultiClusterObservabilityAddon() {
    return new MultiClusterObservabilityAddonNested(null);
  }
  
  public MultiClusterObservabilityAddonNested<A> withNewMultiClusterObservabilityAddonLike(CommonSpec item) {
    return new MultiClusterObservabilityAddonNested(item);
  }
  
  public MultiClusterObservabilityAddonNested<A> editMultiClusterObservabilityAddon() {
    return withNewMultiClusterObservabilityAddonLike(java.util.Optional.ofNullable(buildMultiClusterObservabilityAddon()).orElse(null));
  }
  
  public MultiClusterObservabilityAddonNested<A> editOrNewMultiClusterObservabilityAddon() {
    return withNewMultiClusterObservabilityAddonLike(java.util.Optional.ofNullable(buildMultiClusterObservabilityAddon()).orElse(new CommonSpecBuilder().build()));
  }
  
  public MultiClusterObservabilityAddonNested<A> editOrNewMultiClusterObservabilityAddonLike(CommonSpec item) {
    return withNewMultiClusterObservabilityAddonLike(java.util.Optional.ofNullable(buildMultiClusterObservabilityAddon()).orElse(item));
  }
  
  public CommonSpec buildObservatoriumAPI() {
    return this.observatoriumAPI != null ? this.observatoriumAPI.build() : null;
  }
  
  public A withObservatoriumAPI(CommonSpec observatoriumAPI) {
    this._visitables.remove("observatoriumAPI");
    if (observatoriumAPI != null) {
        this.observatoriumAPI = new CommonSpecBuilder(observatoriumAPI);
        this._visitables.get("observatoriumAPI").add(this.observatoriumAPI);
    } else {
        this.observatoriumAPI = null;
        this._visitables.get("observatoriumAPI").remove(this.observatoriumAPI);
    }
    return (A) this;
  }
  
  public boolean hasObservatoriumAPI() {
    return this.observatoriumAPI != null;
  }
  
  public ObservatoriumAPINested<A> withNewObservatoriumAPI() {
    return new ObservatoriumAPINested(null);
  }
  
  public ObservatoriumAPINested<A> withNewObservatoriumAPILike(CommonSpec item) {
    return new ObservatoriumAPINested(item);
  }
  
  public ObservatoriumAPINested<A> editObservatoriumAPI() {
    return withNewObservatoriumAPILike(java.util.Optional.ofNullable(buildObservatoriumAPI()).orElse(null));
  }
  
  public ObservatoriumAPINested<A> editOrNewObservatoriumAPI() {
    return withNewObservatoriumAPILike(java.util.Optional.ofNullable(buildObservatoriumAPI()).orElse(new CommonSpecBuilder().build()));
  }
  
  public ObservatoriumAPINested<A> editOrNewObservatoriumAPILike(CommonSpec item) {
    return withNewObservatoriumAPILike(java.util.Optional.ofNullable(buildObservatoriumAPI()).orElse(item));
  }
  
  public QuerySpec buildQuery() {
    return this.query != null ? this.query.build() : null;
  }
  
  public A withQuery(QuerySpec query) {
    this._visitables.remove("query");
    if (query != null) {
        this.query = new QuerySpecBuilder(query);
        this._visitables.get("query").add(this.query);
    } else {
        this.query = null;
        this._visitables.get("query").remove(this.query);
    }
    return (A) this;
  }
  
  public boolean hasQuery() {
    return this.query != null;
  }
  
  public QueryNested<A> withNewQuery() {
    return new QueryNested(null);
  }
  
  public QueryNested<A> withNewQueryLike(QuerySpec item) {
    return new QueryNested(item);
  }
  
  public QueryNested<A> editQuery() {
    return withNewQueryLike(java.util.Optional.ofNullable(buildQuery()).orElse(null));
  }
  
  public QueryNested<A> editOrNewQuery() {
    return withNewQueryLike(java.util.Optional.ofNullable(buildQuery()).orElse(new QuerySpecBuilder().build()));
  }
  
  public QueryNested<A> editOrNewQueryLike(QuerySpec item) {
    return withNewQueryLike(java.util.Optional.ofNullable(buildQuery()).orElse(item));
  }
  
  public QueryFrontendSpec buildQueryFrontend() {
    return this.queryFrontend != null ? this.queryFrontend.build() : null;
  }
  
  public A withQueryFrontend(QueryFrontendSpec queryFrontend) {
    this._visitables.remove("queryFrontend");
    if (queryFrontend != null) {
        this.queryFrontend = new QueryFrontendSpecBuilder(queryFrontend);
        this._visitables.get("queryFrontend").add(this.queryFrontend);
    } else {
        this.queryFrontend = null;
        this._visitables.get("queryFrontend").remove(this.queryFrontend);
    }
    return (A) this;
  }
  
  public boolean hasQueryFrontend() {
    return this.queryFrontend != null;
  }
  
  public QueryFrontendNested<A> withNewQueryFrontend() {
    return new QueryFrontendNested(null);
  }
  
  public QueryFrontendNested<A> withNewQueryFrontendLike(QueryFrontendSpec item) {
    return new QueryFrontendNested(item);
  }
  
  public QueryFrontendNested<A> editQueryFrontend() {
    return withNewQueryFrontendLike(java.util.Optional.ofNullable(buildQueryFrontend()).orElse(null));
  }
  
  public QueryFrontendNested<A> editOrNewQueryFrontend() {
    return withNewQueryFrontendLike(java.util.Optional.ofNullable(buildQueryFrontend()).orElse(new QueryFrontendSpecBuilder().build()));
  }
  
  public QueryFrontendNested<A> editOrNewQueryFrontendLike(QueryFrontendSpec item) {
    return withNewQueryFrontendLike(java.util.Optional.ofNullable(buildQueryFrontend()).orElse(item));
  }
  
  public CacheConfig buildQueryFrontendMemcached() {
    return this.queryFrontendMemcached != null ? this.queryFrontendMemcached.build() : null;
  }
  
  public A withQueryFrontendMemcached(CacheConfig queryFrontendMemcached) {
    this._visitables.remove("queryFrontendMemcached");
    if (queryFrontendMemcached != null) {
        this.queryFrontendMemcached = new CacheConfigBuilder(queryFrontendMemcached);
        this._visitables.get("queryFrontendMemcached").add(this.queryFrontendMemcached);
    } else {
        this.queryFrontendMemcached = null;
        this._visitables.get("queryFrontendMemcached").remove(this.queryFrontendMemcached);
    }
    return (A) this;
  }
  
  public boolean hasQueryFrontendMemcached() {
    return this.queryFrontendMemcached != null;
  }
  
  public QueryFrontendMemcachedNested<A> withNewQueryFrontendMemcached() {
    return new QueryFrontendMemcachedNested(null);
  }
  
  public QueryFrontendMemcachedNested<A> withNewQueryFrontendMemcachedLike(CacheConfig item) {
    return new QueryFrontendMemcachedNested(item);
  }
  
  public QueryFrontendMemcachedNested<A> editQueryFrontendMemcached() {
    return withNewQueryFrontendMemcachedLike(java.util.Optional.ofNullable(buildQueryFrontendMemcached()).orElse(null));
  }
  
  public QueryFrontendMemcachedNested<A> editOrNewQueryFrontendMemcached() {
    return withNewQueryFrontendMemcachedLike(java.util.Optional.ofNullable(buildQueryFrontendMemcached()).orElse(new CacheConfigBuilder().build()));
  }
  
  public QueryFrontendMemcachedNested<A> editOrNewQueryFrontendMemcachedLike(CacheConfig item) {
    return withNewQueryFrontendMemcachedLike(java.util.Optional.ofNullable(buildQueryFrontendMemcached()).orElse(item));
  }
  
  public CommonSpec buildRbacQueryProxy() {
    return this.rbacQueryProxy != null ? this.rbacQueryProxy.build() : null;
  }
  
  public A withRbacQueryProxy(CommonSpec rbacQueryProxy) {
    this._visitables.remove("rbacQueryProxy");
    if (rbacQueryProxy != null) {
        this.rbacQueryProxy = new CommonSpecBuilder(rbacQueryProxy);
        this._visitables.get("rbacQueryProxy").add(this.rbacQueryProxy);
    } else {
        this.rbacQueryProxy = null;
        this._visitables.get("rbacQueryProxy").remove(this.rbacQueryProxy);
    }
    return (A) this;
  }
  
  public boolean hasRbacQueryProxy() {
    return this.rbacQueryProxy != null;
  }
  
  public RbacQueryProxyNested<A> withNewRbacQueryProxy() {
    return new RbacQueryProxyNested(null);
  }
  
  public RbacQueryProxyNested<A> withNewRbacQueryProxyLike(CommonSpec item) {
    return new RbacQueryProxyNested(item);
  }
  
  public RbacQueryProxyNested<A> editRbacQueryProxy() {
    return withNewRbacQueryProxyLike(java.util.Optional.ofNullable(buildRbacQueryProxy()).orElse(null));
  }
  
  public RbacQueryProxyNested<A> editOrNewRbacQueryProxy() {
    return withNewRbacQueryProxyLike(java.util.Optional.ofNullable(buildRbacQueryProxy()).orElse(new CommonSpecBuilder().build()));
  }
  
  public RbacQueryProxyNested<A> editOrNewRbacQueryProxyLike(CommonSpec item) {
    return withNewRbacQueryProxyLike(java.util.Optional.ofNullable(buildRbacQueryProxy()).orElse(item));
  }
  
  public ReceiveSpec buildReceive() {
    return this.receive != null ? this.receive.build() : null;
  }
  
  public A withReceive(ReceiveSpec receive) {
    this._visitables.remove("receive");
    if (receive != null) {
        this.receive = new ReceiveSpecBuilder(receive);
        this._visitables.get("receive").add(this.receive);
    } else {
        this.receive = null;
        this._visitables.get("receive").remove(this.receive);
    }
    return (A) this;
  }
  
  public boolean hasReceive() {
    return this.receive != null;
  }
  
  public ReceiveNested<A> withNewReceive() {
    return new ReceiveNested(null);
  }
  
  public ReceiveNested<A> withNewReceiveLike(ReceiveSpec item) {
    return new ReceiveNested(item);
  }
  
  public ReceiveNested<A> editReceive() {
    return withNewReceiveLike(java.util.Optional.ofNullable(buildReceive()).orElse(null));
  }
  
  public ReceiveNested<A> editOrNewReceive() {
    return withNewReceiveLike(java.util.Optional.ofNullable(buildReceive()).orElse(new ReceiveSpecBuilder().build()));
  }
  
  public ReceiveNested<A> editOrNewReceiveLike(ReceiveSpec item) {
    return withNewReceiveLike(java.util.Optional.ofNullable(buildReceive()).orElse(item));
  }
  
  public RetentionConfig buildRetentionConfig() {
    return this.retentionConfig != null ? this.retentionConfig.build() : null;
  }
  
  public A withRetentionConfig(RetentionConfig retentionConfig) {
    this._visitables.remove("retentionConfig");
    if (retentionConfig != null) {
        this.retentionConfig = new RetentionConfigBuilder(retentionConfig);
        this._visitables.get("retentionConfig").add(this.retentionConfig);
    } else {
        this.retentionConfig = null;
        this._visitables.get("retentionConfig").remove(this.retentionConfig);
    }
    return (A) this;
  }
  
  public boolean hasRetentionConfig() {
    return this.retentionConfig != null;
  }
  
  public RetentionConfigNested<A> withNewRetentionConfig() {
    return new RetentionConfigNested(null);
  }
  
  public RetentionConfigNested<A> withNewRetentionConfigLike(RetentionConfig item) {
    return new RetentionConfigNested(item);
  }
  
  public RetentionConfigNested<A> editRetentionConfig() {
    return withNewRetentionConfigLike(java.util.Optional.ofNullable(buildRetentionConfig()).orElse(null));
  }
  
  public RetentionConfigNested<A> editOrNewRetentionConfig() {
    return withNewRetentionConfigLike(java.util.Optional.ofNullable(buildRetentionConfig()).orElse(new RetentionConfigBuilder().build()));
  }
  
  public RetentionConfigNested<A> editOrNewRetentionConfigLike(RetentionConfig item) {
    return withNewRetentionConfigLike(java.util.Optional.ofNullable(buildRetentionConfig()).orElse(item));
  }
  
  public RuleSpec buildRule() {
    return this.rule != null ? this.rule.build() : null;
  }
  
  public A withRule(RuleSpec rule) {
    this._visitables.remove("rule");
    if (rule != null) {
        this.rule = new RuleSpecBuilder(rule);
        this._visitables.get("rule").add(this.rule);
    } else {
        this.rule = null;
        this._visitables.get("rule").remove(this.rule);
    }
    return (A) this;
  }
  
  public boolean hasRule() {
    return this.rule != null;
  }
  
  public RuleNested<A> withNewRule() {
    return new RuleNested(null);
  }
  
  public RuleNested<A> withNewRuleLike(RuleSpec item) {
    return new RuleNested(item);
  }
  
  public RuleNested<A> editRule() {
    return withNewRuleLike(java.util.Optional.ofNullable(buildRule()).orElse(null));
  }
  
  public RuleNested<A> editOrNewRule() {
    return withNewRuleLike(java.util.Optional.ofNullable(buildRule()).orElse(new RuleSpecBuilder().build()));
  }
  
  public RuleNested<A> editOrNewRuleLike(RuleSpec item) {
    return withNewRuleLike(java.util.Optional.ofNullable(buildRule()).orElse(item));
  }
  
  public StoreSpec buildStore() {
    return this.store != null ? this.store.build() : null;
  }
  
  public A withStore(StoreSpec store) {
    this._visitables.remove("store");
    if (store != null) {
        this.store = new StoreSpecBuilder(store);
        this._visitables.get("store").add(this.store);
    } else {
        this.store = null;
        this._visitables.get("store").remove(this.store);
    }
    return (A) this;
  }
  
  public boolean hasStore() {
    return this.store != null;
  }
  
  public StoreNested<A> withNewStore() {
    return new StoreNested(null);
  }
  
  public StoreNested<A> withNewStoreLike(StoreSpec item) {
    return new StoreNested(item);
  }
  
  public StoreNested<A> editStore() {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(null));
  }
  
  public StoreNested<A> editOrNewStore() {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(new StoreSpecBuilder().build()));
  }
  
  public StoreNested<A> editOrNewStoreLike(StoreSpec item) {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(item));
  }
  
  public CacheConfig buildStoreMemcached() {
    return this.storeMemcached != null ? this.storeMemcached.build() : null;
  }
  
  public A withStoreMemcached(CacheConfig storeMemcached) {
    this._visitables.remove("storeMemcached");
    if (storeMemcached != null) {
        this.storeMemcached = new CacheConfigBuilder(storeMemcached);
        this._visitables.get("storeMemcached").add(this.storeMemcached);
    } else {
        this.storeMemcached = null;
        this._visitables.get("storeMemcached").remove(this.storeMemcached);
    }
    return (A) this;
  }
  
  public boolean hasStoreMemcached() {
    return this.storeMemcached != null;
  }
  
  public StoreMemcachedNested<A> withNewStoreMemcached() {
    return new StoreMemcachedNested(null);
  }
  
  public StoreMemcachedNested<A> withNewStoreMemcachedLike(CacheConfig item) {
    return new StoreMemcachedNested(item);
  }
  
  public StoreMemcachedNested<A> editStoreMemcached() {
    return withNewStoreMemcachedLike(java.util.Optional.ofNullable(buildStoreMemcached()).orElse(null));
  }
  
  public StoreMemcachedNested<A> editOrNewStoreMemcached() {
    return withNewStoreMemcachedLike(java.util.Optional.ofNullable(buildStoreMemcached()).orElse(new CacheConfigBuilder().build()));
  }
  
  public StoreMemcachedNested<A> editOrNewStoreMemcachedLike(CacheConfig item) {
    return withNewStoreMemcachedLike(java.util.Optional.ofNullable(buildStoreMemcached()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AdvancedConfigFluent that = (AdvancedConfigFluent) o;
    if (!java.util.Objects.equals(alertmanager, that.alertmanager)) return false;
    if (!java.util.Objects.equals(compact, that.compact)) return false;
    if (!java.util.Objects.equals(customAlertmanagerHubURL, that.customAlertmanagerHubURL)) return false;
    if (!java.util.Objects.equals(customObservabilityHubURL, that.customObservabilityHubURL)) return false;
    if (!java.util.Objects.equals(grafana, that.grafana)) return false;
    if (!java.util.Objects.equals(multiClusterObservabilityAddon, that.multiClusterObservabilityAddon)) return false;
    if (!java.util.Objects.equals(observatoriumAPI, that.observatoriumAPI)) return false;
    if (!java.util.Objects.equals(query, that.query)) return false;
    if (!java.util.Objects.equals(queryFrontend, that.queryFrontend)) return false;
    if (!java.util.Objects.equals(queryFrontendMemcached, that.queryFrontendMemcached)) return false;
    if (!java.util.Objects.equals(rbacQueryProxy, that.rbacQueryProxy)) return false;
    if (!java.util.Objects.equals(receive, that.receive)) return false;
    if (!java.util.Objects.equals(retentionConfig, that.retentionConfig)) return false;
    if (!java.util.Objects.equals(rule, that.rule)) return false;
    if (!java.util.Objects.equals(store, that.store)) return false;
    if (!java.util.Objects.equals(storeMemcached, that.storeMemcached)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(alertmanager,  compact,  customAlertmanagerHubURL,  customObservabilityHubURL,  grafana,  multiClusterObservabilityAddon,  observatoriumAPI,  query,  queryFrontend,  queryFrontendMemcached,  rbacQueryProxy,  receive,  retentionConfig,  rule,  store,  storeMemcached,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alertmanager != null) { sb.append("alertmanager:"); sb.append(alertmanager + ","); }
    if (compact != null) { sb.append("compact:"); sb.append(compact + ","); }
    if (customAlertmanagerHubURL != null) { sb.append("customAlertmanagerHubURL:"); sb.append(customAlertmanagerHubURL + ","); }
    if (customObservabilityHubURL != null) { sb.append("customObservabilityHubURL:"); sb.append(customObservabilityHubURL + ","); }
    if (grafana != null) { sb.append("grafana:"); sb.append(grafana + ","); }
    if (multiClusterObservabilityAddon != null) { sb.append("multiClusterObservabilityAddon:"); sb.append(multiClusterObservabilityAddon + ","); }
    if (observatoriumAPI != null) { sb.append("observatoriumAPI:"); sb.append(observatoriumAPI + ","); }
    if (query != null) { sb.append("query:"); sb.append(query + ","); }
    if (queryFrontend != null) { sb.append("queryFrontend:"); sb.append(queryFrontend + ","); }
    if (queryFrontendMemcached != null) { sb.append("queryFrontendMemcached:"); sb.append(queryFrontendMemcached + ","); }
    if (rbacQueryProxy != null) { sb.append("rbacQueryProxy:"); sb.append(rbacQueryProxy + ","); }
    if (receive != null) { sb.append("receive:"); sb.append(receive + ","); }
    if (retentionConfig != null) { sb.append("retentionConfig:"); sb.append(retentionConfig + ","); }
    if (rule != null) { sb.append("rule:"); sb.append(rule + ","); }
    if (store != null) { sb.append("store:"); sb.append(store + ","); }
    if (storeMemcached != null) { sb.append("storeMemcached:"); sb.append(storeMemcached + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AlertmanagerNested<N> extends AlertmanagerSpecFluent<AlertmanagerNested<N>> implements Nested<N>{
    AlertmanagerNested(AlertmanagerSpec item) {
      this.builder = new AlertmanagerSpecBuilder(this, item);
    }
    AlertmanagerSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withAlertmanager(builder.build());
    }
    
    public N endAlertmanager() {
      return and();
    }
    
  
  }
  public class CompactNested<N> extends CompactSpecFluent<CompactNested<N>> implements Nested<N>{
    CompactNested(CompactSpec item) {
      this.builder = new CompactSpecBuilder(this, item);
    }
    CompactSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withCompact(builder.build());
    }
    
    public N endCompact() {
      return and();
    }
    
  
  }
  public class GrafanaNested<N> extends CommonSpecFluent<GrafanaNested<N>> implements Nested<N>{
    GrafanaNested(CommonSpec item) {
      this.builder = new CommonSpecBuilder(this, item);
    }
    CommonSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withGrafana(builder.build());
    }
    
    public N endGrafana() {
      return and();
    }
    
  
  }
  public class MultiClusterObservabilityAddonNested<N> extends CommonSpecFluent<MultiClusterObservabilityAddonNested<N>> implements Nested<N>{
    MultiClusterObservabilityAddonNested(CommonSpec item) {
      this.builder = new CommonSpecBuilder(this, item);
    }
    CommonSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withMultiClusterObservabilityAddon(builder.build());
    }
    
    public N endMultiClusterObservabilityAddon() {
      return and();
    }
    
  
  }
  public class ObservatoriumAPINested<N> extends CommonSpecFluent<ObservatoriumAPINested<N>> implements Nested<N>{
    ObservatoriumAPINested(CommonSpec item) {
      this.builder = new CommonSpecBuilder(this, item);
    }
    CommonSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withObservatoriumAPI(builder.build());
    }
    
    public N endObservatoriumAPI() {
      return and();
    }
    
  
  }
  public class QueryNested<N> extends QuerySpecFluent<QueryNested<N>> implements Nested<N>{
    QueryNested(QuerySpec item) {
      this.builder = new QuerySpecBuilder(this, item);
    }
    QuerySpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withQuery(builder.build());
    }
    
    public N endQuery() {
      return and();
    }
    
  
  }
  public class QueryFrontendNested<N> extends QueryFrontendSpecFluent<QueryFrontendNested<N>> implements Nested<N>{
    QueryFrontendNested(QueryFrontendSpec item) {
      this.builder = new QueryFrontendSpecBuilder(this, item);
    }
    QueryFrontendSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withQueryFrontend(builder.build());
    }
    
    public N endQueryFrontend() {
      return and();
    }
    
  
  }
  public class QueryFrontendMemcachedNested<N> extends CacheConfigFluent<QueryFrontendMemcachedNested<N>> implements Nested<N>{
    QueryFrontendMemcachedNested(CacheConfig item) {
      this.builder = new CacheConfigBuilder(this, item);
    }
    CacheConfigBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withQueryFrontendMemcached(builder.build());
    }
    
    public N endQueryFrontendMemcached() {
      return and();
    }
    
  
  }
  public class RbacQueryProxyNested<N> extends CommonSpecFluent<RbacQueryProxyNested<N>> implements Nested<N>{
    RbacQueryProxyNested(CommonSpec item) {
      this.builder = new CommonSpecBuilder(this, item);
    }
    CommonSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withRbacQueryProxy(builder.build());
    }
    
    public N endRbacQueryProxy() {
      return and();
    }
    
  
  }
  public class ReceiveNested<N> extends ReceiveSpecFluent<ReceiveNested<N>> implements Nested<N>{
    ReceiveNested(ReceiveSpec item) {
      this.builder = new ReceiveSpecBuilder(this, item);
    }
    ReceiveSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withReceive(builder.build());
    }
    
    public N endReceive() {
      return and();
    }
    
  
  }
  public class RetentionConfigNested<N> extends RetentionConfigFluent<RetentionConfigNested<N>> implements Nested<N>{
    RetentionConfigNested(RetentionConfig item) {
      this.builder = new RetentionConfigBuilder(this, item);
    }
    RetentionConfigBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withRetentionConfig(builder.build());
    }
    
    public N endRetentionConfig() {
      return and();
    }
    
  
  }
  public class RuleNested<N> extends RuleSpecFluent<RuleNested<N>> implements Nested<N>{
    RuleNested(RuleSpec item) {
      this.builder = new RuleSpecBuilder(this, item);
    }
    RuleSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withRule(builder.build());
    }
    
    public N endRule() {
      return and();
    }
    
  
  }
  public class StoreNested<N> extends StoreSpecFluent<StoreNested<N>> implements Nested<N>{
    StoreNested(StoreSpec item) {
      this.builder = new StoreSpecBuilder(this, item);
    }
    StoreSpecBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withStore(builder.build());
    }
    
    public N endStore() {
      return and();
    }
    
  
  }
  public class StoreMemcachedNested<N> extends CacheConfigFluent<StoreMemcachedNested<N>> implements Nested<N>{
    StoreMemcachedNested(CacheConfig item) {
      this.builder = new CacheConfigBuilder(this, item);
    }
    CacheConfigBuilder builder;
    
    public N and() {
      return (N) AdvancedConfigFluent.this.withStoreMemcached(builder.build());
    }
    
    public N endStoreMemcached() {
      return and();
    }
    
  
  }

}