package io.fabric8.openclustermanagement.api.model.observability.v1beta2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CapabilitiesSpecFluent<A extends CapabilitiesSpecFluent<A>> extends BaseFluent<A>{
  public CapabilitiesSpecFluent() {
  }
  
  public CapabilitiesSpecFluent(CapabilitiesSpec instance) {
    this.copyInstance(instance);
  }
  private PlatformCapabilitiesSpecBuilder platform;
  private UserWorkloadCapabilitiesSpecBuilder userWorkloads;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CapabilitiesSpec instance) {
    instance = (instance != null ? instance : new CapabilitiesSpec());
    if (instance != null) {
          this.withPlatform(instance.getPlatform());
          this.withUserWorkloads(instance.getUserWorkloads());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public PlatformCapabilitiesSpec buildPlatform() {
    return this.platform != null ? this.platform.build() : null;
  }
  
  public A withPlatform(PlatformCapabilitiesSpec platform) {
    this._visitables.remove("platform");
    if (platform != null) {
        this.platform = new PlatformCapabilitiesSpecBuilder(platform);
        this._visitables.get("platform").add(this.platform);
    } else {
        this.platform = null;
        this._visitables.get("platform").remove(this.platform);
    }
    return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public PlatformNested<A> withNewPlatform() {
    return new PlatformNested(null);
  }
  
  public PlatformNested<A> withNewPlatformLike(PlatformCapabilitiesSpec item) {
    return new PlatformNested(item);
  }
  
  public PlatformNested<A> editPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(null));
  }
  
  public PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(new PlatformCapabilitiesSpecBuilder().build()));
  }
  
  public PlatformNested<A> editOrNewPlatformLike(PlatformCapabilitiesSpec item) {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(item));
  }
  
  public UserWorkloadCapabilitiesSpec buildUserWorkloads() {
    return this.userWorkloads != null ? this.userWorkloads.build() : null;
  }
  
  public A withUserWorkloads(UserWorkloadCapabilitiesSpec userWorkloads) {
    this._visitables.remove("userWorkloads");
    if (userWorkloads != null) {
        this.userWorkloads = new UserWorkloadCapabilitiesSpecBuilder(userWorkloads);
        this._visitables.get("userWorkloads").add(this.userWorkloads);
    } else {
        this.userWorkloads = null;
        this._visitables.get("userWorkloads").remove(this.userWorkloads);
    }
    return (A) this;
  }
  
  public boolean hasUserWorkloads() {
    return this.userWorkloads != null;
  }
  
  public UserWorkloadsNested<A> withNewUserWorkloads() {
    return new UserWorkloadsNested(null);
  }
  
  public UserWorkloadsNested<A> withNewUserWorkloadsLike(UserWorkloadCapabilitiesSpec item) {
    return new UserWorkloadsNested(item);
  }
  
  public UserWorkloadsNested<A> editUserWorkloads() {
    return withNewUserWorkloadsLike(java.util.Optional.ofNullable(buildUserWorkloads()).orElse(null));
  }
  
  public UserWorkloadsNested<A> editOrNewUserWorkloads() {
    return withNewUserWorkloadsLike(java.util.Optional.ofNullable(buildUserWorkloads()).orElse(new UserWorkloadCapabilitiesSpecBuilder().build()));
  }
  
  public UserWorkloadsNested<A> editOrNewUserWorkloadsLike(UserWorkloadCapabilitiesSpec item) {
    return withNewUserWorkloadsLike(java.util.Optional.ofNullable(buildUserWorkloads()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CapabilitiesSpecFluent that = (CapabilitiesSpecFluent) o;
    if (!java.util.Objects.equals(platform, that.platform)) return false;
    if (!java.util.Objects.equals(userWorkloads, that.userWorkloads)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(platform,  userWorkloads,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (userWorkloads != null) { sb.append("userWorkloads:"); sb.append(userWorkloads + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PlatformNested<N> extends PlatformCapabilitiesSpecFluent<PlatformNested<N>> implements Nested<N>{
    PlatformNested(PlatformCapabilitiesSpec item) {
      this.builder = new PlatformCapabilitiesSpecBuilder(this, item);
    }
    PlatformCapabilitiesSpecBuilder builder;
    
    public N and() {
      return (N) CapabilitiesSpecFluent.this.withPlatform(builder.build());
    }
    
    public N endPlatform() {
      return and();
    }
    
  
  }
  public class UserWorkloadsNested<N> extends UserWorkloadCapabilitiesSpecFluent<UserWorkloadsNested<N>> implements Nested<N>{
    UserWorkloadsNested(UserWorkloadCapabilitiesSpec item) {
      this.builder = new UserWorkloadCapabilitiesSpecBuilder(this, item);
    }
    UserWorkloadCapabilitiesSpecBuilder builder;
    
    public N and() {
      return (N) CapabilitiesSpecFluent.this.withUserWorkloads(builder.build());
    }
    
    public N endUserWorkloads() {
      return and();
    }
    
  
  }

}