package io.fabric8.openclustermanagement.api.model.observability.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenTelemetryCollectionSpecBuilder extends OpenTelemetryCollectionSpecFluent<OpenTelemetryCollectionSpecBuilder> implements VisitableBuilder<OpenTelemetryCollectionSpec,OpenTelemetryCollectionSpecBuilder>{
  public OpenTelemetryCollectionSpecBuilder() {
    this(new OpenTelemetryCollectionSpec());
  }
  
  public OpenTelemetryCollectionSpecBuilder(OpenTelemetryCollectionSpecFluent<?> fluent) {
    this(fluent, new OpenTelemetryCollectionSpec());
  }
  
  public OpenTelemetryCollectionSpecBuilder(OpenTelemetryCollectionSpecFluent<?> fluent,OpenTelemetryCollectionSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenTelemetryCollectionSpecBuilder(OpenTelemetryCollectionSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenTelemetryCollectionSpecFluent<?> fluent;
  
  public OpenTelemetryCollectionSpec build() {
    OpenTelemetryCollectionSpec buildable = new OpenTelemetryCollectionSpec(fluent.buildCollector(),fluent.buildInstrumentation());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}