package io.fabric8.openclustermanagement.api.model.observability.v1beta2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OpenTelemetryCollectionSpecFluent<A extends OpenTelemetryCollectionSpecFluent<A>> extends BaseFluent<A>{
  public OpenTelemetryCollectionSpecFluent() {
  }
  
  public OpenTelemetryCollectionSpecFluent(OpenTelemetryCollectionSpec instance) {
    this.copyInstance(instance);
  }
  private OpenTelemetryCollectorSpecBuilder collector;
  private InstrumentationSpecBuilder instrumentation;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OpenTelemetryCollectionSpec instance) {
    instance = (instance != null ? instance : new OpenTelemetryCollectionSpec());
    if (instance != null) {
          this.withCollector(instance.getCollector());
          this.withInstrumentation(instance.getInstrumentation());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public OpenTelemetryCollectorSpec buildCollector() {
    return this.collector != null ? this.collector.build() : null;
  }
  
  public A withCollector(OpenTelemetryCollectorSpec collector) {
    this._visitables.remove("collector");
    if (collector != null) {
        this.collector = new OpenTelemetryCollectorSpecBuilder(collector);
        this._visitables.get("collector").add(this.collector);
    } else {
        this.collector = null;
        this._visitables.get("collector").remove(this.collector);
    }
    return (A) this;
  }
  
  public boolean hasCollector() {
    return this.collector != null;
  }
  
  public A withNewCollector(Boolean enabled) {
    return (A)withCollector(new OpenTelemetryCollectorSpec(enabled));
  }
  
  public CollectorNested<A> withNewCollector() {
    return new CollectorNested(null);
  }
  
  public CollectorNested<A> withNewCollectorLike(OpenTelemetryCollectorSpec item) {
    return new CollectorNested(item);
  }
  
  public CollectorNested<A> editCollector() {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(null));
  }
  
  public CollectorNested<A> editOrNewCollector() {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(new OpenTelemetryCollectorSpecBuilder().build()));
  }
  
  public CollectorNested<A> editOrNewCollectorLike(OpenTelemetryCollectorSpec item) {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(item));
  }
  
  public InstrumentationSpec buildInstrumentation() {
    return this.instrumentation != null ? this.instrumentation.build() : null;
  }
  
  public A withInstrumentation(InstrumentationSpec instrumentation) {
    this._visitables.remove("instrumentation");
    if (instrumentation != null) {
        this.instrumentation = new InstrumentationSpecBuilder(instrumentation);
        this._visitables.get("instrumentation").add(this.instrumentation);
    } else {
        this.instrumentation = null;
        this._visitables.get("instrumentation").remove(this.instrumentation);
    }
    return (A) this;
  }
  
  public boolean hasInstrumentation() {
    return this.instrumentation != null;
  }
  
  public A withNewInstrumentation(Boolean enabled) {
    return (A)withInstrumentation(new InstrumentationSpec(enabled));
  }
  
  public InstrumentationNested<A> withNewInstrumentation() {
    return new InstrumentationNested(null);
  }
  
  public InstrumentationNested<A> withNewInstrumentationLike(InstrumentationSpec item) {
    return new InstrumentationNested(item);
  }
  
  public InstrumentationNested<A> editInstrumentation() {
    return withNewInstrumentationLike(java.util.Optional.ofNullable(buildInstrumentation()).orElse(null));
  }
  
  public InstrumentationNested<A> editOrNewInstrumentation() {
    return withNewInstrumentationLike(java.util.Optional.ofNullable(buildInstrumentation()).orElse(new InstrumentationSpecBuilder().build()));
  }
  
  public InstrumentationNested<A> editOrNewInstrumentationLike(InstrumentationSpec item) {
    return withNewInstrumentationLike(java.util.Optional.ofNullable(buildInstrumentation()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenTelemetryCollectionSpecFluent that = (OpenTelemetryCollectionSpecFluent) o;
    if (!java.util.Objects.equals(collector, that.collector)) return false;
    if (!java.util.Objects.equals(instrumentation, that.instrumentation)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(collector,  instrumentation,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (collector != null) { sb.append("collector:"); sb.append(collector + ","); }
    if (instrumentation != null) { sb.append("instrumentation:"); sb.append(instrumentation + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CollectorNested<N> extends OpenTelemetryCollectorSpecFluent<CollectorNested<N>> implements Nested<N>{
    CollectorNested(OpenTelemetryCollectorSpec item) {
      this.builder = new OpenTelemetryCollectorSpecBuilder(this, item);
    }
    OpenTelemetryCollectorSpecBuilder builder;
    
    public N and() {
      return (N) OpenTelemetryCollectionSpecFluent.this.withCollector(builder.build());
    }
    
    public N endCollector() {
      return and();
    }
    
  
  }
  public class InstrumentationNested<N> extends InstrumentationSpecFluent<InstrumentationNested<N>> implements Nested<N>{
    InstrumentationNested(InstrumentationSpec item) {
      this.builder = new InstrumentationSpecBuilder(this, item);
    }
    InstrumentationSpecBuilder builder;
    
    public N and() {
      return (N) OpenTelemetryCollectionSpecFluent.this.withInstrumentation(builder.build());
    }
    
    public N endInstrumentation() {
      return and();
    }
    
  
  }

}