package io.fabric8.openclustermanagement.api.model.observability.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorage;
import io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorageBuilder;
import io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorageFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StorageConfigFluent<A extends StorageConfigFluent<A>> extends BaseFluent<A>{
  public StorageConfigFluent() {
  }
  
  public StorageConfigFluent(StorageConfig instance) {
    this.copyInstance(instance);
  }
  private String alertmanagerStorageSize;
  private String compactStorageSize;
  private PreConfiguredStorageBuilder metricObjectStorage;
  private String receiveStorageSize;
  private String ruleStorageSize;
  private String storageClass;
  private String storeStorageSize;
  private ArrayList<PreConfiguredStorageBuilder> writeStorage = new ArrayList<PreConfiguredStorageBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StorageConfig instance) {
    instance = (instance != null ? instance : new StorageConfig());
    if (instance != null) {
          this.withAlertmanagerStorageSize(instance.getAlertmanagerStorageSize());
          this.withCompactStorageSize(instance.getCompactStorageSize());
          this.withMetricObjectStorage(instance.getMetricObjectStorage());
          this.withReceiveStorageSize(instance.getReceiveStorageSize());
          this.withRuleStorageSize(instance.getRuleStorageSize());
          this.withStorageClass(instance.getStorageClass());
          this.withStoreStorageSize(instance.getStoreStorageSize());
          this.withWriteStorage(instance.getWriteStorage());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAlertmanagerStorageSize() {
    return this.alertmanagerStorageSize;
  }
  
  public A withAlertmanagerStorageSize(String alertmanagerStorageSize) {
    this.alertmanagerStorageSize = alertmanagerStorageSize;
    return (A) this;
  }
  
  public boolean hasAlertmanagerStorageSize() {
    return this.alertmanagerStorageSize != null;
  }
  
  public String getCompactStorageSize() {
    return this.compactStorageSize;
  }
  
  public A withCompactStorageSize(String compactStorageSize) {
    this.compactStorageSize = compactStorageSize;
    return (A) this;
  }
  
  public boolean hasCompactStorageSize() {
    return this.compactStorageSize != null;
  }
  
  public PreConfiguredStorage buildMetricObjectStorage() {
    return this.metricObjectStorage != null ? this.metricObjectStorage.build() : null;
  }
  
  public A withMetricObjectStorage(PreConfiguredStorage metricObjectStorage) {
    this._visitables.remove("metricObjectStorage");
    if (metricObjectStorage != null) {
        this.metricObjectStorage = new PreConfiguredStorageBuilder(metricObjectStorage);
        this._visitables.get("metricObjectStorage").add(this.metricObjectStorage);
    } else {
        this.metricObjectStorage = null;
        this._visitables.get("metricObjectStorage").remove(this.metricObjectStorage);
    }
    return (A) this;
  }
  
  public boolean hasMetricObjectStorage() {
    return this.metricObjectStorage != null;
  }
  
  public A withNewMetricObjectStorage(String key,String name,Boolean serviceAccountProjection,String tlsSecretMountPath,String tlsSecretName) {
    return (A)withMetricObjectStorage(new PreConfiguredStorage(key, name, serviceAccountProjection, tlsSecretMountPath, tlsSecretName));
  }
  
  public MetricObjectStorageNested<A> withNewMetricObjectStorage() {
    return new MetricObjectStorageNested(null);
  }
  
  public MetricObjectStorageNested<A> withNewMetricObjectStorageLike(PreConfiguredStorage item) {
    return new MetricObjectStorageNested(item);
  }
  
  public MetricObjectStorageNested<A> editMetricObjectStorage() {
    return withNewMetricObjectStorageLike(java.util.Optional.ofNullable(buildMetricObjectStorage()).orElse(null));
  }
  
  public MetricObjectStorageNested<A> editOrNewMetricObjectStorage() {
    return withNewMetricObjectStorageLike(java.util.Optional.ofNullable(buildMetricObjectStorage()).orElse(new PreConfiguredStorageBuilder().build()));
  }
  
  public MetricObjectStorageNested<A> editOrNewMetricObjectStorageLike(PreConfiguredStorage item) {
    return withNewMetricObjectStorageLike(java.util.Optional.ofNullable(buildMetricObjectStorage()).orElse(item));
  }
  
  public String getReceiveStorageSize() {
    return this.receiveStorageSize;
  }
  
  public A withReceiveStorageSize(String receiveStorageSize) {
    this.receiveStorageSize = receiveStorageSize;
    return (A) this;
  }
  
  public boolean hasReceiveStorageSize() {
    return this.receiveStorageSize != null;
  }
  
  public String getRuleStorageSize() {
    return this.ruleStorageSize;
  }
  
  public A withRuleStorageSize(String ruleStorageSize) {
    this.ruleStorageSize = ruleStorageSize;
    return (A) this;
  }
  
  public boolean hasRuleStorageSize() {
    return this.ruleStorageSize != null;
  }
  
  public String getStorageClass() {
    return this.storageClass;
  }
  
  public A withStorageClass(String storageClass) {
    this.storageClass = storageClass;
    return (A) this;
  }
  
  public boolean hasStorageClass() {
    return this.storageClass != null;
  }
  
  public String getStoreStorageSize() {
    return this.storeStorageSize;
  }
  
  public A withStoreStorageSize(String storeStorageSize) {
    this.storeStorageSize = storeStorageSize;
    return (A) this;
  }
  
  public boolean hasStoreStorageSize() {
    return this.storeStorageSize != null;
  }
  
  public A addToWriteStorage(int index,PreConfiguredStorage item) {
    if (this.writeStorage == null) {this.writeStorage = new ArrayList<PreConfiguredStorageBuilder>();}
    PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);
    if (index < 0 || index >= writeStorage.size()) { _visitables.get("writeStorage").add(builder); writeStorage.add(builder); } else { _visitables.get("writeStorage").add(index, builder); writeStorage.add(index, builder);}
    return (A)this;
  }
  
  public A setToWriteStorage(int index,PreConfiguredStorage item) {
    if (this.writeStorage == null) {this.writeStorage = new ArrayList<PreConfiguredStorageBuilder>();}
    PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);
    if (index < 0 || index >= writeStorage.size()) { _visitables.get("writeStorage").add(builder); writeStorage.add(builder); } else { _visitables.get("writeStorage").set(index, builder); writeStorage.set(index, builder);}
    return (A)this;
  }
  
  public A addToWriteStorage(io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorage... items) {
    if (this.writeStorage == null) {this.writeStorage = new ArrayList<PreConfiguredStorageBuilder>();}
    for (PreConfiguredStorage item : items) {PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);_visitables.get("writeStorage").add(builder);this.writeStorage.add(builder);} return (A)this;
  }
  
  public A addAllToWriteStorage(Collection<PreConfiguredStorage> items) {
    if (this.writeStorage == null) {this.writeStorage = new ArrayList<PreConfiguredStorageBuilder>();}
    for (PreConfiguredStorage item : items) {PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);_visitables.get("writeStorage").add(builder);this.writeStorage.add(builder);} return (A)this;
  }
  
  public A removeFromWriteStorage(io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorage... items) {
    if (this.writeStorage == null) return (A)this;
    for (PreConfiguredStorage item : items) {PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);_visitables.get("writeStorage").remove(builder); this.writeStorage.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWriteStorage(Collection<PreConfiguredStorage> items) {
    if (this.writeStorage == null) return (A)this;
    for (PreConfiguredStorage item : items) {PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);_visitables.get("writeStorage").remove(builder); this.writeStorage.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWriteStorage(Predicate<PreConfiguredStorageBuilder> predicate) {
    if (writeStorage == null) return (A) this;
    final Iterator<PreConfiguredStorageBuilder> each = writeStorage.iterator();
    final List visitables = _visitables.get("writeStorage");
    while (each.hasNext()) {
      PreConfiguredStorageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PreConfiguredStorage> buildWriteStorage() {
    return this.writeStorage != null ? build(writeStorage) : null;
  }
  
  public PreConfiguredStorage buildWriteStorage(int index) {
    return this.writeStorage.get(index).build();
  }
  
  public PreConfiguredStorage buildFirstWriteStorage() {
    return this.writeStorage.get(0).build();
  }
  
  public PreConfiguredStorage buildLastWriteStorage() {
    return this.writeStorage.get(writeStorage.size() - 1).build();
  }
  
  public PreConfiguredStorage buildMatchingWriteStorage(Predicate<PreConfiguredStorageBuilder> predicate) {
      for (PreConfiguredStorageBuilder item : writeStorage) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWriteStorage(Predicate<PreConfiguredStorageBuilder> predicate) {
      for (PreConfiguredStorageBuilder item : writeStorage) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWriteStorage(List<PreConfiguredStorage> writeStorage) {
    if (this.writeStorage != null) {
      this._visitables.get("writeStorage").clear();
    }
    if (writeStorage != null) {
        this.writeStorage = new ArrayList();
        for (PreConfiguredStorage item : writeStorage) {
          this.addToWriteStorage(item);
        }
    } else {
      this.writeStorage = null;
    }
    return (A) this;
  }
  
  public A withWriteStorage(io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorage... writeStorage) {
    if (this.writeStorage != null) {
        this.writeStorage.clear();
        _visitables.remove("writeStorage");
    }
    if (writeStorage != null) {
      for (PreConfiguredStorage item : writeStorage) {
        this.addToWriteStorage(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWriteStorage() {
    return this.writeStorage != null && !this.writeStorage.isEmpty();
  }
  
  public A addNewWriteStorage(String key,String name,Boolean serviceAccountProjection,String tlsSecretMountPath,String tlsSecretName) {
    return (A)addToWriteStorage(new PreConfiguredStorage(key, name, serviceAccountProjection, tlsSecretMountPath, tlsSecretName));
  }
  
  public WriteStorageNested<A> addNewWriteStorage() {
    return new WriteStorageNested(-1, null);
  }
  
  public WriteStorageNested<A> addNewWriteStorageLike(PreConfiguredStorage item) {
    return new WriteStorageNested(-1, item);
  }
  
  public WriteStorageNested<A> setNewWriteStorageLike(int index,PreConfiguredStorage item) {
    return new WriteStorageNested(index, item);
  }
  
  public WriteStorageNested<A> editWriteStorage(int index) {
    if (writeStorage.size() <= index) throw new RuntimeException("Can't edit writeStorage. Index exceeds size.");
    return setNewWriteStorageLike(index, buildWriteStorage(index));
  }
  
  public WriteStorageNested<A> editFirstWriteStorage() {
    if (writeStorage.size() == 0) throw new RuntimeException("Can't edit first writeStorage. The list is empty.");
    return setNewWriteStorageLike(0, buildWriteStorage(0));
  }
  
  public WriteStorageNested<A> editLastWriteStorage() {
    int index = writeStorage.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last writeStorage. The list is empty.");
    return setNewWriteStorageLike(index, buildWriteStorage(index));
  }
  
  public WriteStorageNested<A> editMatchingWriteStorage(Predicate<PreConfiguredStorageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<writeStorage.size();i++) { 
    if (predicate.test(writeStorage.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching writeStorage. No match found.");
    return setNewWriteStorageLike(index, buildWriteStorage(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StorageConfigFluent that = (StorageConfigFluent) o;
    if (!java.util.Objects.equals(alertmanagerStorageSize, that.alertmanagerStorageSize)) return false;
    if (!java.util.Objects.equals(compactStorageSize, that.compactStorageSize)) return false;
    if (!java.util.Objects.equals(metricObjectStorage, that.metricObjectStorage)) return false;
    if (!java.util.Objects.equals(receiveStorageSize, that.receiveStorageSize)) return false;
    if (!java.util.Objects.equals(ruleStorageSize, that.ruleStorageSize)) return false;
    if (!java.util.Objects.equals(storageClass, that.storageClass)) return false;
    if (!java.util.Objects.equals(storeStorageSize, that.storeStorageSize)) return false;
    if (!java.util.Objects.equals(writeStorage, that.writeStorage)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(alertmanagerStorageSize,  compactStorageSize,  metricObjectStorage,  receiveStorageSize,  ruleStorageSize,  storageClass,  storeStorageSize,  writeStorage,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alertmanagerStorageSize != null) { sb.append("alertmanagerStorageSize:"); sb.append(alertmanagerStorageSize + ","); }
    if (compactStorageSize != null) { sb.append("compactStorageSize:"); sb.append(compactStorageSize + ","); }
    if (metricObjectStorage != null) { sb.append("metricObjectStorage:"); sb.append(metricObjectStorage + ","); }
    if (receiveStorageSize != null) { sb.append("receiveStorageSize:"); sb.append(receiveStorageSize + ","); }
    if (ruleStorageSize != null) { sb.append("ruleStorageSize:"); sb.append(ruleStorageSize + ","); }
    if (storageClass != null) { sb.append("storageClass:"); sb.append(storageClass + ","); }
    if (storeStorageSize != null) { sb.append("storeStorageSize:"); sb.append(storeStorageSize + ","); }
    if (writeStorage != null && !writeStorage.isEmpty()) { sb.append("writeStorage:"); sb.append(writeStorage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetricObjectStorageNested<N> extends PreConfiguredStorageFluent<MetricObjectStorageNested<N>> implements Nested<N>{
    MetricObjectStorageNested(PreConfiguredStorage item) {
      this.builder = new PreConfiguredStorageBuilder(this, item);
    }
    PreConfiguredStorageBuilder builder;
    
    public N and() {
      return (N) StorageConfigFluent.this.withMetricObjectStorage(builder.build());
    }
    
    public N endMetricObjectStorage() {
      return and();
    }
    
  
  }
  public class WriteStorageNested<N> extends PreConfiguredStorageFluent<WriteStorageNested<N>> implements Nested<N>{
    WriteStorageNested(int index,PreConfiguredStorage item) {
      this.index = index;
      this.builder = new PreConfiguredStorageBuilder(this, item);
    }
    PreConfiguredStorageBuilder builder;
    int index;
    
    public N and() {
      return (N) StorageConfigFluent.this.setToWriteStorage(index,builder.build());
    }
    
    public N endWriteStorage() {
      return and();
    }
    
  
  }

}