package io.fabric8.openclustermanagement.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterManagerDeployOptionFluent<A extends ClusterManagerDeployOptionFluent<A>> extends BaseFluent<A>{
  public ClusterManagerDeployOptionFluent() {
  }
  
  public ClusterManagerDeployOptionFluent(ClusterManagerDeployOption instance) {
    this.copyInstance(instance);
  }
  private HostedClusterManagerConfigurationBuilder hosted;
  private String mode;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterManagerDeployOption instance) {
    instance = (instance != null ? instance : new ClusterManagerDeployOption());
    if (instance != null) {
          this.withHosted(instance.getHosted());
          this.withMode(instance.getMode());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public HostedClusterManagerConfiguration buildHosted() {
    return this.hosted != null ? this.hosted.build() : null;
  }
  
  public A withHosted(HostedClusterManagerConfiguration hosted) {
    this._visitables.remove("hosted");
    if (hosted != null) {
        this.hosted = new HostedClusterManagerConfigurationBuilder(hosted);
        this._visitables.get("hosted").add(this.hosted);
    } else {
        this.hosted = null;
        this._visitables.get("hosted").remove(this.hosted);
    }
    return (A) this;
  }
  
  public boolean hasHosted() {
    return this.hosted != null;
  }
  
  public HostedNested<A> withNewHosted() {
    return new HostedNested(null);
  }
  
  public HostedNested<A> withNewHostedLike(HostedClusterManagerConfiguration item) {
    return new HostedNested(item);
  }
  
  public HostedNested<A> editHosted() {
    return withNewHostedLike(java.util.Optional.ofNullable(buildHosted()).orElse(null));
  }
  
  public HostedNested<A> editOrNewHosted() {
    return withNewHostedLike(java.util.Optional.ofNullable(buildHosted()).orElse(new HostedClusterManagerConfigurationBuilder().build()));
  }
  
  public HostedNested<A> editOrNewHostedLike(HostedClusterManagerConfiguration item) {
    return withNewHostedLike(java.util.Optional.ofNullable(buildHosted()).orElse(item));
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterManagerDeployOptionFluent that = (ClusterManagerDeployOptionFluent) o;
    if (!java.util.Objects.equals(hosted, that.hosted)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hosted,  mode,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hosted != null) { sb.append("hosted:"); sb.append(hosted + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HostedNested<N> extends HostedClusterManagerConfigurationFluent<HostedNested<N>> implements Nested<N>{
    HostedNested(HostedClusterManagerConfiguration item) {
      this.builder = new HostedClusterManagerConfigurationBuilder(this, item);
    }
    HostedClusterManagerConfigurationBuilder builder;
    
    public N and() {
      return (N) ClusterManagerDeployOptionFluent.this.withHosted(builder.build());
    }
    
    public N endHosted() {
      return and();
    }
    
  
  }

}