package io.fabric8.openclustermanagement.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterManagerSpecFluent<A extends ClusterManagerSpecFluent<A>> extends BaseFluent<A>{
  public ClusterManagerSpecFluent() {
  }
  
  public ClusterManagerSpecFluent(ClusterManagerSpec instance) {
    this.copyInstance(instance);
  }
  private AddOnManagerConfigurationBuilder addOnManagerConfiguration;
  private String addOnManagerImagePullSpec;
  private ClusterManagerDeployOptionBuilder deployOption;
  private NodePlacementBuilder nodePlacement;
  private String placementImagePullSpec;
  private RegistrationHubConfigurationBuilder registrationConfiguration;
  private String registrationImagePullSpec;
  private ResourceRequirementBuilder resourceRequirement;
  private WorkConfigurationBuilder workConfiguration;
  private String workImagePullSpec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterManagerSpec instance) {
    instance = (instance != null ? instance : new ClusterManagerSpec());
    if (instance != null) {
          this.withAddOnManagerConfiguration(instance.getAddOnManagerConfiguration());
          this.withAddOnManagerImagePullSpec(instance.getAddOnManagerImagePullSpec());
          this.withDeployOption(instance.getDeployOption());
          this.withNodePlacement(instance.getNodePlacement());
          this.withPlacementImagePullSpec(instance.getPlacementImagePullSpec());
          this.withRegistrationConfiguration(instance.getRegistrationConfiguration());
          this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
          this.withResourceRequirement(instance.getResourceRequirement());
          this.withWorkConfiguration(instance.getWorkConfiguration());
          this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AddOnManagerConfiguration buildAddOnManagerConfiguration() {
    return this.addOnManagerConfiguration != null ? this.addOnManagerConfiguration.build() : null;
  }
  
  public A withAddOnManagerConfiguration(AddOnManagerConfiguration addOnManagerConfiguration) {
    this._visitables.remove("addOnManagerConfiguration");
    if (addOnManagerConfiguration != null) {
        this.addOnManagerConfiguration = new AddOnManagerConfigurationBuilder(addOnManagerConfiguration);
        this._visitables.get("addOnManagerConfiguration").add(this.addOnManagerConfiguration);
    } else {
        this.addOnManagerConfiguration = null;
        this._visitables.get("addOnManagerConfiguration").remove(this.addOnManagerConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasAddOnManagerConfiguration() {
    return this.addOnManagerConfiguration != null;
  }
  
  public AddOnManagerConfigurationNested<A> withNewAddOnManagerConfiguration() {
    return new AddOnManagerConfigurationNested(null);
  }
  
  public AddOnManagerConfigurationNested<A> withNewAddOnManagerConfigurationLike(AddOnManagerConfiguration item) {
    return new AddOnManagerConfigurationNested(item);
  }
  
  public AddOnManagerConfigurationNested<A> editAddOnManagerConfiguration() {
    return withNewAddOnManagerConfigurationLike(java.util.Optional.ofNullable(buildAddOnManagerConfiguration()).orElse(null));
  }
  
  public AddOnManagerConfigurationNested<A> editOrNewAddOnManagerConfiguration() {
    return withNewAddOnManagerConfigurationLike(java.util.Optional.ofNullable(buildAddOnManagerConfiguration()).orElse(new AddOnManagerConfigurationBuilder().build()));
  }
  
  public AddOnManagerConfigurationNested<A> editOrNewAddOnManagerConfigurationLike(AddOnManagerConfiguration item) {
    return withNewAddOnManagerConfigurationLike(java.util.Optional.ofNullable(buildAddOnManagerConfiguration()).orElse(item));
  }
  
  public String getAddOnManagerImagePullSpec() {
    return this.addOnManagerImagePullSpec;
  }
  
  public A withAddOnManagerImagePullSpec(String addOnManagerImagePullSpec) {
    this.addOnManagerImagePullSpec = addOnManagerImagePullSpec;
    return (A) this;
  }
  
  public boolean hasAddOnManagerImagePullSpec() {
    return this.addOnManagerImagePullSpec != null;
  }
  
  public ClusterManagerDeployOption buildDeployOption() {
    return this.deployOption != null ? this.deployOption.build() : null;
  }
  
  public A withDeployOption(ClusterManagerDeployOption deployOption) {
    this._visitables.remove("deployOption");
    if (deployOption != null) {
        this.deployOption = new ClusterManagerDeployOptionBuilder(deployOption);
        this._visitables.get("deployOption").add(this.deployOption);
    } else {
        this.deployOption = null;
        this._visitables.get("deployOption").remove(this.deployOption);
    }
    return (A) this;
  }
  
  public boolean hasDeployOption() {
    return this.deployOption != null;
  }
  
  public DeployOptionNested<A> withNewDeployOption() {
    return new DeployOptionNested(null);
  }
  
  public DeployOptionNested<A> withNewDeployOptionLike(ClusterManagerDeployOption item) {
    return new DeployOptionNested(item);
  }
  
  public DeployOptionNested<A> editDeployOption() {
    return withNewDeployOptionLike(java.util.Optional.ofNullable(buildDeployOption()).orElse(null));
  }
  
  public DeployOptionNested<A> editOrNewDeployOption() {
    return withNewDeployOptionLike(java.util.Optional.ofNullable(buildDeployOption()).orElse(new ClusterManagerDeployOptionBuilder().build()));
  }
  
  public DeployOptionNested<A> editOrNewDeployOptionLike(ClusterManagerDeployOption item) {
    return withNewDeployOptionLike(java.util.Optional.ofNullable(buildDeployOption()).orElse(item));
  }
  
  public NodePlacement buildNodePlacement() {
    return this.nodePlacement != null ? this.nodePlacement.build() : null;
  }
  
  public A withNodePlacement(NodePlacement nodePlacement) {
    this._visitables.remove("nodePlacement");
    if (nodePlacement != null) {
        this.nodePlacement = new NodePlacementBuilder(nodePlacement);
        this._visitables.get("nodePlacement").add(this.nodePlacement);
    } else {
        this.nodePlacement = null;
        this._visitables.get("nodePlacement").remove(this.nodePlacement);
    }
    return (A) this;
  }
  
  public boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  
  public NodePlacementNested<A> withNewNodePlacement() {
    return new NodePlacementNested(null);
  }
  
  public NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
    return new NodePlacementNested(item);
  }
  
  public NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(null));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(new NodePlacementBuilder().build()));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(item));
  }
  
  public String getPlacementImagePullSpec() {
    return this.placementImagePullSpec;
  }
  
  public A withPlacementImagePullSpec(String placementImagePullSpec) {
    this.placementImagePullSpec = placementImagePullSpec;
    return (A) this;
  }
  
  public boolean hasPlacementImagePullSpec() {
    return this.placementImagePullSpec != null;
  }
  
  public RegistrationHubConfiguration buildRegistrationConfiguration() {
    return this.registrationConfiguration != null ? this.registrationConfiguration.build() : null;
  }
  
  public A withRegistrationConfiguration(RegistrationHubConfiguration registrationConfiguration) {
    this._visitables.remove("registrationConfiguration");
    if (registrationConfiguration != null) {
        this.registrationConfiguration = new RegistrationHubConfigurationBuilder(registrationConfiguration);
        this._visitables.get("registrationConfiguration").add(this.registrationConfiguration);
    } else {
        this.registrationConfiguration = null;
        this._visitables.get("registrationConfiguration").remove(this.registrationConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasRegistrationConfiguration() {
    return this.registrationConfiguration != null;
  }
  
  public RegistrationConfigurationNested<A> withNewRegistrationConfiguration() {
    return new RegistrationConfigurationNested(null);
  }
  
  public RegistrationConfigurationNested<A> withNewRegistrationConfigurationLike(RegistrationHubConfiguration item) {
    return new RegistrationConfigurationNested(item);
  }
  
  public RegistrationConfigurationNested<A> editRegistrationConfiguration() {
    return withNewRegistrationConfigurationLike(java.util.Optional.ofNullable(buildRegistrationConfiguration()).orElse(null));
  }
  
  public RegistrationConfigurationNested<A> editOrNewRegistrationConfiguration() {
    return withNewRegistrationConfigurationLike(java.util.Optional.ofNullable(buildRegistrationConfiguration()).orElse(new RegistrationHubConfigurationBuilder().build()));
  }
  
  public RegistrationConfigurationNested<A> editOrNewRegistrationConfigurationLike(RegistrationHubConfiguration item) {
    return withNewRegistrationConfigurationLike(java.util.Optional.ofNullable(buildRegistrationConfiguration()).orElse(item));
  }
  
  public String getRegistrationImagePullSpec() {
    return this.registrationImagePullSpec;
  }
  
  public A withRegistrationImagePullSpec(String registrationImagePullSpec) {
    this.registrationImagePullSpec = registrationImagePullSpec;
    return (A) this;
  }
  
  public boolean hasRegistrationImagePullSpec() {
    return this.registrationImagePullSpec != null;
  }
  
  public ResourceRequirement buildResourceRequirement() {
    return this.resourceRequirement != null ? this.resourceRequirement.build() : null;
  }
  
  public A withResourceRequirement(ResourceRequirement resourceRequirement) {
    this._visitables.remove("resourceRequirement");
    if (resourceRequirement != null) {
        this.resourceRequirement = new ResourceRequirementBuilder(resourceRequirement);
        this._visitables.get("resourceRequirement").add(this.resourceRequirement);
    } else {
        this.resourceRequirement = null;
        this._visitables.get("resourceRequirement").remove(this.resourceRequirement);
    }
    return (A) this;
  }
  
  public boolean hasResourceRequirement() {
    return this.resourceRequirement != null;
  }
  
  public ResourceRequirementNested<A> withNewResourceRequirement() {
    return new ResourceRequirementNested(null);
  }
  
  public ResourceRequirementNested<A> withNewResourceRequirementLike(ResourceRequirement item) {
    return new ResourceRequirementNested(item);
  }
  
  public ResourceRequirementNested<A> editResourceRequirement() {
    return withNewResourceRequirementLike(java.util.Optional.ofNullable(buildResourceRequirement()).orElse(null));
  }
  
  public ResourceRequirementNested<A> editOrNewResourceRequirement() {
    return withNewResourceRequirementLike(java.util.Optional.ofNullable(buildResourceRequirement()).orElse(new ResourceRequirementBuilder().build()));
  }
  
  public ResourceRequirementNested<A> editOrNewResourceRequirementLike(ResourceRequirement item) {
    return withNewResourceRequirementLike(java.util.Optional.ofNullable(buildResourceRequirement()).orElse(item));
  }
  
  public WorkConfiguration buildWorkConfiguration() {
    return this.workConfiguration != null ? this.workConfiguration.build() : null;
  }
  
  public A withWorkConfiguration(WorkConfiguration workConfiguration) {
    this._visitables.remove("workConfiguration");
    if (workConfiguration != null) {
        this.workConfiguration = new WorkConfigurationBuilder(workConfiguration);
        this._visitables.get("workConfiguration").add(this.workConfiguration);
    } else {
        this.workConfiguration = null;
        this._visitables.get("workConfiguration").remove(this.workConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasWorkConfiguration() {
    return this.workConfiguration != null;
  }
  
  public WorkConfigurationNested<A> withNewWorkConfiguration() {
    return new WorkConfigurationNested(null);
  }
  
  public WorkConfigurationNested<A> withNewWorkConfigurationLike(WorkConfiguration item) {
    return new WorkConfigurationNested(item);
  }
  
  public WorkConfigurationNested<A> editWorkConfiguration() {
    return withNewWorkConfigurationLike(java.util.Optional.ofNullable(buildWorkConfiguration()).orElse(null));
  }
  
  public WorkConfigurationNested<A> editOrNewWorkConfiguration() {
    return withNewWorkConfigurationLike(java.util.Optional.ofNullable(buildWorkConfiguration()).orElse(new WorkConfigurationBuilder().build()));
  }
  
  public WorkConfigurationNested<A> editOrNewWorkConfigurationLike(WorkConfiguration item) {
    return withNewWorkConfigurationLike(java.util.Optional.ofNullable(buildWorkConfiguration()).orElse(item));
  }
  
  public String getWorkImagePullSpec() {
    return this.workImagePullSpec;
  }
  
  public A withWorkImagePullSpec(String workImagePullSpec) {
    this.workImagePullSpec = workImagePullSpec;
    return (A) this;
  }
  
  public boolean hasWorkImagePullSpec() {
    return this.workImagePullSpec != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterManagerSpecFluent that = (ClusterManagerSpecFluent) o;
    if (!java.util.Objects.equals(addOnManagerConfiguration, that.addOnManagerConfiguration)) return false;
    if (!java.util.Objects.equals(addOnManagerImagePullSpec, that.addOnManagerImagePullSpec)) return false;
    if (!java.util.Objects.equals(deployOption, that.deployOption)) return false;
    if (!java.util.Objects.equals(nodePlacement, that.nodePlacement)) return false;
    if (!java.util.Objects.equals(placementImagePullSpec, that.placementImagePullSpec)) return false;
    if (!java.util.Objects.equals(registrationConfiguration, that.registrationConfiguration)) return false;
    if (!java.util.Objects.equals(registrationImagePullSpec, that.registrationImagePullSpec)) return false;
    if (!java.util.Objects.equals(resourceRequirement, that.resourceRequirement)) return false;
    if (!java.util.Objects.equals(workConfiguration, that.workConfiguration)) return false;
    if (!java.util.Objects.equals(workImagePullSpec, that.workImagePullSpec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(addOnManagerConfiguration,  addOnManagerImagePullSpec,  deployOption,  nodePlacement,  placementImagePullSpec,  registrationConfiguration,  registrationImagePullSpec,  resourceRequirement,  workConfiguration,  workImagePullSpec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addOnManagerConfiguration != null) { sb.append("addOnManagerConfiguration:"); sb.append(addOnManagerConfiguration + ","); }
    if (addOnManagerImagePullSpec != null) { sb.append("addOnManagerImagePullSpec:"); sb.append(addOnManagerImagePullSpec + ","); }
    if (deployOption != null) { sb.append("deployOption:"); sb.append(deployOption + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (placementImagePullSpec != null) { sb.append("placementImagePullSpec:"); sb.append(placementImagePullSpec + ","); }
    if (registrationConfiguration != null) { sb.append("registrationConfiguration:"); sb.append(registrationConfiguration + ","); }
    if (registrationImagePullSpec != null) { sb.append("registrationImagePullSpec:"); sb.append(registrationImagePullSpec + ","); }
    if (resourceRequirement != null) { sb.append("resourceRequirement:"); sb.append(resourceRequirement + ","); }
    if (workConfiguration != null) { sb.append("workConfiguration:"); sb.append(workConfiguration + ","); }
    if (workImagePullSpec != null) { sb.append("workImagePullSpec:"); sb.append(workImagePullSpec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AddOnManagerConfigurationNested<N> extends AddOnManagerConfigurationFluent<AddOnManagerConfigurationNested<N>> implements Nested<N>{
    AddOnManagerConfigurationNested(AddOnManagerConfiguration item) {
      this.builder = new AddOnManagerConfigurationBuilder(this, item);
    }
    AddOnManagerConfigurationBuilder builder;
    
    public N and() {
      return (N) ClusterManagerSpecFluent.this.withAddOnManagerConfiguration(builder.build());
    }
    
    public N endAddOnManagerConfiguration() {
      return and();
    }
    
  
  }
  public class DeployOptionNested<N> extends ClusterManagerDeployOptionFluent<DeployOptionNested<N>> implements Nested<N>{
    DeployOptionNested(ClusterManagerDeployOption item) {
      this.builder = new ClusterManagerDeployOptionBuilder(this, item);
    }
    ClusterManagerDeployOptionBuilder builder;
    
    public N and() {
      return (N) ClusterManagerSpecFluent.this.withDeployOption(builder.build());
    }
    
    public N endDeployOption() {
      return and();
    }
    
  
  }
  public class NodePlacementNested<N> extends NodePlacementFluent<NodePlacementNested<N>> implements Nested<N>{
    NodePlacementNested(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementBuilder builder;
    
    public N and() {
      return (N) ClusterManagerSpecFluent.this.withNodePlacement(builder.build());
    }
    
    public N endNodePlacement() {
      return and();
    }
    
  
  }
  public class RegistrationConfigurationNested<N> extends RegistrationHubConfigurationFluent<RegistrationConfigurationNested<N>> implements Nested<N>{
    RegistrationConfigurationNested(RegistrationHubConfiguration item) {
      this.builder = new RegistrationHubConfigurationBuilder(this, item);
    }
    RegistrationHubConfigurationBuilder builder;
    
    public N and() {
      return (N) ClusterManagerSpecFluent.this.withRegistrationConfiguration(builder.build());
    }
    
    public N endRegistrationConfiguration() {
      return and();
    }
    
  
  }
  public class ResourceRequirementNested<N> extends ResourceRequirementFluent<ResourceRequirementNested<N>> implements Nested<N>{
    ResourceRequirementNested(ResourceRequirement item) {
      this.builder = new ResourceRequirementBuilder(this, item);
    }
    ResourceRequirementBuilder builder;
    
    public N and() {
      return (N) ClusterManagerSpecFluent.this.withResourceRequirement(builder.build());
    }
    
    public N endResourceRequirement() {
      return and();
    }
    
  
  }
  public class WorkConfigurationNested<N> extends WorkConfigurationFluent<WorkConfigurationNested<N>> implements Nested<N>{
    WorkConfigurationNested(WorkConfiguration item) {
      this.builder = new WorkConfigurationBuilder(this, item);
    }
    WorkConfigurationBuilder builder;
    
    public N and() {
      return (N) ClusterManagerSpecFluent.this.withWorkConfiguration(builder.build());
    }
    
    public N endWorkConfiguration() {
      return and();
    }
    
  
  }

}