package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ComponentConfigBuilder extends ComponentConfigFluent<ComponentConfigBuilder> implements VisitableBuilder<ComponentConfig,ComponentConfigBuilder>{
  public ComponentConfigBuilder() {
    this(new ComponentConfig());
  }
  
  public ComponentConfigBuilder(ComponentConfigFluent<?> fluent) {
    this(fluent, new ComponentConfig());
  }
  
  public ComponentConfigBuilder(ComponentConfigFluent<?> fluent,ComponentConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ComponentConfigBuilder(ComponentConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ComponentConfigFluent<?> fluent;
  
  public ComponentConfig build() {
    ComponentConfig buildable = new ComponentConfig(fluent.getEnabled(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}