package io.fabric8.openclustermanagement.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HostedClusterManagerConfigurationFluent<A extends HostedClusterManagerConfigurationFluent<A>> extends BaseFluent<A>{
  public HostedClusterManagerConfigurationFluent() {
  }
  
  public HostedClusterManagerConfigurationFluent(HostedClusterManagerConfiguration instance) {
    this.copyInstance(instance);
  }
  private WebhookConfigurationBuilder registrationWebhookConfiguration;
  private WebhookConfigurationBuilder workWebhookConfiguration;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HostedClusterManagerConfiguration instance) {
    instance = (instance != null ? instance : new HostedClusterManagerConfiguration());
    if (instance != null) {
          this.withRegistrationWebhookConfiguration(instance.getRegistrationWebhookConfiguration());
          this.withWorkWebhookConfiguration(instance.getWorkWebhookConfiguration());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public WebhookConfiguration buildRegistrationWebhookConfiguration() {
    return this.registrationWebhookConfiguration != null ? this.registrationWebhookConfiguration.build() : null;
  }
  
  public A withRegistrationWebhookConfiguration(WebhookConfiguration registrationWebhookConfiguration) {
    this._visitables.remove("registrationWebhookConfiguration");
    if (registrationWebhookConfiguration != null) {
        this.registrationWebhookConfiguration = new WebhookConfigurationBuilder(registrationWebhookConfiguration);
        this._visitables.get("registrationWebhookConfiguration").add(this.registrationWebhookConfiguration);
    } else {
        this.registrationWebhookConfiguration = null;
        this._visitables.get("registrationWebhookConfiguration").remove(this.registrationWebhookConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasRegistrationWebhookConfiguration() {
    return this.registrationWebhookConfiguration != null;
  }
  
  public A withNewRegistrationWebhookConfiguration(String address,Integer port) {
    return (A)withRegistrationWebhookConfiguration(new WebhookConfiguration(address, port));
  }
  
  public RegistrationWebhookConfigurationNested<A> withNewRegistrationWebhookConfiguration() {
    return new RegistrationWebhookConfigurationNested(null);
  }
  
  public RegistrationWebhookConfigurationNested<A> withNewRegistrationWebhookConfigurationLike(WebhookConfiguration item) {
    return new RegistrationWebhookConfigurationNested(item);
  }
  
  public RegistrationWebhookConfigurationNested<A> editRegistrationWebhookConfiguration() {
    return withNewRegistrationWebhookConfigurationLike(java.util.Optional.ofNullable(buildRegistrationWebhookConfiguration()).orElse(null));
  }
  
  public RegistrationWebhookConfigurationNested<A> editOrNewRegistrationWebhookConfiguration() {
    return withNewRegistrationWebhookConfigurationLike(java.util.Optional.ofNullable(buildRegistrationWebhookConfiguration()).orElse(new WebhookConfigurationBuilder().build()));
  }
  
  public RegistrationWebhookConfigurationNested<A> editOrNewRegistrationWebhookConfigurationLike(WebhookConfiguration item) {
    return withNewRegistrationWebhookConfigurationLike(java.util.Optional.ofNullable(buildRegistrationWebhookConfiguration()).orElse(item));
  }
  
  public WebhookConfiguration buildWorkWebhookConfiguration() {
    return this.workWebhookConfiguration != null ? this.workWebhookConfiguration.build() : null;
  }
  
  public A withWorkWebhookConfiguration(WebhookConfiguration workWebhookConfiguration) {
    this._visitables.remove("workWebhookConfiguration");
    if (workWebhookConfiguration != null) {
        this.workWebhookConfiguration = new WebhookConfigurationBuilder(workWebhookConfiguration);
        this._visitables.get("workWebhookConfiguration").add(this.workWebhookConfiguration);
    } else {
        this.workWebhookConfiguration = null;
        this._visitables.get("workWebhookConfiguration").remove(this.workWebhookConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasWorkWebhookConfiguration() {
    return this.workWebhookConfiguration != null;
  }
  
  public A withNewWorkWebhookConfiguration(String address,Integer port) {
    return (A)withWorkWebhookConfiguration(new WebhookConfiguration(address, port));
  }
  
  public WorkWebhookConfigurationNested<A> withNewWorkWebhookConfiguration() {
    return new WorkWebhookConfigurationNested(null);
  }
  
  public WorkWebhookConfigurationNested<A> withNewWorkWebhookConfigurationLike(WebhookConfiguration item) {
    return new WorkWebhookConfigurationNested(item);
  }
  
  public WorkWebhookConfigurationNested<A> editWorkWebhookConfiguration() {
    return withNewWorkWebhookConfigurationLike(java.util.Optional.ofNullable(buildWorkWebhookConfiguration()).orElse(null));
  }
  
  public WorkWebhookConfigurationNested<A> editOrNewWorkWebhookConfiguration() {
    return withNewWorkWebhookConfigurationLike(java.util.Optional.ofNullable(buildWorkWebhookConfiguration()).orElse(new WebhookConfigurationBuilder().build()));
  }
  
  public WorkWebhookConfigurationNested<A> editOrNewWorkWebhookConfigurationLike(WebhookConfiguration item) {
    return withNewWorkWebhookConfigurationLike(java.util.Optional.ofNullable(buildWorkWebhookConfiguration()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HostedClusterManagerConfigurationFluent that = (HostedClusterManagerConfigurationFluent) o;
    if (!java.util.Objects.equals(registrationWebhookConfiguration, that.registrationWebhookConfiguration)) return false;
    if (!java.util.Objects.equals(workWebhookConfiguration, that.workWebhookConfiguration)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(registrationWebhookConfiguration,  workWebhookConfiguration,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (registrationWebhookConfiguration != null) { sb.append("registrationWebhookConfiguration:"); sb.append(registrationWebhookConfiguration + ","); }
    if (workWebhookConfiguration != null) { sb.append("workWebhookConfiguration:"); sb.append(workWebhookConfiguration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RegistrationWebhookConfigurationNested<N> extends WebhookConfigurationFluent<RegistrationWebhookConfigurationNested<N>> implements Nested<N>{
    RegistrationWebhookConfigurationNested(WebhookConfiguration item) {
      this.builder = new WebhookConfigurationBuilder(this, item);
    }
    WebhookConfigurationBuilder builder;
    
    public N and() {
      return (N) HostedClusterManagerConfigurationFluent.this.withRegistrationWebhookConfiguration(builder.build());
    }
    
    public N endRegistrationWebhookConfiguration() {
      return and();
    }
    
  
  }
  public class WorkWebhookConfigurationNested<N> extends WebhookConfigurationFluent<WorkWebhookConfigurationNested<N>> implements Nested<N>{
    WorkWebhookConfigurationNested(WebhookConfiguration item) {
      this.builder = new WebhookConfigurationBuilder(this, item);
    }
    WebhookConfigurationBuilder builder;
    
    public N and() {
      return (N) HostedClusterManagerConfigurationFluent.this.withWorkWebhookConfiguration(builder.build());
    }
    
    public N endWorkWebhookConfiguration() {
      return and();
    }
    
  
  }

}