package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KlusterletSpecFluent<A extends KlusterletSpecFluent<A>> extends BaseFluent<A>{
  public KlusterletSpecFluent() {
  }
  
  public KlusterletSpecFluent(KlusterletSpec instance) {
    this.copyInstance(instance);
  }
  private String clusterName;
  private KlusterletDeployOptionBuilder deployOption;
  private ArrayList<ServerURLBuilder> externalServerURLs = new ArrayList<ServerURLBuilder>();
  private HubApiServerHostAliasBuilder hubApiServerHostAlias;
  private String imagePullSpec;
  private String namespace;
  private NodePlacementBuilder nodePlacement;
  private String priorityClassName;
  private RegistrationConfigurationBuilder registrationConfiguration;
  private String registrationImagePullSpec;
  private ResourceRequirementBuilder resourceRequirement;
  private WorkAgentConfigurationBuilder workConfiguration;
  private String workImagePullSpec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KlusterletSpec instance) {
    instance = (instance != null ? instance : new KlusterletSpec());
    if (instance != null) {
          this.withClusterName(instance.getClusterName());
          this.withDeployOption(instance.getDeployOption());
          this.withExternalServerURLs(instance.getExternalServerURLs());
          this.withHubApiServerHostAlias(instance.getHubApiServerHostAlias());
          this.withImagePullSpec(instance.getImagePullSpec());
          this.withNamespace(instance.getNamespace());
          this.withNodePlacement(instance.getNodePlacement());
          this.withPriorityClassName(instance.getPriorityClassName());
          this.withRegistrationConfiguration(instance.getRegistrationConfiguration());
          this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
          this.withResourceRequirement(instance.getResourceRequirement());
          this.withWorkConfiguration(instance.getWorkConfiguration());
          this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClusterName() {
    return this.clusterName;
  }
  
  public A withClusterName(String clusterName) {
    this.clusterName = clusterName;
    return (A) this;
  }
  
  public boolean hasClusterName() {
    return this.clusterName != null;
  }
  
  public KlusterletDeployOption buildDeployOption() {
    return this.deployOption != null ? this.deployOption.build() : null;
  }
  
  public A withDeployOption(KlusterletDeployOption deployOption) {
    this._visitables.remove("deployOption");
    if (deployOption != null) {
        this.deployOption = new KlusterletDeployOptionBuilder(deployOption);
        this._visitables.get("deployOption").add(this.deployOption);
    } else {
        this.deployOption = null;
        this._visitables.get("deployOption").remove(this.deployOption);
    }
    return (A) this;
  }
  
  public boolean hasDeployOption() {
    return this.deployOption != null;
  }
  
  public A withNewDeployOption(String mode) {
    return (A)withDeployOption(new KlusterletDeployOption(mode));
  }
  
  public DeployOptionNested<A> withNewDeployOption() {
    return new DeployOptionNested(null);
  }
  
  public DeployOptionNested<A> withNewDeployOptionLike(KlusterletDeployOption item) {
    return new DeployOptionNested(item);
  }
  
  public DeployOptionNested<A> editDeployOption() {
    return withNewDeployOptionLike(java.util.Optional.ofNullable(buildDeployOption()).orElse(null));
  }
  
  public DeployOptionNested<A> editOrNewDeployOption() {
    return withNewDeployOptionLike(java.util.Optional.ofNullable(buildDeployOption()).orElse(new KlusterletDeployOptionBuilder().build()));
  }
  
  public DeployOptionNested<A> editOrNewDeployOptionLike(KlusterletDeployOption item) {
    return withNewDeployOptionLike(java.util.Optional.ofNullable(buildDeployOption()).orElse(item));
  }
  
  public A addToExternalServerURLs(int index,ServerURL item) {
    if (this.externalServerURLs == null) {this.externalServerURLs = new ArrayList<ServerURLBuilder>();}
    ServerURLBuilder builder = new ServerURLBuilder(item);
    if (index < 0 || index >= externalServerURLs.size()) { _visitables.get("externalServerURLs").add(builder); externalServerURLs.add(builder); } else { _visitables.get("externalServerURLs").add(index, builder); externalServerURLs.add(index, builder);}
    return (A)this;
  }
  
  public A setToExternalServerURLs(int index,ServerURL item) {
    if (this.externalServerURLs == null) {this.externalServerURLs = new ArrayList<ServerURLBuilder>();}
    ServerURLBuilder builder = new ServerURLBuilder(item);
    if (index < 0 || index >= externalServerURLs.size()) { _visitables.get("externalServerURLs").add(builder); externalServerURLs.add(builder); } else { _visitables.get("externalServerURLs").set(index, builder); externalServerURLs.set(index, builder);}
    return (A)this;
  }
  
  public A addToExternalServerURLs(io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL... items) {
    if (this.externalServerURLs == null) {this.externalServerURLs = new ArrayList<ServerURLBuilder>();}
    for (ServerURL item : items) {ServerURLBuilder builder = new ServerURLBuilder(item);_visitables.get("externalServerURLs").add(builder);this.externalServerURLs.add(builder);} return (A)this;
  }
  
  public A addAllToExternalServerURLs(Collection<ServerURL> items) {
    if (this.externalServerURLs == null) {this.externalServerURLs = new ArrayList<ServerURLBuilder>();}
    for (ServerURL item : items) {ServerURLBuilder builder = new ServerURLBuilder(item);_visitables.get("externalServerURLs").add(builder);this.externalServerURLs.add(builder);} return (A)this;
  }
  
  public A removeFromExternalServerURLs(io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL... items) {
    if (this.externalServerURLs == null) return (A)this;
    for (ServerURL item : items) {ServerURLBuilder builder = new ServerURLBuilder(item);_visitables.get("externalServerURLs").remove(builder); this.externalServerURLs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExternalServerURLs(Collection<ServerURL> items) {
    if (this.externalServerURLs == null) return (A)this;
    for (ServerURL item : items) {ServerURLBuilder builder = new ServerURLBuilder(item);_visitables.get("externalServerURLs").remove(builder); this.externalServerURLs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExternalServerURLs(Predicate<ServerURLBuilder> predicate) {
    if (externalServerURLs == null) return (A) this;
    final Iterator<ServerURLBuilder> each = externalServerURLs.iterator();
    final List visitables = _visitables.get("externalServerURLs");
    while (each.hasNext()) {
      ServerURLBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ServerURL> buildExternalServerURLs() {
    return this.externalServerURLs != null ? build(externalServerURLs) : null;
  }
  
  public ServerURL buildExternalServerURL(int index) {
    return this.externalServerURLs.get(index).build();
  }
  
  public ServerURL buildFirstExternalServerURL() {
    return this.externalServerURLs.get(0).build();
  }
  
  public ServerURL buildLastExternalServerURL() {
    return this.externalServerURLs.get(externalServerURLs.size() - 1).build();
  }
  
  public ServerURL buildMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
      for (ServerURLBuilder item : externalServerURLs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
      for (ServerURLBuilder item : externalServerURLs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExternalServerURLs(List<ServerURL> externalServerURLs) {
    if (this.externalServerURLs != null) {
      this._visitables.get("externalServerURLs").clear();
    }
    if (externalServerURLs != null) {
        this.externalServerURLs = new ArrayList();
        for (ServerURL item : externalServerURLs) {
          this.addToExternalServerURLs(item);
        }
    } else {
      this.externalServerURLs = null;
    }
    return (A) this;
  }
  
  public A withExternalServerURLs(io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL... externalServerURLs) {
    if (this.externalServerURLs != null) {
        this.externalServerURLs.clear();
        _visitables.remove("externalServerURLs");
    }
    if (externalServerURLs != null) {
      for (ServerURL item : externalServerURLs) {
        this.addToExternalServerURLs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExternalServerURLs() {
    return this.externalServerURLs != null && !this.externalServerURLs.isEmpty();
  }
  
  public A addNewExternalServerURL(String caBundle,String url) {
    return (A)addToExternalServerURLs(new ServerURL(caBundle, url));
  }
  
  public ExternalServerURLsNested<A> addNewExternalServerURL() {
    return new ExternalServerURLsNested(-1, null);
  }
  
  public ExternalServerURLsNested<A> addNewExternalServerURLLike(ServerURL item) {
    return new ExternalServerURLsNested(-1, item);
  }
  
  public ExternalServerURLsNested<A> setNewExternalServerURLLike(int index,ServerURL item) {
    return new ExternalServerURLsNested(index, item);
  }
  
  public ExternalServerURLsNested<A> editExternalServerURL(int index) {
    if (externalServerURLs.size() <= index) throw new RuntimeException("Can't edit externalServerURLs. Index exceeds size.");
    return setNewExternalServerURLLike(index, buildExternalServerURL(index));
  }
  
  public ExternalServerURLsNested<A> editFirstExternalServerURL() {
    if (externalServerURLs.size() == 0) throw new RuntimeException("Can't edit first externalServerURLs. The list is empty.");
    return setNewExternalServerURLLike(0, buildExternalServerURL(0));
  }
  
  public ExternalServerURLsNested<A> editLastExternalServerURL() {
    int index = externalServerURLs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last externalServerURLs. The list is empty.");
    return setNewExternalServerURLLike(index, buildExternalServerURL(index));
  }
  
  public ExternalServerURLsNested<A> editMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
    int index = -1;
    for (int i=0;i<externalServerURLs.size();i++) { 
    if (predicate.test(externalServerURLs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching externalServerURLs. No match found.");
    return setNewExternalServerURLLike(index, buildExternalServerURL(index));
  }
  
  public HubApiServerHostAlias buildHubApiServerHostAlias() {
    return this.hubApiServerHostAlias != null ? this.hubApiServerHostAlias.build() : null;
  }
  
  public A withHubApiServerHostAlias(HubApiServerHostAlias hubApiServerHostAlias) {
    this._visitables.remove("hubApiServerHostAlias");
    if (hubApiServerHostAlias != null) {
        this.hubApiServerHostAlias = new HubApiServerHostAliasBuilder(hubApiServerHostAlias);
        this._visitables.get("hubApiServerHostAlias").add(this.hubApiServerHostAlias);
    } else {
        this.hubApiServerHostAlias = null;
        this._visitables.get("hubApiServerHostAlias").remove(this.hubApiServerHostAlias);
    }
    return (A) this;
  }
  
  public boolean hasHubApiServerHostAlias() {
    return this.hubApiServerHostAlias != null;
  }
  
  public A withNewHubApiServerHostAlias(String hostname,String ip) {
    return (A)withHubApiServerHostAlias(new HubApiServerHostAlias(hostname, ip));
  }
  
  public HubApiServerHostAliasNested<A> withNewHubApiServerHostAlias() {
    return new HubApiServerHostAliasNested(null);
  }
  
  public HubApiServerHostAliasNested<A> withNewHubApiServerHostAliasLike(HubApiServerHostAlias item) {
    return new HubApiServerHostAliasNested(item);
  }
  
  public HubApiServerHostAliasNested<A> editHubApiServerHostAlias() {
    return withNewHubApiServerHostAliasLike(java.util.Optional.ofNullable(buildHubApiServerHostAlias()).orElse(null));
  }
  
  public HubApiServerHostAliasNested<A> editOrNewHubApiServerHostAlias() {
    return withNewHubApiServerHostAliasLike(java.util.Optional.ofNullable(buildHubApiServerHostAlias()).orElse(new HubApiServerHostAliasBuilder().build()));
  }
  
  public HubApiServerHostAliasNested<A> editOrNewHubApiServerHostAliasLike(HubApiServerHostAlias item) {
    return withNewHubApiServerHostAliasLike(java.util.Optional.ofNullable(buildHubApiServerHostAlias()).orElse(item));
  }
  
  public String getImagePullSpec() {
    return this.imagePullSpec;
  }
  
  public A withImagePullSpec(String imagePullSpec) {
    this.imagePullSpec = imagePullSpec;
    return (A) this;
  }
  
  public boolean hasImagePullSpec() {
    return this.imagePullSpec != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public NodePlacement buildNodePlacement() {
    return this.nodePlacement != null ? this.nodePlacement.build() : null;
  }
  
  public A withNodePlacement(NodePlacement nodePlacement) {
    this._visitables.remove("nodePlacement");
    if (nodePlacement != null) {
        this.nodePlacement = new NodePlacementBuilder(nodePlacement);
        this._visitables.get("nodePlacement").add(this.nodePlacement);
    } else {
        this.nodePlacement = null;
        this._visitables.get("nodePlacement").remove(this.nodePlacement);
    }
    return (A) this;
  }
  
  public boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  
  public NodePlacementNested<A> withNewNodePlacement() {
    return new NodePlacementNested(null);
  }
  
  public NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
    return new NodePlacementNested(item);
  }
  
  public NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(null));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(new NodePlacementBuilder().build()));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(item));
  }
  
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName = priorityClassName;
    return (A) this;
  }
  
  public boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  
  public RegistrationConfiguration buildRegistrationConfiguration() {
    return this.registrationConfiguration != null ? this.registrationConfiguration.build() : null;
  }
  
  public A withRegistrationConfiguration(RegistrationConfiguration registrationConfiguration) {
    this._visitables.remove("registrationConfiguration");
    if (registrationConfiguration != null) {
        this.registrationConfiguration = new RegistrationConfigurationBuilder(registrationConfiguration);
        this._visitables.get("registrationConfiguration").add(this.registrationConfiguration);
    } else {
        this.registrationConfiguration = null;
        this._visitables.get("registrationConfiguration").remove(this.registrationConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasRegistrationConfiguration() {
    return this.registrationConfiguration != null;
  }
  
  public RegistrationConfigurationNested<A> withNewRegistrationConfiguration() {
    return new RegistrationConfigurationNested(null);
  }
  
  public RegistrationConfigurationNested<A> withNewRegistrationConfigurationLike(RegistrationConfiguration item) {
    return new RegistrationConfigurationNested(item);
  }
  
  public RegistrationConfigurationNested<A> editRegistrationConfiguration() {
    return withNewRegistrationConfigurationLike(java.util.Optional.ofNullable(buildRegistrationConfiguration()).orElse(null));
  }
  
  public RegistrationConfigurationNested<A> editOrNewRegistrationConfiguration() {
    return withNewRegistrationConfigurationLike(java.util.Optional.ofNullable(buildRegistrationConfiguration()).orElse(new RegistrationConfigurationBuilder().build()));
  }
  
  public RegistrationConfigurationNested<A> editOrNewRegistrationConfigurationLike(RegistrationConfiguration item) {
    return withNewRegistrationConfigurationLike(java.util.Optional.ofNullable(buildRegistrationConfiguration()).orElse(item));
  }
  
  public String getRegistrationImagePullSpec() {
    return this.registrationImagePullSpec;
  }
  
  public A withRegistrationImagePullSpec(String registrationImagePullSpec) {
    this.registrationImagePullSpec = registrationImagePullSpec;
    return (A) this;
  }
  
  public boolean hasRegistrationImagePullSpec() {
    return this.registrationImagePullSpec != null;
  }
  
  public ResourceRequirement buildResourceRequirement() {
    return this.resourceRequirement != null ? this.resourceRequirement.build() : null;
  }
  
  public A withResourceRequirement(ResourceRequirement resourceRequirement) {
    this._visitables.remove("resourceRequirement");
    if (resourceRequirement != null) {
        this.resourceRequirement = new ResourceRequirementBuilder(resourceRequirement);
        this._visitables.get("resourceRequirement").add(this.resourceRequirement);
    } else {
        this.resourceRequirement = null;
        this._visitables.get("resourceRequirement").remove(this.resourceRequirement);
    }
    return (A) this;
  }
  
  public boolean hasResourceRequirement() {
    return this.resourceRequirement != null;
  }
  
  public ResourceRequirementNested<A> withNewResourceRequirement() {
    return new ResourceRequirementNested(null);
  }
  
  public ResourceRequirementNested<A> withNewResourceRequirementLike(ResourceRequirement item) {
    return new ResourceRequirementNested(item);
  }
  
  public ResourceRequirementNested<A> editResourceRequirement() {
    return withNewResourceRequirementLike(java.util.Optional.ofNullable(buildResourceRequirement()).orElse(null));
  }
  
  public ResourceRequirementNested<A> editOrNewResourceRequirement() {
    return withNewResourceRequirementLike(java.util.Optional.ofNullable(buildResourceRequirement()).orElse(new ResourceRequirementBuilder().build()));
  }
  
  public ResourceRequirementNested<A> editOrNewResourceRequirementLike(ResourceRequirement item) {
    return withNewResourceRequirementLike(java.util.Optional.ofNullable(buildResourceRequirement()).orElse(item));
  }
  
  public WorkAgentConfiguration buildWorkConfiguration() {
    return this.workConfiguration != null ? this.workConfiguration.build() : null;
  }
  
  public A withWorkConfiguration(WorkAgentConfiguration workConfiguration) {
    this._visitables.remove("workConfiguration");
    if (workConfiguration != null) {
        this.workConfiguration = new WorkAgentConfigurationBuilder(workConfiguration);
        this._visitables.get("workConfiguration").add(this.workConfiguration);
    } else {
        this.workConfiguration = null;
        this._visitables.get("workConfiguration").remove(this.workConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasWorkConfiguration() {
    return this.workConfiguration != null;
  }
  
  public WorkConfigurationNested<A> withNewWorkConfiguration() {
    return new WorkConfigurationNested(null);
  }
  
  public WorkConfigurationNested<A> withNewWorkConfigurationLike(WorkAgentConfiguration item) {
    return new WorkConfigurationNested(item);
  }
  
  public WorkConfigurationNested<A> editWorkConfiguration() {
    return withNewWorkConfigurationLike(java.util.Optional.ofNullable(buildWorkConfiguration()).orElse(null));
  }
  
  public WorkConfigurationNested<A> editOrNewWorkConfiguration() {
    return withNewWorkConfigurationLike(java.util.Optional.ofNullable(buildWorkConfiguration()).orElse(new WorkAgentConfigurationBuilder().build()));
  }
  
  public WorkConfigurationNested<A> editOrNewWorkConfigurationLike(WorkAgentConfiguration item) {
    return withNewWorkConfigurationLike(java.util.Optional.ofNullable(buildWorkConfiguration()).orElse(item));
  }
  
  public String getWorkImagePullSpec() {
    return this.workImagePullSpec;
  }
  
  public A withWorkImagePullSpec(String workImagePullSpec) {
    this.workImagePullSpec = workImagePullSpec;
    return (A) this;
  }
  
  public boolean hasWorkImagePullSpec() {
    return this.workImagePullSpec != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KlusterletSpecFluent that = (KlusterletSpecFluent) o;
    if (!java.util.Objects.equals(clusterName, that.clusterName)) return false;
    if (!java.util.Objects.equals(deployOption, that.deployOption)) return false;
    if (!java.util.Objects.equals(externalServerURLs, that.externalServerURLs)) return false;
    if (!java.util.Objects.equals(hubApiServerHostAlias, that.hubApiServerHostAlias)) return false;
    if (!java.util.Objects.equals(imagePullSpec, that.imagePullSpec)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(nodePlacement, that.nodePlacement)) return false;
    if (!java.util.Objects.equals(priorityClassName, that.priorityClassName)) return false;
    if (!java.util.Objects.equals(registrationConfiguration, that.registrationConfiguration)) return false;
    if (!java.util.Objects.equals(registrationImagePullSpec, that.registrationImagePullSpec)) return false;
    if (!java.util.Objects.equals(resourceRequirement, that.resourceRequirement)) return false;
    if (!java.util.Objects.equals(workConfiguration, that.workConfiguration)) return false;
    if (!java.util.Objects.equals(workImagePullSpec, that.workImagePullSpec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterName,  deployOption,  externalServerURLs,  hubApiServerHostAlias,  imagePullSpec,  namespace,  nodePlacement,  priorityClassName,  registrationConfiguration,  registrationImagePullSpec,  resourceRequirement,  workConfiguration,  workImagePullSpec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (deployOption != null) { sb.append("deployOption:"); sb.append(deployOption + ","); }
    if (externalServerURLs != null && !externalServerURLs.isEmpty()) { sb.append("externalServerURLs:"); sb.append(externalServerURLs + ","); }
    if (hubApiServerHostAlias != null) { sb.append("hubApiServerHostAlias:"); sb.append(hubApiServerHostAlias + ","); }
    if (imagePullSpec != null) { sb.append("imagePullSpec:"); sb.append(imagePullSpec + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (registrationConfiguration != null) { sb.append("registrationConfiguration:"); sb.append(registrationConfiguration + ","); }
    if (registrationImagePullSpec != null) { sb.append("registrationImagePullSpec:"); sb.append(registrationImagePullSpec + ","); }
    if (resourceRequirement != null) { sb.append("resourceRequirement:"); sb.append(resourceRequirement + ","); }
    if (workConfiguration != null) { sb.append("workConfiguration:"); sb.append(workConfiguration + ","); }
    if (workImagePullSpec != null) { sb.append("workImagePullSpec:"); sb.append(workImagePullSpec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DeployOptionNested<N> extends KlusterletDeployOptionFluent<DeployOptionNested<N>> implements Nested<N>{
    DeployOptionNested(KlusterletDeployOption item) {
      this.builder = new KlusterletDeployOptionBuilder(this, item);
    }
    KlusterletDeployOptionBuilder builder;
    
    public N and() {
      return (N) KlusterletSpecFluent.this.withDeployOption(builder.build());
    }
    
    public N endDeployOption() {
      return and();
    }
    
  
  }
  public class ExternalServerURLsNested<N> extends ServerURLFluent<ExternalServerURLsNested<N>> implements Nested<N>{
    ExternalServerURLsNested(int index,ServerURL item) {
      this.index = index;
      this.builder = new ServerURLBuilder(this, item);
    }
    ServerURLBuilder builder;
    int index;
    
    public N and() {
      return (N) KlusterletSpecFluent.this.setToExternalServerURLs(index,builder.build());
    }
    
    public N endExternalServerURL() {
      return and();
    }
    
  
  }
  public class HubApiServerHostAliasNested<N> extends HubApiServerHostAliasFluent<HubApiServerHostAliasNested<N>> implements Nested<N>{
    HubApiServerHostAliasNested(HubApiServerHostAlias item) {
      this.builder = new HubApiServerHostAliasBuilder(this, item);
    }
    HubApiServerHostAliasBuilder builder;
    
    public N and() {
      return (N) KlusterletSpecFluent.this.withHubApiServerHostAlias(builder.build());
    }
    
    public N endHubApiServerHostAlias() {
      return and();
    }
    
  
  }
  public class NodePlacementNested<N> extends NodePlacementFluent<NodePlacementNested<N>> implements Nested<N>{
    NodePlacementNested(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementBuilder builder;
    
    public N and() {
      return (N) KlusterletSpecFluent.this.withNodePlacement(builder.build());
    }
    
    public N endNodePlacement() {
      return and();
    }
    
  
  }
  public class RegistrationConfigurationNested<N> extends RegistrationConfigurationFluent<RegistrationConfigurationNested<N>> implements Nested<N>{
    RegistrationConfigurationNested(RegistrationConfiguration item) {
      this.builder = new RegistrationConfigurationBuilder(this, item);
    }
    RegistrationConfigurationBuilder builder;
    
    public N and() {
      return (N) KlusterletSpecFluent.this.withRegistrationConfiguration(builder.build());
    }
    
    public N endRegistrationConfiguration() {
      return and();
    }
    
  
  }
  public class ResourceRequirementNested<N> extends ResourceRequirementFluent<ResourceRequirementNested<N>> implements Nested<N>{
    ResourceRequirementNested(ResourceRequirement item) {
      this.builder = new ResourceRequirementBuilder(this, item);
    }
    ResourceRequirementBuilder builder;
    
    public N and() {
      return (N) KlusterletSpecFluent.this.withResourceRequirement(builder.build());
    }
    
    public N endResourceRequirement() {
      return and();
    }
    
  
  }
  public class WorkConfigurationNested<N> extends WorkAgentConfigurationFluent<WorkConfigurationNested<N>> implements Nested<N>{
    WorkConfigurationNested(WorkAgentConfiguration item) {
      this.builder = new WorkAgentConfigurationBuilder(this, item);
    }
    WorkAgentConfigurationBuilder builder;
    
    public N and() {
      return (N) KlusterletSpecFluent.this.withWorkConfiguration(builder.build());
    }
    
    public N endWorkConfiguration() {
      return and();
    }
    
  
  }

}