package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LocalSecretsConfigBuilder extends LocalSecretsConfigFluent<LocalSecretsConfigBuilder> implements VisitableBuilder<LocalSecretsConfig,LocalSecretsConfigBuilder>{
  public LocalSecretsConfigBuilder() {
    this(new LocalSecretsConfig());
  }
  
  public LocalSecretsConfigBuilder(LocalSecretsConfigFluent<?> fluent) {
    this(fluent, new LocalSecretsConfig());
  }
  
  public LocalSecretsConfigBuilder(LocalSecretsConfigFluent<?> fluent,LocalSecretsConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LocalSecretsConfigBuilder(LocalSecretsConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LocalSecretsConfigFluent<?> fluent;
  
  public LocalSecretsConfig build() {
    LocalSecretsConfig buildable = new LocalSecretsConfig(fluent.getHubConnectionTimeoutSeconds(),fluent.buildKubeConfigSecrets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}