package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LocalSecretsConfigFluent<A extends LocalSecretsConfigFluent<A>> extends BaseFluent<A>{
  public LocalSecretsConfigFluent() {
  }
  
  public LocalSecretsConfigFluent(LocalSecretsConfig instance) {
    this.copyInstance(instance);
  }
  private Integer hubConnectionTimeoutSeconds;
  private ArrayList<KubeConfigSecretBuilder> kubeConfigSecrets = new ArrayList<KubeConfigSecretBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(LocalSecretsConfig instance) {
    instance = (instance != null ? instance : new LocalSecretsConfig());
    if (instance != null) {
          this.withHubConnectionTimeoutSeconds(instance.getHubConnectionTimeoutSeconds());
          this.withKubeConfigSecrets(instance.getKubeConfigSecrets());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getHubConnectionTimeoutSeconds() {
    return this.hubConnectionTimeoutSeconds;
  }
  
  public A withHubConnectionTimeoutSeconds(Integer hubConnectionTimeoutSeconds) {
    this.hubConnectionTimeoutSeconds = hubConnectionTimeoutSeconds;
    return (A) this;
  }
  
  public boolean hasHubConnectionTimeoutSeconds() {
    return this.hubConnectionTimeoutSeconds != null;
  }
  
  public A addToKubeConfigSecrets(int index,KubeConfigSecret item) {
    if (this.kubeConfigSecrets == null) {this.kubeConfigSecrets = new ArrayList<KubeConfigSecretBuilder>();}
    KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);
    if (index < 0 || index >= kubeConfigSecrets.size()) { _visitables.get("kubeConfigSecrets").add(builder); kubeConfigSecrets.add(builder); } else { _visitables.get("kubeConfigSecrets").add(index, builder); kubeConfigSecrets.add(index, builder);}
    return (A)this;
  }
  
  public A setToKubeConfigSecrets(int index,KubeConfigSecret item) {
    if (this.kubeConfigSecrets == null) {this.kubeConfigSecrets = new ArrayList<KubeConfigSecretBuilder>();}
    KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);
    if (index < 0 || index >= kubeConfigSecrets.size()) { _visitables.get("kubeConfigSecrets").add(builder); kubeConfigSecrets.add(builder); } else { _visitables.get("kubeConfigSecrets").set(index, builder); kubeConfigSecrets.set(index, builder);}
    return (A)this;
  }
  
  public A addToKubeConfigSecrets(io.fabric8.openclustermanagement.api.model.operator.v1.KubeConfigSecret... items) {
    if (this.kubeConfigSecrets == null) {this.kubeConfigSecrets = new ArrayList<KubeConfigSecretBuilder>();}
    for (KubeConfigSecret item : items) {KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);_visitables.get("kubeConfigSecrets").add(builder);this.kubeConfigSecrets.add(builder);} return (A)this;
  }
  
  public A addAllToKubeConfigSecrets(Collection<KubeConfigSecret> items) {
    if (this.kubeConfigSecrets == null) {this.kubeConfigSecrets = new ArrayList<KubeConfigSecretBuilder>();}
    for (KubeConfigSecret item : items) {KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);_visitables.get("kubeConfigSecrets").add(builder);this.kubeConfigSecrets.add(builder);} return (A)this;
  }
  
  public A removeFromKubeConfigSecrets(io.fabric8.openclustermanagement.api.model.operator.v1.KubeConfigSecret... items) {
    if (this.kubeConfigSecrets == null) return (A)this;
    for (KubeConfigSecret item : items) {KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);_visitables.get("kubeConfigSecrets").remove(builder); this.kubeConfigSecrets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromKubeConfigSecrets(Collection<KubeConfigSecret> items) {
    if (this.kubeConfigSecrets == null) return (A)this;
    for (KubeConfigSecret item : items) {KubeConfigSecretBuilder builder = new KubeConfigSecretBuilder(item);_visitables.get("kubeConfigSecrets").remove(builder); this.kubeConfigSecrets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromKubeConfigSecrets(Predicate<KubeConfigSecretBuilder> predicate) {
    if (kubeConfigSecrets == null) return (A) this;
    final Iterator<KubeConfigSecretBuilder> each = kubeConfigSecrets.iterator();
    final List visitables = _visitables.get("kubeConfigSecrets");
    while (each.hasNext()) {
      KubeConfigSecretBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<KubeConfigSecret> buildKubeConfigSecrets() {
    return this.kubeConfigSecrets != null ? build(kubeConfigSecrets) : null;
  }
  
  public KubeConfigSecret buildKubeConfigSecret(int index) {
    return this.kubeConfigSecrets.get(index).build();
  }
  
  public KubeConfigSecret buildFirstKubeConfigSecret() {
    return this.kubeConfigSecrets.get(0).build();
  }
  
  public KubeConfigSecret buildLastKubeConfigSecret() {
    return this.kubeConfigSecrets.get(kubeConfigSecrets.size() - 1).build();
  }
  
  public KubeConfigSecret buildMatchingKubeConfigSecret(Predicate<KubeConfigSecretBuilder> predicate) {
      for (KubeConfigSecretBuilder item : kubeConfigSecrets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingKubeConfigSecret(Predicate<KubeConfigSecretBuilder> predicate) {
      for (KubeConfigSecretBuilder item : kubeConfigSecrets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withKubeConfigSecrets(List<KubeConfigSecret> kubeConfigSecrets) {
    if (this.kubeConfigSecrets != null) {
      this._visitables.get("kubeConfigSecrets").clear();
    }
    if (kubeConfigSecrets != null) {
        this.kubeConfigSecrets = new ArrayList();
        for (KubeConfigSecret item : kubeConfigSecrets) {
          this.addToKubeConfigSecrets(item);
        }
    } else {
      this.kubeConfigSecrets = null;
    }
    return (A) this;
  }
  
  public A withKubeConfigSecrets(io.fabric8.openclustermanagement.api.model.operator.v1.KubeConfigSecret... kubeConfigSecrets) {
    if (this.kubeConfigSecrets != null) {
        this.kubeConfigSecrets.clear();
        _visitables.remove("kubeConfigSecrets");
    }
    if (kubeConfigSecrets != null) {
      for (KubeConfigSecret item : kubeConfigSecrets) {
        this.addToKubeConfigSecrets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasKubeConfigSecrets() {
    return this.kubeConfigSecrets != null && !this.kubeConfigSecrets.isEmpty();
  }
  
  public A addNewKubeConfigSecret(String name) {
    return (A)addToKubeConfigSecrets(new KubeConfigSecret(name));
  }
  
  public KubeConfigSecretsNested<A> addNewKubeConfigSecret() {
    return new KubeConfigSecretsNested(-1, null);
  }
  
  public KubeConfigSecretsNested<A> addNewKubeConfigSecretLike(KubeConfigSecret item) {
    return new KubeConfigSecretsNested(-1, item);
  }
  
  public KubeConfigSecretsNested<A> setNewKubeConfigSecretLike(int index,KubeConfigSecret item) {
    return new KubeConfigSecretsNested(index, item);
  }
  
  public KubeConfigSecretsNested<A> editKubeConfigSecret(int index) {
    if (kubeConfigSecrets.size() <= index) throw new RuntimeException("Can't edit kubeConfigSecrets. Index exceeds size.");
    return setNewKubeConfigSecretLike(index, buildKubeConfigSecret(index));
  }
  
  public KubeConfigSecretsNested<A> editFirstKubeConfigSecret() {
    if (kubeConfigSecrets.size() == 0) throw new RuntimeException("Can't edit first kubeConfigSecrets. The list is empty.");
    return setNewKubeConfigSecretLike(0, buildKubeConfigSecret(0));
  }
  
  public KubeConfigSecretsNested<A> editLastKubeConfigSecret() {
    int index = kubeConfigSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last kubeConfigSecrets. The list is empty.");
    return setNewKubeConfigSecretLike(index, buildKubeConfigSecret(index));
  }
  
  public KubeConfigSecretsNested<A> editMatchingKubeConfigSecret(Predicate<KubeConfigSecretBuilder> predicate) {
    int index = -1;
    for (int i=0;i<kubeConfigSecrets.size();i++) { 
    if (predicate.test(kubeConfigSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching kubeConfigSecrets. No match found.");
    return setNewKubeConfigSecretLike(index, buildKubeConfigSecret(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LocalSecretsConfigFluent that = (LocalSecretsConfigFluent) o;
    if (!java.util.Objects.equals(hubConnectionTimeoutSeconds, that.hubConnectionTimeoutSeconds)) return false;
    if (!java.util.Objects.equals(kubeConfigSecrets, that.kubeConfigSecrets)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hubConnectionTimeoutSeconds,  kubeConfigSecrets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hubConnectionTimeoutSeconds != null) { sb.append("hubConnectionTimeoutSeconds:"); sb.append(hubConnectionTimeoutSeconds + ","); }
    if (kubeConfigSecrets != null && !kubeConfigSecrets.isEmpty()) { sb.append("kubeConfigSecrets:"); sb.append(kubeConfigSecrets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KubeConfigSecretsNested<N> extends KubeConfigSecretFluent<KubeConfigSecretsNested<N>> implements Nested<N>{
    KubeConfigSecretsNested(int index,KubeConfigSecret item) {
      this.index = index;
      this.builder = new KubeConfigSecretBuilder(this, item);
    }
    KubeConfigSecretBuilder builder;
    int index;
    
    public N and() {
      return (N) LocalSecretsConfigFluent.this.setToKubeConfigSecrets(index,builder.build());
    }
    
    public N endKubeConfigSecret() {
      return and();
    }
    
  
  }

}