package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OverridesFluent<A extends OverridesFluent<A>> extends BaseFluent<A>{
  public OverridesFluent() {
  }
  
  public OverridesFluent(Overrides instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ComponentConfigBuilder> components = new ArrayList<ComponentConfigBuilder>();
  private String imagePullPolicy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Overrides instance) {
    instance = (instance != null ? instance : new Overrides());
    if (instance != null) {
          this.withComponents(instance.getComponents());
          this.withImagePullPolicy(instance.getImagePullPolicy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToComponents(int index,ComponentConfig item) {
    if (this.components == null) {this.components = new ArrayList<ComponentConfigBuilder>();}
    ComponentConfigBuilder builder = new ComponentConfigBuilder(item);
    if (index < 0 || index >= components.size()) { _visitables.get("components").add(builder); components.add(builder); } else { _visitables.get("components").add(index, builder); components.add(index, builder);}
    return (A)this;
  }
  
  public A setToComponents(int index,ComponentConfig item) {
    if (this.components == null) {this.components = new ArrayList<ComponentConfigBuilder>();}
    ComponentConfigBuilder builder = new ComponentConfigBuilder(item);
    if (index < 0 || index >= components.size()) { _visitables.get("components").add(builder); components.add(builder); } else { _visitables.get("components").set(index, builder); components.set(index, builder);}
    return (A)this;
  }
  
  public A addToComponents(io.fabric8.openclustermanagement.api.model.operator.v1.ComponentConfig... items) {
    if (this.components == null) {this.components = new ArrayList<ComponentConfigBuilder>();}
    for (ComponentConfig item : items) {ComponentConfigBuilder builder = new ComponentConfigBuilder(item);_visitables.get("components").add(builder);this.components.add(builder);} return (A)this;
  }
  
  public A addAllToComponents(Collection<ComponentConfig> items) {
    if (this.components == null) {this.components = new ArrayList<ComponentConfigBuilder>();}
    for (ComponentConfig item : items) {ComponentConfigBuilder builder = new ComponentConfigBuilder(item);_visitables.get("components").add(builder);this.components.add(builder);} return (A)this;
  }
  
  public A removeFromComponents(io.fabric8.openclustermanagement.api.model.operator.v1.ComponentConfig... items) {
    if (this.components == null) return (A)this;
    for (ComponentConfig item : items) {ComponentConfigBuilder builder = new ComponentConfigBuilder(item);_visitables.get("components").remove(builder); this.components.remove(builder);} return (A)this;
  }
  
  public A removeAllFromComponents(Collection<ComponentConfig> items) {
    if (this.components == null) return (A)this;
    for (ComponentConfig item : items) {ComponentConfigBuilder builder = new ComponentConfigBuilder(item);_visitables.get("components").remove(builder); this.components.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromComponents(Predicate<ComponentConfigBuilder> predicate) {
    if (components == null) return (A) this;
    final Iterator<ComponentConfigBuilder> each = components.iterator();
    final List visitables = _visitables.get("components");
    while (each.hasNext()) {
      ComponentConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ComponentConfig> buildComponents() {
    return this.components != null ? build(components) : null;
  }
  
  public ComponentConfig buildComponent(int index) {
    return this.components.get(index).build();
  }
  
  public ComponentConfig buildFirstComponent() {
    return this.components.get(0).build();
  }
  
  public ComponentConfig buildLastComponent() {
    return this.components.get(components.size() - 1).build();
  }
  
  public ComponentConfig buildMatchingComponent(Predicate<ComponentConfigBuilder> predicate) {
      for (ComponentConfigBuilder item : components) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingComponent(Predicate<ComponentConfigBuilder> predicate) {
      for (ComponentConfigBuilder item : components) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withComponents(List<ComponentConfig> components) {
    if (this.components != null) {
      this._visitables.get("components").clear();
    }
    if (components != null) {
        this.components = new ArrayList();
        for (ComponentConfig item : components) {
          this.addToComponents(item);
        }
    } else {
      this.components = null;
    }
    return (A) this;
  }
  
  public A withComponents(io.fabric8.openclustermanagement.api.model.operator.v1.ComponentConfig... components) {
    if (this.components != null) {
        this.components.clear();
        _visitables.remove("components");
    }
    if (components != null) {
      for (ComponentConfig item : components) {
        this.addToComponents(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasComponents() {
    return this.components != null && !this.components.isEmpty();
  }
  
  public A addNewComponent(Boolean enabled,String name) {
    return (A)addToComponents(new ComponentConfig(enabled, name));
  }
  
  public ComponentsNested<A> addNewComponent() {
    return new ComponentsNested(-1, null);
  }
  
  public ComponentsNested<A> addNewComponentLike(ComponentConfig item) {
    return new ComponentsNested(-1, item);
  }
  
  public ComponentsNested<A> setNewComponentLike(int index,ComponentConfig item) {
    return new ComponentsNested(index, item);
  }
  
  public ComponentsNested<A> editComponent(int index) {
    if (components.size() <= index) throw new RuntimeException("Can't edit components. Index exceeds size.");
    return setNewComponentLike(index, buildComponent(index));
  }
  
  public ComponentsNested<A> editFirstComponent() {
    if (components.size() == 0) throw new RuntimeException("Can't edit first components. The list is empty.");
    return setNewComponentLike(0, buildComponent(0));
  }
  
  public ComponentsNested<A> editLastComponent() {
    int index = components.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last components. The list is empty.");
    return setNewComponentLike(index, buildComponent(index));
  }
  
  public ComponentsNested<A> editMatchingComponent(Predicate<ComponentConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<components.size();i++) { 
    if (predicate.test(components.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching components. No match found.");
    return setNewComponentLike(index, buildComponent(index));
  }
  
  public String getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  
  public A withImagePullPolicy(String imagePullPolicy) {
    this.imagePullPolicy = imagePullPolicy;
    return (A) this;
  }
  
  public boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OverridesFluent that = (OverridesFluent) o;
    if (!java.util.Objects.equals(components, that.components)) return false;
    if (!java.util.Objects.equals(imagePullPolicy, that.imagePullPolicy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(components,  imagePullPolicy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (components != null && !components.isEmpty()) { sb.append("components:"); sb.append(components + ","); }
    if (imagePullPolicy != null) { sb.append("imagePullPolicy:"); sb.append(imagePullPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ComponentsNested<N> extends ComponentConfigFluent<ComponentsNested<N>> implements Nested<N>{
    ComponentsNested(int index,ComponentConfig item) {
      this.index = index;
      this.builder = new ComponentConfigBuilder(this, item);
    }
    ComponentConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) OverridesFluent.this.setToComponents(index,builder.build());
    }
    
    public N endComponent() {
      return and();
    }
    
  
  }

}