package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RegistrationConfigurationBuilder extends RegistrationConfigurationFluent<RegistrationConfigurationBuilder> implements VisitableBuilder<RegistrationConfiguration,RegistrationConfigurationBuilder>{
  public RegistrationConfigurationBuilder() {
    this(new RegistrationConfiguration());
  }
  
  public RegistrationConfigurationBuilder(RegistrationConfigurationFluent<?> fluent) {
    this(fluent, new RegistrationConfiguration());
  }
  
  public RegistrationConfigurationBuilder(RegistrationConfigurationFluent<?> fluent,RegistrationConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RegistrationConfigurationBuilder(RegistrationConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RegistrationConfigurationFluent<?> fluent;
  
  public RegistrationConfiguration build() {
    RegistrationConfiguration buildable = new RegistrationConfiguration(fluent.buildBootstrapKubeConfigs(),fluent.getClientCertExpirationSeconds(),fluent.getClusterAnnotations(),fluent.buildFeatureGates(),fluent.getKubeAPIBurst(),fluent.getKubeAPIQPS(),fluent.buildRegistrationDriver());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}