package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RegistrationConfigurationFluent<A extends RegistrationConfigurationFluent<A>> extends BaseFluent<A>{
  public RegistrationConfigurationFluent() {
  }
  
  public RegistrationConfigurationFluent(RegistrationConfiguration instance) {
    this.copyInstance(instance);
  }
  private BootstrapKubeConfigsBuilder bootstrapKubeConfigs;
  private Integer clientCertExpirationSeconds;
  private Map<String,String> clusterAnnotations;
  private ArrayList<FeatureGateBuilder> featureGates = new ArrayList<FeatureGateBuilder>();
  private Integer kubeAPIBurst;
  private Integer kubeAPIQPS;
  private RegistrationDriverBuilder registrationDriver;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RegistrationConfiguration instance) {
    instance = (instance != null ? instance : new RegistrationConfiguration());
    if (instance != null) {
          this.withBootstrapKubeConfigs(instance.getBootstrapKubeConfigs());
          this.withClientCertExpirationSeconds(instance.getClientCertExpirationSeconds());
          this.withClusterAnnotations(instance.getClusterAnnotations());
          this.withFeatureGates(instance.getFeatureGates());
          this.withKubeAPIBurst(instance.getKubeAPIBurst());
          this.withKubeAPIQPS(instance.getKubeAPIQPS());
          this.withRegistrationDriver(instance.getRegistrationDriver());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public BootstrapKubeConfigs buildBootstrapKubeConfigs() {
    return this.bootstrapKubeConfigs != null ? this.bootstrapKubeConfigs.build() : null;
  }
  
  public A withBootstrapKubeConfigs(BootstrapKubeConfigs bootstrapKubeConfigs) {
    this._visitables.remove("bootstrapKubeConfigs");
    if (bootstrapKubeConfigs != null) {
        this.bootstrapKubeConfigs = new BootstrapKubeConfigsBuilder(bootstrapKubeConfigs);
        this._visitables.get("bootstrapKubeConfigs").add(this.bootstrapKubeConfigs);
    } else {
        this.bootstrapKubeConfigs = null;
        this._visitables.get("bootstrapKubeConfigs").remove(this.bootstrapKubeConfigs);
    }
    return (A) this;
  }
  
  public boolean hasBootstrapKubeConfigs() {
    return this.bootstrapKubeConfigs != null;
  }
  
  public BootstrapKubeConfigsNested<A> withNewBootstrapKubeConfigs() {
    return new BootstrapKubeConfigsNested(null);
  }
  
  public BootstrapKubeConfigsNested<A> withNewBootstrapKubeConfigsLike(BootstrapKubeConfigs item) {
    return new BootstrapKubeConfigsNested(item);
  }
  
  public BootstrapKubeConfigsNested<A> editBootstrapKubeConfigs() {
    return withNewBootstrapKubeConfigsLike(java.util.Optional.ofNullable(buildBootstrapKubeConfigs()).orElse(null));
  }
  
  public BootstrapKubeConfigsNested<A> editOrNewBootstrapKubeConfigs() {
    return withNewBootstrapKubeConfigsLike(java.util.Optional.ofNullable(buildBootstrapKubeConfigs()).orElse(new BootstrapKubeConfigsBuilder().build()));
  }
  
  public BootstrapKubeConfigsNested<A> editOrNewBootstrapKubeConfigsLike(BootstrapKubeConfigs item) {
    return withNewBootstrapKubeConfigsLike(java.util.Optional.ofNullable(buildBootstrapKubeConfigs()).orElse(item));
  }
  
  public Integer getClientCertExpirationSeconds() {
    return this.clientCertExpirationSeconds;
  }
  
  public A withClientCertExpirationSeconds(Integer clientCertExpirationSeconds) {
    this.clientCertExpirationSeconds = clientCertExpirationSeconds;
    return (A) this;
  }
  
  public boolean hasClientCertExpirationSeconds() {
    return this.clientCertExpirationSeconds != null;
  }
  
  public A addToClusterAnnotations(String key,String value) {
    if(this.clusterAnnotations == null && key != null && value != null) { this.clusterAnnotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.clusterAnnotations.put(key, value);} return (A)this;
  }
  
  public A addToClusterAnnotations(Map<String,String> map) {
    if(this.clusterAnnotations == null && map != null) { this.clusterAnnotations = new LinkedHashMap(); }
    if(map != null) { this.clusterAnnotations.putAll(map);} return (A)this;
  }
  
  public A removeFromClusterAnnotations(String key) {
    if(this.clusterAnnotations == null) { return (A) this; }
    if(key != null && this.clusterAnnotations != null) {this.clusterAnnotations.remove(key);} return (A)this;
  }
  
  public A removeFromClusterAnnotations(Map<String,String> map) {
    if(this.clusterAnnotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.clusterAnnotations != null){this.clusterAnnotations.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getClusterAnnotations() {
    return this.clusterAnnotations;
  }
  
  public <K,V>A withClusterAnnotations(Map<String,String> clusterAnnotations) {
    if (clusterAnnotations == null) {
      this.clusterAnnotations = null;
    } else {
      this.clusterAnnotations = new LinkedHashMap(clusterAnnotations);
    }
    return (A) this;
  }
  
  public boolean hasClusterAnnotations() {
    return this.clusterAnnotations != null;
  }
  
  public A addToFeatureGates(int index,FeatureGate item) {
    if (this.featureGates == null) {this.featureGates = new ArrayList<FeatureGateBuilder>();}
    FeatureGateBuilder builder = new FeatureGateBuilder(item);
    if (index < 0 || index >= featureGates.size()) { _visitables.get("featureGates").add(builder); featureGates.add(builder); } else { _visitables.get("featureGates").add(index, builder); featureGates.add(index, builder);}
    return (A)this;
  }
  
  public A setToFeatureGates(int index,FeatureGate item) {
    if (this.featureGates == null) {this.featureGates = new ArrayList<FeatureGateBuilder>();}
    FeatureGateBuilder builder = new FeatureGateBuilder(item);
    if (index < 0 || index >= featureGates.size()) { _visitables.get("featureGates").add(builder); featureGates.add(builder); } else { _visitables.get("featureGates").set(index, builder); featureGates.set(index, builder);}
    return (A)this;
  }
  
  public A addToFeatureGates(io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate... items) {
    if (this.featureGates == null) {this.featureGates = new ArrayList<FeatureGateBuilder>();}
    for (FeatureGate item : items) {FeatureGateBuilder builder = new FeatureGateBuilder(item);_visitables.get("featureGates").add(builder);this.featureGates.add(builder);} return (A)this;
  }
  
  public A addAllToFeatureGates(Collection<FeatureGate> items) {
    if (this.featureGates == null) {this.featureGates = new ArrayList<FeatureGateBuilder>();}
    for (FeatureGate item : items) {FeatureGateBuilder builder = new FeatureGateBuilder(item);_visitables.get("featureGates").add(builder);this.featureGates.add(builder);} return (A)this;
  }
  
  public A removeFromFeatureGates(io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate... items) {
    if (this.featureGates == null) return (A)this;
    for (FeatureGate item : items) {FeatureGateBuilder builder = new FeatureGateBuilder(item);_visitables.get("featureGates").remove(builder); this.featureGates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFeatureGates(Collection<FeatureGate> items) {
    if (this.featureGates == null) return (A)this;
    for (FeatureGate item : items) {FeatureGateBuilder builder = new FeatureGateBuilder(item);_visitables.get("featureGates").remove(builder); this.featureGates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFeatureGates(Predicate<FeatureGateBuilder> predicate) {
    if (featureGates == null) return (A) this;
    final Iterator<FeatureGateBuilder> each = featureGates.iterator();
    final List visitables = _visitables.get("featureGates");
    while (each.hasNext()) {
      FeatureGateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FeatureGate> buildFeatureGates() {
    return this.featureGates != null ? build(featureGates) : null;
  }
  
  public FeatureGate buildFeatureGate(int index) {
    return this.featureGates.get(index).build();
  }
  
  public FeatureGate buildFirstFeatureGate() {
    return this.featureGates.get(0).build();
  }
  
  public FeatureGate buildLastFeatureGate() {
    return this.featureGates.get(featureGates.size() - 1).build();
  }
  
  public FeatureGate buildMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
      for (FeatureGateBuilder item : featureGates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
      for (FeatureGateBuilder item : featureGates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFeatureGates(List<FeatureGate> featureGates) {
    if (this.featureGates != null) {
      this._visitables.get("featureGates").clear();
    }
    if (featureGates != null) {
        this.featureGates = new ArrayList();
        for (FeatureGate item : featureGates) {
          this.addToFeatureGates(item);
        }
    } else {
      this.featureGates = null;
    }
    return (A) this;
  }
  
  public A withFeatureGates(io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate... featureGates) {
    if (this.featureGates != null) {
        this.featureGates.clear();
        _visitables.remove("featureGates");
    }
    if (featureGates != null) {
      for (FeatureGate item : featureGates) {
        this.addToFeatureGates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFeatureGates() {
    return this.featureGates != null && !this.featureGates.isEmpty();
  }
  
  public A addNewFeatureGate(String feature,String mode) {
    return (A)addToFeatureGates(new FeatureGate(feature, mode));
  }
  
  public FeatureGatesNested<A> addNewFeatureGate() {
    return new FeatureGatesNested(-1, null);
  }
  
  public FeatureGatesNested<A> addNewFeatureGateLike(FeatureGate item) {
    return new FeatureGatesNested(-1, item);
  }
  
  public FeatureGatesNested<A> setNewFeatureGateLike(int index,FeatureGate item) {
    return new FeatureGatesNested(index, item);
  }
  
  public FeatureGatesNested<A> editFeatureGate(int index) {
    if (featureGates.size() <= index) throw new RuntimeException("Can't edit featureGates. Index exceeds size.");
    return setNewFeatureGateLike(index, buildFeatureGate(index));
  }
  
  public FeatureGatesNested<A> editFirstFeatureGate() {
    if (featureGates.size() == 0) throw new RuntimeException("Can't edit first featureGates. The list is empty.");
    return setNewFeatureGateLike(0, buildFeatureGate(0));
  }
  
  public FeatureGatesNested<A> editLastFeatureGate() {
    int index = featureGates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last featureGates. The list is empty.");
    return setNewFeatureGateLike(index, buildFeatureGate(index));
  }
  
  public FeatureGatesNested<A> editMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<featureGates.size();i++) { 
    if (predicate.test(featureGates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching featureGates. No match found.");
    return setNewFeatureGateLike(index, buildFeatureGate(index));
  }
  
  public Integer getKubeAPIBurst() {
    return this.kubeAPIBurst;
  }
  
  public A withKubeAPIBurst(Integer kubeAPIBurst) {
    this.kubeAPIBurst = kubeAPIBurst;
    return (A) this;
  }
  
  public boolean hasKubeAPIBurst() {
    return this.kubeAPIBurst != null;
  }
  
  public Integer getKubeAPIQPS() {
    return this.kubeAPIQPS;
  }
  
  public A withKubeAPIQPS(Integer kubeAPIQPS) {
    this.kubeAPIQPS = kubeAPIQPS;
    return (A) this;
  }
  
  public boolean hasKubeAPIQPS() {
    return this.kubeAPIQPS != null;
  }
  
  public RegistrationDriver buildRegistrationDriver() {
    return this.registrationDriver != null ? this.registrationDriver.build() : null;
  }
  
  public A withRegistrationDriver(RegistrationDriver registrationDriver) {
    this._visitables.remove("registrationDriver");
    if (registrationDriver != null) {
        this.registrationDriver = new RegistrationDriverBuilder(registrationDriver);
        this._visitables.get("registrationDriver").add(this.registrationDriver);
    } else {
        this.registrationDriver = null;
        this._visitables.get("registrationDriver").remove(this.registrationDriver);
    }
    return (A) this;
  }
  
  public boolean hasRegistrationDriver() {
    return this.registrationDriver != null;
  }
  
  public RegistrationDriverNested<A> withNewRegistrationDriver() {
    return new RegistrationDriverNested(null);
  }
  
  public RegistrationDriverNested<A> withNewRegistrationDriverLike(RegistrationDriver item) {
    return new RegistrationDriverNested(item);
  }
  
  public RegistrationDriverNested<A> editRegistrationDriver() {
    return withNewRegistrationDriverLike(java.util.Optional.ofNullable(buildRegistrationDriver()).orElse(null));
  }
  
  public RegistrationDriverNested<A> editOrNewRegistrationDriver() {
    return withNewRegistrationDriverLike(java.util.Optional.ofNullable(buildRegistrationDriver()).orElse(new RegistrationDriverBuilder().build()));
  }
  
  public RegistrationDriverNested<A> editOrNewRegistrationDriverLike(RegistrationDriver item) {
    return withNewRegistrationDriverLike(java.util.Optional.ofNullable(buildRegistrationDriver()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RegistrationConfigurationFluent that = (RegistrationConfigurationFluent) o;
    if (!java.util.Objects.equals(bootstrapKubeConfigs, that.bootstrapKubeConfigs)) return false;
    if (!java.util.Objects.equals(clientCertExpirationSeconds, that.clientCertExpirationSeconds)) return false;
    if (!java.util.Objects.equals(clusterAnnotations, that.clusterAnnotations)) return false;
    if (!java.util.Objects.equals(featureGates, that.featureGates)) return false;
    if (!java.util.Objects.equals(kubeAPIBurst, that.kubeAPIBurst)) return false;
    if (!java.util.Objects.equals(kubeAPIQPS, that.kubeAPIQPS)) return false;
    if (!java.util.Objects.equals(registrationDriver, that.registrationDriver)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootstrapKubeConfigs,  clientCertExpirationSeconds,  clusterAnnotations,  featureGates,  kubeAPIBurst,  kubeAPIQPS,  registrationDriver,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapKubeConfigs != null) { sb.append("bootstrapKubeConfigs:"); sb.append(bootstrapKubeConfigs + ","); }
    if (clientCertExpirationSeconds != null) { sb.append("clientCertExpirationSeconds:"); sb.append(clientCertExpirationSeconds + ","); }
    if (clusterAnnotations != null && !clusterAnnotations.isEmpty()) { sb.append("clusterAnnotations:"); sb.append(clusterAnnotations + ","); }
    if (featureGates != null && !featureGates.isEmpty()) { sb.append("featureGates:"); sb.append(featureGates + ","); }
    if (kubeAPIBurst != null) { sb.append("kubeAPIBurst:"); sb.append(kubeAPIBurst + ","); }
    if (kubeAPIQPS != null) { sb.append("kubeAPIQPS:"); sb.append(kubeAPIQPS + ","); }
    if (registrationDriver != null) { sb.append("registrationDriver:"); sb.append(registrationDriver + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BootstrapKubeConfigsNested<N> extends BootstrapKubeConfigsFluent<BootstrapKubeConfigsNested<N>> implements Nested<N>{
    BootstrapKubeConfigsNested(BootstrapKubeConfigs item) {
      this.builder = new BootstrapKubeConfigsBuilder(this, item);
    }
    BootstrapKubeConfigsBuilder builder;
    
    public N and() {
      return (N) RegistrationConfigurationFluent.this.withBootstrapKubeConfigs(builder.build());
    }
    
    public N endBootstrapKubeConfigs() {
      return and();
    }
    
  
  }
  public class FeatureGatesNested<N> extends FeatureGateFluent<FeatureGatesNested<N>> implements Nested<N>{
    FeatureGatesNested(int index,FeatureGate item) {
      this.index = index;
      this.builder = new FeatureGateBuilder(this, item);
    }
    FeatureGateBuilder builder;
    int index;
    
    public N and() {
      return (N) RegistrationConfigurationFluent.this.setToFeatureGates(index,builder.build());
    }
    
    public N endFeatureGate() {
      return and();
    }
    
  
  }
  public class RegistrationDriverNested<N> extends RegistrationDriverFluent<RegistrationDriverNested<N>> implements Nested<N>{
    RegistrationDriverNested(RegistrationDriver item) {
      this.builder = new RegistrationDriverBuilder(this, item);
    }
    RegistrationDriverBuilder builder;
    
    public N and() {
      return (N) RegistrationConfigurationFluent.this.withRegistrationDriver(builder.build());
    }
    
    public N endRegistrationDriver() {
      return and();
    }
    
  
  }

}