package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RegistrationHubConfigurationFluent<A extends RegistrationHubConfigurationFluent<A>> extends BaseFluent<A>{
  public RegistrationHubConfigurationFluent() {
  }
  
  public RegistrationHubConfigurationFluent(RegistrationHubConfiguration instance) {
    this.copyInstance(instance);
  }
  private List<String> autoApproveUsers = new ArrayList<String>();
  private ArrayList<FeatureGateBuilder> featureGates = new ArrayList<FeatureGateBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RegistrationHubConfiguration instance) {
    instance = (instance != null ? instance : new RegistrationHubConfiguration());
    if (instance != null) {
          this.withAutoApproveUsers(instance.getAutoApproveUsers());
          this.withFeatureGates(instance.getFeatureGates());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAutoApproveUsers(int index,String item) {
    if (this.autoApproveUsers == null) {this.autoApproveUsers = new ArrayList<String>();}
    this.autoApproveUsers.add(index, item);
    return (A)this;
  }
  
  public A setToAutoApproveUsers(int index,String item) {
    if (this.autoApproveUsers == null) {this.autoApproveUsers = new ArrayList<String>();}
    this.autoApproveUsers.set(index, item); return (A)this;
  }
  
  public A addToAutoApproveUsers(java.lang.String... items) {
    if (this.autoApproveUsers == null) {this.autoApproveUsers = new ArrayList<String>();}
    for (String item : items) {this.autoApproveUsers.add(item);} return (A)this;
  }
  
  public A addAllToAutoApproveUsers(Collection<String> items) {
    if (this.autoApproveUsers == null) {this.autoApproveUsers = new ArrayList<String>();}
    for (String item : items) {this.autoApproveUsers.add(item);} return (A)this;
  }
  
  public A removeFromAutoApproveUsers(java.lang.String... items) {
    if (this.autoApproveUsers == null) return (A)this;
    for (String item : items) { this.autoApproveUsers.remove(item);} return (A)this;
  }
  
  public A removeAllFromAutoApproveUsers(Collection<String> items) {
    if (this.autoApproveUsers == null) return (A)this;
    for (String item : items) { this.autoApproveUsers.remove(item);} return (A)this;
  }
  
  public List<String> getAutoApproveUsers() {
    return this.autoApproveUsers;
  }
  
  public String getAutoApproveUser(int index) {
    return this.autoApproveUsers.get(index);
  }
  
  public String getFirstAutoApproveUser() {
    return this.autoApproveUsers.get(0);
  }
  
  public String getLastAutoApproveUser() {
    return this.autoApproveUsers.get(autoApproveUsers.size() - 1);
  }
  
  public String getMatchingAutoApproveUser(Predicate<String> predicate) {
      for (String item : autoApproveUsers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAutoApproveUser(Predicate<String> predicate) {
      for (String item : autoApproveUsers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAutoApproveUsers(List<String> autoApproveUsers) {
    if (autoApproveUsers != null) {
        this.autoApproveUsers = new ArrayList();
        for (String item : autoApproveUsers) {
          this.addToAutoApproveUsers(item);
        }
    } else {
      this.autoApproveUsers = null;
    }
    return (A) this;
  }
  
  public A withAutoApproveUsers(java.lang.String... autoApproveUsers) {
    if (this.autoApproveUsers != null) {
        this.autoApproveUsers.clear();
        _visitables.remove("autoApproveUsers");
    }
    if (autoApproveUsers != null) {
      for (String item : autoApproveUsers) {
        this.addToAutoApproveUsers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAutoApproveUsers() {
    return this.autoApproveUsers != null && !this.autoApproveUsers.isEmpty();
  }
  
  public A addToFeatureGates(int index,FeatureGate item) {
    if (this.featureGates == null) {this.featureGates = new ArrayList<FeatureGateBuilder>();}
    FeatureGateBuilder builder = new FeatureGateBuilder(item);
    if (index < 0 || index >= featureGates.size()) { _visitables.get("featureGates").add(builder); featureGates.add(builder); } else { _visitables.get("featureGates").add(index, builder); featureGates.add(index, builder);}
    return (A)this;
  }
  
  public A setToFeatureGates(int index,FeatureGate item) {
    if (this.featureGates == null) {this.featureGates = new ArrayList<FeatureGateBuilder>();}
    FeatureGateBuilder builder = new FeatureGateBuilder(item);
    if (index < 0 || index >= featureGates.size()) { _visitables.get("featureGates").add(builder); featureGates.add(builder); } else { _visitables.get("featureGates").set(index, builder); featureGates.set(index, builder);}
    return (A)this;
  }
  
  public A addToFeatureGates(io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate... items) {
    if (this.featureGates == null) {this.featureGates = new ArrayList<FeatureGateBuilder>();}
    for (FeatureGate item : items) {FeatureGateBuilder builder = new FeatureGateBuilder(item);_visitables.get("featureGates").add(builder);this.featureGates.add(builder);} return (A)this;
  }
  
  public A addAllToFeatureGates(Collection<FeatureGate> items) {
    if (this.featureGates == null) {this.featureGates = new ArrayList<FeatureGateBuilder>();}
    for (FeatureGate item : items) {FeatureGateBuilder builder = new FeatureGateBuilder(item);_visitables.get("featureGates").add(builder);this.featureGates.add(builder);} return (A)this;
  }
  
  public A removeFromFeatureGates(io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate... items) {
    if (this.featureGates == null) return (A)this;
    for (FeatureGate item : items) {FeatureGateBuilder builder = new FeatureGateBuilder(item);_visitables.get("featureGates").remove(builder); this.featureGates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFeatureGates(Collection<FeatureGate> items) {
    if (this.featureGates == null) return (A)this;
    for (FeatureGate item : items) {FeatureGateBuilder builder = new FeatureGateBuilder(item);_visitables.get("featureGates").remove(builder); this.featureGates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFeatureGates(Predicate<FeatureGateBuilder> predicate) {
    if (featureGates == null) return (A) this;
    final Iterator<FeatureGateBuilder> each = featureGates.iterator();
    final List visitables = _visitables.get("featureGates");
    while (each.hasNext()) {
      FeatureGateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FeatureGate> buildFeatureGates() {
    return this.featureGates != null ? build(featureGates) : null;
  }
  
  public FeatureGate buildFeatureGate(int index) {
    return this.featureGates.get(index).build();
  }
  
  public FeatureGate buildFirstFeatureGate() {
    return this.featureGates.get(0).build();
  }
  
  public FeatureGate buildLastFeatureGate() {
    return this.featureGates.get(featureGates.size() - 1).build();
  }
  
  public FeatureGate buildMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
      for (FeatureGateBuilder item : featureGates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
      for (FeatureGateBuilder item : featureGates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFeatureGates(List<FeatureGate> featureGates) {
    if (this.featureGates != null) {
      this._visitables.get("featureGates").clear();
    }
    if (featureGates != null) {
        this.featureGates = new ArrayList();
        for (FeatureGate item : featureGates) {
          this.addToFeatureGates(item);
        }
    } else {
      this.featureGates = null;
    }
    return (A) this;
  }
  
  public A withFeatureGates(io.fabric8.openclustermanagement.api.model.operator.v1.FeatureGate... featureGates) {
    if (this.featureGates != null) {
        this.featureGates.clear();
        _visitables.remove("featureGates");
    }
    if (featureGates != null) {
      for (FeatureGate item : featureGates) {
        this.addToFeatureGates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFeatureGates() {
    return this.featureGates != null && !this.featureGates.isEmpty();
  }
  
  public A addNewFeatureGate(String feature,String mode) {
    return (A)addToFeatureGates(new FeatureGate(feature, mode));
  }
  
  public FeatureGatesNested<A> addNewFeatureGate() {
    return new FeatureGatesNested(-1, null);
  }
  
  public FeatureGatesNested<A> addNewFeatureGateLike(FeatureGate item) {
    return new FeatureGatesNested(-1, item);
  }
  
  public FeatureGatesNested<A> setNewFeatureGateLike(int index,FeatureGate item) {
    return new FeatureGatesNested(index, item);
  }
  
  public FeatureGatesNested<A> editFeatureGate(int index) {
    if (featureGates.size() <= index) throw new RuntimeException("Can't edit featureGates. Index exceeds size.");
    return setNewFeatureGateLike(index, buildFeatureGate(index));
  }
  
  public FeatureGatesNested<A> editFirstFeatureGate() {
    if (featureGates.size() == 0) throw new RuntimeException("Can't edit first featureGates. The list is empty.");
    return setNewFeatureGateLike(0, buildFeatureGate(0));
  }
  
  public FeatureGatesNested<A> editLastFeatureGate() {
    int index = featureGates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last featureGates. The list is empty.");
    return setNewFeatureGateLike(index, buildFeatureGate(index));
  }
  
  public FeatureGatesNested<A> editMatchingFeatureGate(Predicate<FeatureGateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<featureGates.size();i++) { 
    if (predicate.test(featureGates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching featureGates. No match found.");
    return setNewFeatureGateLike(index, buildFeatureGate(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RegistrationHubConfigurationFluent that = (RegistrationHubConfigurationFluent) o;
    if (!java.util.Objects.equals(autoApproveUsers, that.autoApproveUsers)) return false;
    if (!java.util.Objects.equals(featureGates, that.featureGates)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(autoApproveUsers,  featureGates,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (autoApproveUsers != null && !autoApproveUsers.isEmpty()) { sb.append("autoApproveUsers:"); sb.append(autoApproveUsers + ","); }
    if (featureGates != null && !featureGates.isEmpty()) { sb.append("featureGates:"); sb.append(featureGates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FeatureGatesNested<N> extends FeatureGateFluent<FeatureGatesNested<N>> implements Nested<N>{
    FeatureGatesNested(int index,FeatureGate item) {
      this.index = index;
      this.builder = new FeatureGateBuilder(this, item);
    }
    FeatureGateBuilder builder;
    int index;
    
    public N and() {
      return (N) RegistrationHubConfigurationFluent.this.setToFeatureGates(index,builder.build());
    }
    
    public N endFeatureGate() {
      return and();
    }
    
  
  }

}