package io.fabric8.openclustermanagement.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceRequirementFluent<A extends ResourceRequirementFluent<A>> extends BaseFluent<A>{
  public ResourceRequirementFluent() {
  }
  
  public ResourceRequirementFluent(ResourceRequirement instance) {
    this.copyInstance(instance);
  }
  private ResourceRequirementsBuilder resourceRequirements;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceRequirement instance) {
    instance = (instance != null ? instance : new ResourceRequirement());
    if (instance != null) {
          this.withResourceRequirements(instance.getResourceRequirements());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ResourceRequirements buildResourceRequirements() {
    return this.resourceRequirements != null ? this.resourceRequirements.build() : null;
  }
  
  public A withResourceRequirements(ResourceRequirements resourceRequirements) {
    this._visitables.remove("resourceRequirements");
    if (resourceRequirements != null) {
        this.resourceRequirements = new ResourceRequirementsBuilder(resourceRequirements);
        this._visitables.get("resourceRequirements").add(this.resourceRequirements);
    } else {
        this.resourceRequirements = null;
        this._visitables.get("resourceRequirements").remove(this.resourceRequirements);
    }
    return (A) this;
  }
  
  public boolean hasResourceRequirements() {
    return this.resourceRequirements != null;
  }
  
  public ResourceRequirementsNested<A> withNewResourceRequirements() {
    return new ResourceRequirementsNested(null);
  }
  
  public ResourceRequirementsNested<A> withNewResourceRequirementsLike(ResourceRequirements item) {
    return new ResourceRequirementsNested(item);
  }
  
  public ResourceRequirementsNested<A> editResourceRequirements() {
    return withNewResourceRequirementsLike(java.util.Optional.ofNullable(buildResourceRequirements()).orElse(null));
  }
  
  public ResourceRequirementsNested<A> editOrNewResourceRequirements() {
    return withNewResourceRequirementsLike(java.util.Optional.ofNullable(buildResourceRequirements()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ResourceRequirementsNested<A> editOrNewResourceRequirementsLike(ResourceRequirements item) {
    return withNewResourceRequirementsLike(java.util.Optional.ofNullable(buildResourceRequirements()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceRequirementFluent that = (ResourceRequirementFluent) o;
    if (!java.util.Objects.equals(resourceRequirements, that.resourceRequirements)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(resourceRequirements,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resourceRequirements != null) { sb.append("resourceRequirements:"); sb.append(resourceRequirements + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourceRequirementsNested<N> extends ResourceRequirementsFluent<ResourceRequirementsNested<N>> implements Nested<N>{
    ResourceRequirementsNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) ResourceRequirementFluent.this.withResourceRequirements(builder.build());
    }
    
    public N endResourceRequirements() {
      return and();
    }
    
  
  }

}