package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StatusConditionBuilder extends StatusConditionFluent<StatusConditionBuilder> implements VisitableBuilder<StatusCondition,StatusConditionBuilder>{
  public StatusConditionBuilder() {
    this(new StatusCondition());
  }
  
  public StatusConditionBuilder(StatusConditionFluent<?> fluent) {
    this(fluent, new StatusCondition());
  }
  
  public StatusConditionBuilder(StatusConditionFluent<?> fluent,StatusCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StatusConditionBuilder(StatusCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StatusConditionFluent<?> fluent;
  
  public StatusCondition build() {
    StatusCondition buildable = new StatusCondition(fluent.getKind(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getName(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}