package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WebhookConfigurationBuilder extends WebhookConfigurationFluent<WebhookConfigurationBuilder> implements VisitableBuilder<WebhookConfiguration,WebhookConfigurationBuilder>{
  public WebhookConfigurationBuilder() {
    this(new WebhookConfiguration());
  }
  
  public WebhookConfigurationBuilder(WebhookConfigurationFluent<?> fluent) {
    this(fluent, new WebhookConfiguration());
  }
  
  public WebhookConfigurationBuilder(WebhookConfigurationFluent<?> fluent,WebhookConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WebhookConfigurationBuilder(WebhookConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WebhookConfigurationFluent<?> fluent;
  
  public WebhookConfiguration build() {
    WebhookConfiguration buildable = new WebhookConfiguration(fluent.getAddress(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}