package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkAgentConfigurationBuilder extends WorkAgentConfigurationFluent<WorkAgentConfigurationBuilder> implements VisitableBuilder<WorkAgentConfiguration,WorkAgentConfigurationBuilder>{
  public WorkAgentConfigurationBuilder() {
    this(new WorkAgentConfiguration());
  }
  
  public WorkAgentConfigurationBuilder(WorkAgentConfigurationFluent<?> fluent) {
    this(fluent, new WorkAgentConfiguration());
  }
  
  public WorkAgentConfigurationBuilder(WorkAgentConfigurationFluent<?> fluent,WorkAgentConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkAgentConfigurationBuilder(WorkAgentConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkAgentConfigurationFluent<?> fluent;
  
  public WorkAgentConfiguration build() {
    WorkAgentConfiguration buildable = new WorkAgentConfiguration(fluent.getAppliedManifestWorkEvictionGracePeriod(),fluent.buildFeatureGates(),fluent.getKubeAPIBurst(),fluent.getKubeAPIQPS());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}