package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkConfigurationBuilder extends WorkConfigurationFluent<WorkConfigurationBuilder> implements VisitableBuilder<WorkConfiguration,WorkConfigurationBuilder>{
  public WorkConfigurationBuilder() {
    this(new WorkConfiguration());
  }
  
  public WorkConfigurationBuilder(WorkConfigurationFluent<?> fluent) {
    this(fluent, new WorkConfiguration());
  }
  
  public WorkConfigurationBuilder(WorkConfigurationFluent<?> fluent,WorkConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkConfigurationBuilder(WorkConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkConfigurationFluent<?> fluent;
  
  public WorkConfiguration build() {
    WorkConfiguration buildable = new WorkConfiguration(fluent.buildFeatureGates(),fluent.getWorkDriver());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}