package io.fabric8.openclustermanagement.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ComplianceHistoryBuilder extends ComplianceHistoryFluent<ComplianceHistoryBuilder> implements VisitableBuilder<ComplianceHistory,ComplianceHistoryBuilder>{
  public ComplianceHistoryBuilder() {
    this(new ComplianceHistory());
  }
  
  public ComplianceHistoryBuilder(ComplianceHistoryFluent<?> fluent) {
    this(fluent, new ComplianceHistory());
  }
  
  public ComplianceHistoryBuilder(ComplianceHistoryFluent<?> fluent,ComplianceHistory instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ComplianceHistoryBuilder(ComplianceHistory instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ComplianceHistoryFluent<?> fluent;
  
  public ComplianceHistory build() {
    ComplianceHistory buildable = new ComplianceHistory(fluent.getEventName(),fluent.getLastTimestamp(),fluent.getMessage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}