package io.fabric8.openclustermanagement.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HubTemplateOptionsBuilder extends HubTemplateOptionsFluent<HubTemplateOptionsBuilder> implements VisitableBuilder<HubTemplateOptions,HubTemplateOptionsBuilder>{
  public HubTemplateOptionsBuilder() {
    this(new HubTemplateOptions());
  }
  
  public HubTemplateOptionsBuilder(HubTemplateOptionsFluent<?> fluent) {
    this(fluent, new HubTemplateOptions());
  }
  
  public HubTemplateOptionsBuilder(HubTemplateOptionsFluent<?> fluent,HubTemplateOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HubTemplateOptionsBuilder(HubTemplateOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HubTemplateOptionsFluent<?> fluent;
  
  public HubTemplateOptions build() {
    HubTemplateOptions buildable = new HubTemplateOptions(fluent.getServiceAccountName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}