package io.fabric8.openclustermanagement.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PolicyDependencyBuilder extends PolicyDependencyFluent<PolicyDependencyBuilder> implements VisitableBuilder<PolicyDependency,PolicyDependencyBuilder>{
  public PolicyDependencyBuilder() {
    this(new PolicyDependency());
  }
  
  public PolicyDependencyBuilder(PolicyDependencyFluent<?> fluent) {
    this(fluent, new PolicyDependency());
  }
  
  public PolicyDependencyBuilder(PolicyDependencyFluent<?> fluent,PolicyDependency instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PolicyDependencyBuilder(PolicyDependency instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PolicyDependencyFluent<?> fluent;
  
  public PolicyDependency build() {
    PolicyDependency buildable = new PolicyDependency(fluent.getApiVersion(),fluent.getCompliance(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}