package io.fabric8.openclustermanagement.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PolicySpecFluent<A extends PolicySpecFluent<A>> extends BaseFluent<A>{
  public PolicySpecFluent() {
  }
  
  public PolicySpecFluent(PolicySpec instance) {
    this.copyInstance(instance);
  }
  private Boolean copyPolicyMetadata;
  private ArrayList<PolicyDependencyBuilder> dependencies = new ArrayList<PolicyDependencyBuilder>();
  private Boolean disabled;
  private HubTemplateOptionsBuilder hubTemplateOptions;
  private ArrayList<PolicyTemplateBuilder> policyTemplates = new ArrayList<PolicyTemplateBuilder>();
  private String remediationAction;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PolicySpec instance) {
    instance = (instance != null ? instance : new PolicySpec());
    if (instance != null) {
          this.withCopyPolicyMetadata(instance.getCopyPolicyMetadata());
          this.withDependencies(instance.getDependencies());
          this.withDisabled(instance.getDisabled());
          this.withHubTemplateOptions(instance.getHubTemplateOptions());
          this.withPolicyTemplates(instance.getPolicyTemplates());
          this.withRemediationAction(instance.getRemediationAction());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getCopyPolicyMetadata() {
    return this.copyPolicyMetadata;
  }
  
  public A withCopyPolicyMetadata(Boolean copyPolicyMetadata) {
    this.copyPolicyMetadata = copyPolicyMetadata;
    return (A) this;
  }
  
  public boolean hasCopyPolicyMetadata() {
    return this.copyPolicyMetadata != null;
  }
  
  public A addToDependencies(int index,PolicyDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<PolicyDependencyBuilder>();}
    PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").add(index, builder); dependencies.add(index, builder);}
    return (A)this;
  }
  
  public A setToDependencies(int index,PolicyDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<PolicyDependencyBuilder>();}
    PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").set(index, builder); dependencies.set(index, builder);}
    return (A)this;
  }
  
  public A addToDependencies(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependency... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<PolicyDependencyBuilder>();}
    for (PolicyDependency item : items) {PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  
  public A addAllToDependencies(Collection<PolicyDependency> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<PolicyDependencyBuilder>();}
    for (PolicyDependency item : items) {PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  
  public A removeFromDependencies(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependency... items) {
    if (this.dependencies == null) return (A)this;
    for (PolicyDependency item : items) {PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);_visitables.get("dependencies").remove(builder); this.dependencies.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDependencies(Collection<PolicyDependency> items) {
    if (this.dependencies == null) return (A)this;
    for (PolicyDependency item : items) {PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);_visitables.get("dependencies").remove(builder); this.dependencies.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDependencies(Predicate<PolicyDependencyBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<PolicyDependencyBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      PolicyDependencyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PolicyDependency> buildDependencies() {
    return this.dependencies != null ? build(dependencies) : null;
  }
  
  public PolicyDependency buildDependency(int index) {
    return this.dependencies.get(index).build();
  }
  
  public PolicyDependency buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  
  public PolicyDependency buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  
  public PolicyDependency buildMatchingDependency(Predicate<PolicyDependencyBuilder> predicate) {
      for (PolicyDependencyBuilder item : dependencies) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDependency(Predicate<PolicyDependencyBuilder> predicate) {
      for (PolicyDependencyBuilder item : dependencies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDependencies(List<PolicyDependency> dependencies) {
    if (this.dependencies != null) {
      this._visitables.get("dependencies").clear();
    }
    if (dependencies != null) {
        this.dependencies = new ArrayList();
        for (PolicyDependency item : dependencies) {
          this.addToDependencies(item);
        }
    } else {
      this.dependencies = null;
    }
    return (A) this;
  }
  
  public A withDependencies(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependency... dependencies) {
    if (this.dependencies != null) {
        this.dependencies.clear();
        _visitables.remove("dependencies");
    }
    if (dependencies != null) {
      for (PolicyDependency item : dependencies) {
        this.addToDependencies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDependencies() {
    return this.dependencies != null && !this.dependencies.isEmpty();
  }
  
  public A addNewDependency(String apiVersion,String compliance,String kind,String name,String namespace) {
    return (A)addToDependencies(new PolicyDependency(apiVersion, compliance, kind, name, namespace));
  }
  
  public DependenciesNested<A> addNewDependency() {
    return new DependenciesNested(-1, null);
  }
  
  public DependenciesNested<A> addNewDependencyLike(PolicyDependency item) {
    return new DependenciesNested(-1, item);
  }
  
  public DependenciesNested<A> setNewDependencyLike(int index,PolicyDependency item) {
    return new DependenciesNested(index, item);
  }
  
  public DependenciesNested<A> editDependency(int index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  
  public DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  
  public DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  
  public DependenciesNested<A> editMatchingDependency(Predicate<PolicyDependencyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  
  public Boolean getDisabled() {
    return this.disabled;
  }
  
  public A withDisabled(Boolean disabled) {
    this.disabled = disabled;
    return (A) this;
  }
  
  public boolean hasDisabled() {
    return this.disabled != null;
  }
  
  public HubTemplateOptions buildHubTemplateOptions() {
    return this.hubTemplateOptions != null ? this.hubTemplateOptions.build() : null;
  }
  
  public A withHubTemplateOptions(HubTemplateOptions hubTemplateOptions) {
    this._visitables.remove("hubTemplateOptions");
    if (hubTemplateOptions != null) {
        this.hubTemplateOptions = new HubTemplateOptionsBuilder(hubTemplateOptions);
        this._visitables.get("hubTemplateOptions").add(this.hubTemplateOptions);
    } else {
        this.hubTemplateOptions = null;
        this._visitables.get("hubTemplateOptions").remove(this.hubTemplateOptions);
    }
    return (A) this;
  }
  
  public boolean hasHubTemplateOptions() {
    return this.hubTemplateOptions != null;
  }
  
  public A withNewHubTemplateOptions(String serviceAccountName) {
    return (A)withHubTemplateOptions(new HubTemplateOptions(serviceAccountName));
  }
  
  public HubTemplateOptionsNested<A> withNewHubTemplateOptions() {
    return new HubTemplateOptionsNested(null);
  }
  
  public HubTemplateOptionsNested<A> withNewHubTemplateOptionsLike(HubTemplateOptions item) {
    return new HubTemplateOptionsNested(item);
  }
  
  public HubTemplateOptionsNested<A> editHubTemplateOptions() {
    return withNewHubTemplateOptionsLike(java.util.Optional.ofNullable(buildHubTemplateOptions()).orElse(null));
  }
  
  public HubTemplateOptionsNested<A> editOrNewHubTemplateOptions() {
    return withNewHubTemplateOptionsLike(java.util.Optional.ofNullable(buildHubTemplateOptions()).orElse(new HubTemplateOptionsBuilder().build()));
  }
  
  public HubTemplateOptionsNested<A> editOrNewHubTemplateOptionsLike(HubTemplateOptions item) {
    return withNewHubTemplateOptionsLike(java.util.Optional.ofNullable(buildHubTemplateOptions()).orElse(item));
  }
  
  public A addToPolicyTemplates(int index,PolicyTemplate item) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
    if (index < 0 || index >= policyTemplates.size()) { _visitables.get("policyTemplates").add(builder); policyTemplates.add(builder); } else { _visitables.get("policyTemplates").add(index, builder); policyTemplates.add(index, builder);}
    return (A)this;
  }
  
  public A setToPolicyTemplates(int index,PolicyTemplate item) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
    if (index < 0 || index >= policyTemplates.size()) { _visitables.get("policyTemplates").add(builder); policyTemplates.add(builder); } else { _visitables.get("policyTemplates").set(index, builder); policyTemplates.set(index, builder);}
    return (A)this;
  }
  
  public A addToPolicyTemplates(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyTemplate... items) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").add(builder);this.policyTemplates.add(builder);} return (A)this;
  }
  
  public A addAllToPolicyTemplates(Collection<PolicyTemplate> items) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").add(builder);this.policyTemplates.add(builder);} return (A)this;
  }
  
  public A removeFromPolicyTemplates(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyTemplate... items) {
    if (this.policyTemplates == null) return (A)this;
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").remove(builder); this.policyTemplates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPolicyTemplates(Collection<PolicyTemplate> items) {
    if (this.policyTemplates == null) return (A)this;
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").remove(builder); this.policyTemplates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPolicyTemplates(Predicate<PolicyTemplateBuilder> predicate) {
    if (policyTemplates == null) return (A) this;
    final Iterator<PolicyTemplateBuilder> each = policyTemplates.iterator();
    final List visitables = _visitables.get("policyTemplates");
    while (each.hasNext()) {
      PolicyTemplateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PolicyTemplate> buildPolicyTemplates() {
    return this.policyTemplates != null ? build(policyTemplates) : null;
  }
  
  public PolicyTemplate buildPolicyTemplate(int index) {
    return this.policyTemplates.get(index).build();
  }
  
  public PolicyTemplate buildFirstPolicyTemplate() {
    return this.policyTemplates.get(0).build();
  }
  
  public PolicyTemplate buildLastPolicyTemplate() {
    return this.policyTemplates.get(policyTemplates.size() - 1).build();
  }
  
  public PolicyTemplate buildMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
      for (PolicyTemplateBuilder item : policyTemplates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
      for (PolicyTemplateBuilder item : policyTemplates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPolicyTemplates(List<PolicyTemplate> policyTemplates) {
    if (this.policyTemplates != null) {
      this._visitables.get("policyTemplates").clear();
    }
    if (policyTemplates != null) {
        this.policyTemplates = new ArrayList();
        for (PolicyTemplate item : policyTemplates) {
          this.addToPolicyTemplates(item);
        }
    } else {
      this.policyTemplates = null;
    }
    return (A) this;
  }
  
  public A withPolicyTemplates(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyTemplate... policyTemplates) {
    if (this.policyTemplates != null) {
        this.policyTemplates.clear();
        _visitables.remove("policyTemplates");
    }
    if (policyTemplates != null) {
      for (PolicyTemplate item : policyTemplates) {
        this.addToPolicyTemplates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPolicyTemplates() {
    return this.policyTemplates != null && !this.policyTemplates.isEmpty();
  }
  
  public PolicyTemplatesNested<A> addNewPolicyTemplate() {
    return new PolicyTemplatesNested(-1, null);
  }
  
  public PolicyTemplatesNested<A> addNewPolicyTemplateLike(PolicyTemplate item) {
    return new PolicyTemplatesNested(-1, item);
  }
  
  public PolicyTemplatesNested<A> setNewPolicyTemplateLike(int index,PolicyTemplate item) {
    return new PolicyTemplatesNested(index, item);
  }
  
  public PolicyTemplatesNested<A> editPolicyTemplate(int index) {
    if (policyTemplates.size() <= index) throw new RuntimeException("Can't edit policyTemplates. Index exceeds size.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  
  public PolicyTemplatesNested<A> editFirstPolicyTemplate() {
    if (policyTemplates.size() == 0) throw new RuntimeException("Can't edit first policyTemplates. The list is empty.");
    return setNewPolicyTemplateLike(0, buildPolicyTemplate(0));
  }
  
  public PolicyTemplatesNested<A> editLastPolicyTemplate() {
    int index = policyTemplates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last policyTemplates. The list is empty.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  
  public PolicyTemplatesNested<A> editMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<policyTemplates.size();i++) { 
    if (predicate.test(policyTemplates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching policyTemplates. No match found.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  
  public String getRemediationAction() {
    return this.remediationAction;
  }
  
  public A withRemediationAction(String remediationAction) {
    this.remediationAction = remediationAction;
    return (A) this;
  }
  
  public boolean hasRemediationAction() {
    return this.remediationAction != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicySpecFluent that = (PolicySpecFluent) o;
    if (!java.util.Objects.equals(copyPolicyMetadata, that.copyPolicyMetadata)) return false;
    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;
    if (!java.util.Objects.equals(disabled, that.disabled)) return false;
    if (!java.util.Objects.equals(hubTemplateOptions, that.hubTemplateOptions)) return false;
    if (!java.util.Objects.equals(policyTemplates, that.policyTemplates)) return false;
    if (!java.util.Objects.equals(remediationAction, that.remediationAction)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(copyPolicyMetadata,  dependencies,  disabled,  hubTemplateOptions,  policyTemplates,  remediationAction,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (copyPolicyMetadata != null) { sb.append("copyPolicyMetadata:"); sb.append(copyPolicyMetadata + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (disabled != null) { sb.append("disabled:"); sb.append(disabled + ","); }
    if (hubTemplateOptions != null) { sb.append("hubTemplateOptions:"); sb.append(hubTemplateOptions + ","); }
    if (policyTemplates != null && !policyTemplates.isEmpty()) { sb.append("policyTemplates:"); sb.append(policyTemplates + ","); }
    if (remediationAction != null) { sb.append("remediationAction:"); sb.append(remediationAction + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withCopyPolicyMetadata() {
    return withCopyPolicyMetadata(true);
  }
  
  public A withDisabled() {
    return withDisabled(true);
  }
  public class DependenciesNested<N> extends PolicyDependencyFluent<DependenciesNested<N>> implements Nested<N>{
    DependenciesNested(int index,PolicyDependency item) {
      this.index = index;
      this.builder = new PolicyDependencyBuilder(this, item);
    }
    PolicyDependencyBuilder builder;
    int index;
    
    public N and() {
      return (N) PolicySpecFluent.this.setToDependencies(index,builder.build());
    }
    
    public N endDependency() {
      return and();
    }
    
  
  }
  public class HubTemplateOptionsNested<N> extends HubTemplateOptionsFluent<HubTemplateOptionsNested<N>> implements Nested<N>{
    HubTemplateOptionsNested(HubTemplateOptions item) {
      this.builder = new HubTemplateOptionsBuilder(this, item);
    }
    HubTemplateOptionsBuilder builder;
    
    public N and() {
      return (N) PolicySpecFluent.this.withHubTemplateOptions(builder.build());
    }
    
    public N endHubTemplateOptions() {
      return and();
    }
    
  
  }
  public class PolicyTemplatesNested<N> extends PolicyTemplateFluent<PolicyTemplatesNested<N>> implements Nested<N>{
    PolicyTemplatesNested(int index,PolicyTemplate item) {
      this.index = index;
      this.builder = new PolicyTemplateBuilder(this, item);
    }
    PolicyTemplateBuilder builder;
    int index;
    
    public N and() {
      return (N) PolicySpecFluent.this.setToPolicyTemplates(index,builder.build());
    }
    
    public N endPolicyTemplate() {
      return and();
    }
    
  
  }

}