package io.fabric8.openclustermanagement.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PolicyTemplateFluent<A extends PolicyTemplateFluent<A>> extends BaseFluent<A>{
  public PolicyTemplateFluent() {
  }
  
  public PolicyTemplateFluent(PolicyTemplate instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PolicyDependencyBuilder> extraDependencies = new ArrayList<PolicyDependencyBuilder>();
  private Boolean ignorePending;
  private Object objectDefinition;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PolicyTemplate instance) {
    instance = (instance != null ? instance : new PolicyTemplate());
    if (instance != null) {
          this.withExtraDependencies(instance.getExtraDependencies());
          this.withIgnorePending(instance.getIgnorePending());
          this.withObjectDefinition(instance.getObjectDefinition());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToExtraDependencies(int index,PolicyDependency item) {
    if (this.extraDependencies == null) {this.extraDependencies = new ArrayList<PolicyDependencyBuilder>();}
    PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
    if (index < 0 || index >= extraDependencies.size()) { _visitables.get("extraDependencies").add(builder); extraDependencies.add(builder); } else { _visitables.get("extraDependencies").add(index, builder); extraDependencies.add(index, builder);}
    return (A)this;
  }
  
  public A setToExtraDependencies(int index,PolicyDependency item) {
    if (this.extraDependencies == null) {this.extraDependencies = new ArrayList<PolicyDependencyBuilder>();}
    PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);
    if (index < 0 || index >= extraDependencies.size()) { _visitables.get("extraDependencies").add(builder); extraDependencies.add(builder); } else { _visitables.get("extraDependencies").set(index, builder); extraDependencies.set(index, builder);}
    return (A)this;
  }
  
  public A addToExtraDependencies(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependency... items) {
    if (this.extraDependencies == null) {this.extraDependencies = new ArrayList<PolicyDependencyBuilder>();}
    for (PolicyDependency item : items) {PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);_visitables.get("extraDependencies").add(builder);this.extraDependencies.add(builder);} return (A)this;
  }
  
  public A addAllToExtraDependencies(Collection<PolicyDependency> items) {
    if (this.extraDependencies == null) {this.extraDependencies = new ArrayList<PolicyDependencyBuilder>();}
    for (PolicyDependency item : items) {PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);_visitables.get("extraDependencies").add(builder);this.extraDependencies.add(builder);} return (A)this;
  }
  
  public A removeFromExtraDependencies(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependency... items) {
    if (this.extraDependencies == null) return (A)this;
    for (PolicyDependency item : items) {PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);_visitables.get("extraDependencies").remove(builder); this.extraDependencies.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExtraDependencies(Collection<PolicyDependency> items) {
    if (this.extraDependencies == null) return (A)this;
    for (PolicyDependency item : items) {PolicyDependencyBuilder builder = new PolicyDependencyBuilder(item);_visitables.get("extraDependencies").remove(builder); this.extraDependencies.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExtraDependencies(Predicate<PolicyDependencyBuilder> predicate) {
    if (extraDependencies == null) return (A) this;
    final Iterator<PolicyDependencyBuilder> each = extraDependencies.iterator();
    final List visitables = _visitables.get("extraDependencies");
    while (each.hasNext()) {
      PolicyDependencyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PolicyDependency> buildExtraDependencies() {
    return this.extraDependencies != null ? build(extraDependencies) : null;
  }
  
  public PolicyDependency buildExtraDependency(int index) {
    return this.extraDependencies.get(index).build();
  }
  
  public PolicyDependency buildFirstExtraDependency() {
    return this.extraDependencies.get(0).build();
  }
  
  public PolicyDependency buildLastExtraDependency() {
    return this.extraDependencies.get(extraDependencies.size() - 1).build();
  }
  
  public PolicyDependency buildMatchingExtraDependency(Predicate<PolicyDependencyBuilder> predicate) {
      for (PolicyDependencyBuilder item : extraDependencies) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExtraDependency(Predicate<PolicyDependencyBuilder> predicate) {
      for (PolicyDependencyBuilder item : extraDependencies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExtraDependencies(List<PolicyDependency> extraDependencies) {
    if (this.extraDependencies != null) {
      this._visitables.get("extraDependencies").clear();
    }
    if (extraDependencies != null) {
        this.extraDependencies = new ArrayList();
        for (PolicyDependency item : extraDependencies) {
          this.addToExtraDependencies(item);
        }
    } else {
      this.extraDependencies = null;
    }
    return (A) this;
  }
  
  public A withExtraDependencies(io.fabric8.openclustermanagement.api.model.policy.v1.PolicyDependency... extraDependencies) {
    if (this.extraDependencies != null) {
        this.extraDependencies.clear();
        _visitables.remove("extraDependencies");
    }
    if (extraDependencies != null) {
      for (PolicyDependency item : extraDependencies) {
        this.addToExtraDependencies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExtraDependencies() {
    return this.extraDependencies != null && !this.extraDependencies.isEmpty();
  }
  
  public A addNewExtraDependency(String apiVersion,String compliance,String kind,String name,String namespace) {
    return (A)addToExtraDependencies(new PolicyDependency(apiVersion, compliance, kind, name, namespace));
  }
  
  public ExtraDependenciesNested<A> addNewExtraDependency() {
    return new ExtraDependenciesNested(-1, null);
  }
  
  public ExtraDependenciesNested<A> addNewExtraDependencyLike(PolicyDependency item) {
    return new ExtraDependenciesNested(-1, item);
  }
  
  public ExtraDependenciesNested<A> setNewExtraDependencyLike(int index,PolicyDependency item) {
    return new ExtraDependenciesNested(index, item);
  }
  
  public ExtraDependenciesNested<A> editExtraDependency(int index) {
    if (extraDependencies.size() <= index) throw new RuntimeException("Can't edit extraDependencies. Index exceeds size.");
    return setNewExtraDependencyLike(index, buildExtraDependency(index));
  }
  
  public ExtraDependenciesNested<A> editFirstExtraDependency() {
    if (extraDependencies.size() == 0) throw new RuntimeException("Can't edit first extraDependencies. The list is empty.");
    return setNewExtraDependencyLike(0, buildExtraDependency(0));
  }
  
  public ExtraDependenciesNested<A> editLastExtraDependency() {
    int index = extraDependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extraDependencies. The list is empty.");
    return setNewExtraDependencyLike(index, buildExtraDependency(index));
  }
  
  public ExtraDependenciesNested<A> editMatchingExtraDependency(Predicate<PolicyDependencyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extraDependencies.size();i++) { 
    if (predicate.test(extraDependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extraDependencies. No match found.");
    return setNewExtraDependencyLike(index, buildExtraDependency(index));
  }
  
  public Boolean getIgnorePending() {
    return this.ignorePending;
  }
  
  public A withIgnorePending(Boolean ignorePending) {
    this.ignorePending = ignorePending;
    return (A) this;
  }
  
  public boolean hasIgnorePending() {
    return this.ignorePending != null;
  }
  
  public Object getObjectDefinition() {
    return this.objectDefinition;
  }
  
  public A withObjectDefinition(Object objectDefinition) {
    this.objectDefinition = objectDefinition;
    return (A) this;
  }
  
  public boolean hasObjectDefinition() {
    return this.objectDefinition != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicyTemplateFluent that = (PolicyTemplateFluent) o;
    if (!java.util.Objects.equals(extraDependencies, that.extraDependencies)) return false;
    if (!java.util.Objects.equals(ignorePending, that.ignorePending)) return false;
    if (!java.util.Objects.equals(objectDefinition, that.objectDefinition)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(extraDependencies,  ignorePending,  objectDefinition,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (extraDependencies != null && !extraDependencies.isEmpty()) { sb.append("extraDependencies:"); sb.append(extraDependencies + ","); }
    if (ignorePending != null) { sb.append("ignorePending:"); sb.append(ignorePending + ","); }
    if (objectDefinition != null) { sb.append("objectDefinition:"); sb.append(objectDefinition + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withIgnorePending() {
    return withIgnorePending(true);
  }
  public class ExtraDependenciesNested<N> extends PolicyDependencyFluent<ExtraDependenciesNested<N>> implements Nested<N>{
    ExtraDependenciesNested(int index,PolicyDependency item) {
      this.index = index;
      this.builder = new PolicyDependencyBuilder(this, item);
    }
    PolicyDependencyBuilder builder;
    int index;
    
    public N and() {
      return (N) PolicyTemplateFluent.this.setToExtraDependencies(index,builder.build());
    }
    
    public N endExtraDependency() {
      return and();
    }
    
  
  }

}