package io.fabric8.openclustermanagement.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PolicySetSpecBuilder extends PolicySetSpecFluent<PolicySetSpecBuilder> implements VisitableBuilder<PolicySetSpec,PolicySetSpecBuilder>{
  public PolicySetSpecBuilder() {
    this(new PolicySetSpec());
  }
  
  public PolicySetSpecBuilder(PolicySetSpecFluent<?> fluent) {
    this(fluent, new PolicySetSpec());
  }
  
  public PolicySetSpecBuilder(PolicySetSpecFluent<?> fluent,PolicySetSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PolicySetSpecBuilder(PolicySetSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PolicySetSpecFluent<?> fluent;
  
  public PolicySetSpec build() {
    PolicySetSpec buildable = new PolicySetSpec(fluent.getDescription(),fluent.getPolicies());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}