package io.fabric8.openclustermanagement.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ReplicatedDetailsPerTemplateFluent<A extends ReplicatedDetailsPerTemplateFluent<A>> extends BaseFluent<A>{
  public ReplicatedDetailsPerTemplateFluent() {
  }
  
  public ReplicatedDetailsPerTemplateFluent(ReplicatedDetailsPerTemplate instance) {
    this.copyInstance(instance);
  }
  private String compliant;
  private ArrayList<ReplicatedComplianceHistoryBuilder> history = new ArrayList<ReplicatedComplianceHistoryBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ReplicatedDetailsPerTemplate instance) {
    instance = (instance != null ? instance : new ReplicatedDetailsPerTemplate());
    if (instance != null) {
          this.withCompliant(instance.getCompliant());
          this.withHistory(instance.getHistory());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCompliant() {
    return this.compliant;
  }
  
  public A withCompliant(String compliant) {
    this.compliant = compliant;
    return (A) this;
  }
  
  public boolean hasCompliant() {
    return this.compliant != null;
  }
  
  public A addToHistory(int index,ReplicatedComplianceHistory item) {
    if (this.history == null) {this.history = new ArrayList<ReplicatedComplianceHistoryBuilder>();}
    ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);
    if (index < 0 || index >= history.size()) { _visitables.get("history").add(builder); history.add(builder); } else { _visitables.get("history").add(index, builder); history.add(index, builder);}
    return (A)this;
  }
  
  public A setToHistory(int index,ReplicatedComplianceHistory item) {
    if (this.history == null) {this.history = new ArrayList<ReplicatedComplianceHistoryBuilder>();}
    ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);
    if (index < 0 || index >= history.size()) { _visitables.get("history").add(builder); history.add(builder); } else { _visitables.get("history").set(index, builder); history.set(index, builder);}
    return (A)this;
  }
  
  public A addToHistory(io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedComplianceHistory... items) {
    if (this.history == null) {this.history = new ArrayList<ReplicatedComplianceHistoryBuilder>();}
    for (ReplicatedComplianceHistory item : items) {ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  
  public A addAllToHistory(Collection<ReplicatedComplianceHistory> items) {
    if (this.history == null) {this.history = new ArrayList<ReplicatedComplianceHistoryBuilder>();}
    for (ReplicatedComplianceHistory item : items) {ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  
  public A removeFromHistory(io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedComplianceHistory... items) {
    if (this.history == null) return (A)this;
    for (ReplicatedComplianceHistory item : items) {ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);_visitables.get("history").remove(builder); this.history.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHistory(Collection<ReplicatedComplianceHistory> items) {
    if (this.history == null) return (A)this;
    for (ReplicatedComplianceHistory item : items) {ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);_visitables.get("history").remove(builder); this.history.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHistory(Predicate<ReplicatedComplianceHistoryBuilder> predicate) {
    if (history == null) return (A) this;
    final Iterator<ReplicatedComplianceHistoryBuilder> each = history.iterator();
    final List visitables = _visitables.get("history");
    while (each.hasNext()) {
      ReplicatedComplianceHistoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ReplicatedComplianceHistory> buildHistory() {
    return this.history != null ? build(history) : null;
  }
  
  public ReplicatedComplianceHistory buildHistory(int index) {
    return this.history.get(index).build();
  }
  
  public ReplicatedComplianceHistory buildFirstHistory() {
    return this.history.get(0).build();
  }
  
  public ReplicatedComplianceHistory buildLastHistory() {
    return this.history.get(history.size() - 1).build();
  }
  
  public ReplicatedComplianceHistory buildMatchingHistory(Predicate<ReplicatedComplianceHistoryBuilder> predicate) {
      for (ReplicatedComplianceHistoryBuilder item : history) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHistory(Predicate<ReplicatedComplianceHistoryBuilder> predicate) {
      for (ReplicatedComplianceHistoryBuilder item : history) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHistory(List<ReplicatedComplianceHistory> history) {
    if (this.history != null) {
      this._visitables.get("history").clear();
    }
    if (history != null) {
        this.history = new ArrayList();
        for (ReplicatedComplianceHistory item : history) {
          this.addToHistory(item);
        }
    } else {
      this.history = null;
    }
    return (A) this;
  }
  
  public A withHistory(io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedComplianceHistory... history) {
    if (this.history != null) {
        this.history.clear();
        _visitables.remove("history");
    }
    if (history != null) {
      for (ReplicatedComplianceHistory item : history) {
        this.addToHistory(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHistory() {
    return this.history != null && !this.history.isEmpty();
  }
  
  public A addNewHistory(String lastTimestamp,String message) {
    return (A)addToHistory(new ReplicatedComplianceHistory(lastTimestamp, message));
  }
  
  public HistoryNested<A> addNewHistory() {
    return new HistoryNested(-1, null);
  }
  
  public HistoryNested<A> addNewHistoryLike(ReplicatedComplianceHistory item) {
    return new HistoryNested(-1, item);
  }
  
  public HistoryNested<A> setNewHistoryLike(int index,ReplicatedComplianceHistory item) {
    return new HistoryNested(index, item);
  }
  
  public HistoryNested<A> editHistory(int index) {
    if (history.size() <= index) throw new RuntimeException("Can't edit history. Index exceeds size.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  
  public HistoryNested<A> editFirstHistory() {
    if (history.size() == 0) throw new RuntimeException("Can't edit first history. The list is empty.");
    return setNewHistoryLike(0, buildHistory(0));
  }
  
  public HistoryNested<A> editLastHistory() {
    int index = history.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last history. The list is empty.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  
  public HistoryNested<A> editMatchingHistory(Predicate<ReplicatedComplianceHistoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<history.size();i++) { 
    if (predicate.test(history.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching history. No match found.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReplicatedDetailsPerTemplateFluent that = (ReplicatedDetailsPerTemplateFluent) o;
    if (!java.util.Objects.equals(compliant, that.compliant)) return false;
    if (!java.util.Objects.equals(history, that.history)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(compliant,  history,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (compliant != null) { sb.append("compliant:"); sb.append(compliant + ","); }
    if (history != null && !history.isEmpty()) { sb.append("history:"); sb.append(history + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HistoryNested<N> extends ReplicatedComplianceHistoryFluent<HistoryNested<N>> implements Nested<N>{
    HistoryNested(int index,ReplicatedComplianceHistory item) {
      this.index = index;
      this.builder = new ReplicatedComplianceHistoryBuilder(this, item);
    }
    ReplicatedComplianceHistoryBuilder builder;
    int index;
    
    public N and() {
      return (N) ReplicatedDetailsPerTemplateFluent.this.setToHistory(index,builder.build());
    }
    
    public N endHistory() {
      return and();
    }
    
  
  }

}