package io.fabric8.openclustermanagement.api.model.search.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DeploymentConfigFluent<A extends DeploymentConfigFluent<A>> extends BaseFluent<A>{
  public DeploymentConfigFluent() {
  }
  
  public DeploymentConfigFluent(DeploymentConfig instance) {
    this.copyInstance(instance);
  }
  private List<String> arguments = new ArrayList<String>();
  private ArrayList<EnvVarBuilder> envVar = new ArrayList<EnvVarBuilder>();
  private String imageOverride;
  private Integer replicaCount;
  private ResourceRequirementsBuilder resources;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DeploymentConfig instance) {
    instance = (instance != null ? instance : new DeploymentConfig());
    if (instance != null) {
          this.withArguments(instance.getArguments());
          this.withEnvVar(instance.getEnvVar());
          this.withImageOverride(instance.getImageOverride());
          this.withReplicaCount(instance.getReplicaCount());
          this.withResources(instance.getResources());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToArguments(int index,String item) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    this.arguments.add(index, item);
    return (A)this;
  }
  
  public A setToArguments(int index,String item) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    this.arguments.set(index, item); return (A)this;
  }
  
  public A addToArguments(java.lang.String... items) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    for (String item : items) {this.arguments.add(item);} return (A)this;
  }
  
  public A addAllToArguments(Collection<String> items) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    for (String item : items) {this.arguments.add(item);} return (A)this;
  }
  
  public A removeFromArguments(java.lang.String... items) {
    if (this.arguments == null) return (A)this;
    for (String item : items) { this.arguments.remove(item);} return (A)this;
  }
  
  public A removeAllFromArguments(Collection<String> items) {
    if (this.arguments == null) return (A)this;
    for (String item : items) { this.arguments.remove(item);} return (A)this;
  }
  
  public List<String> getArguments() {
    return this.arguments;
  }
  
  public String getArgument(int index) {
    return this.arguments.get(index);
  }
  
  public String getFirstArgument() {
    return this.arguments.get(0);
  }
  
  public String getLastArgument() {
    return this.arguments.get(arguments.size() - 1);
  }
  
  public String getMatchingArgument(Predicate<String> predicate) {
      for (String item : arguments) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingArgument(Predicate<String> predicate) {
      for (String item : arguments) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withArguments(List<String> arguments) {
    if (arguments != null) {
        this.arguments = new ArrayList();
        for (String item : arguments) {
          this.addToArguments(item);
        }
    } else {
      this.arguments = null;
    }
    return (A) this;
  }
  
  public A withArguments(java.lang.String... arguments) {
    if (this.arguments != null) {
        this.arguments.clear();
        _visitables.remove("arguments");
    }
    if (arguments != null) {
      for (String item : arguments) {
        this.addToArguments(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasArguments() {
    return this.arguments != null && !this.arguments.isEmpty();
  }
  
  public A addToEnvVar(int index,EnvVar item) {
    if (this.envVar == null) {this.envVar = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= envVar.size()) { _visitables.get("envVar").add(builder); envVar.add(builder); } else { _visitables.get("envVar").add(index, builder); envVar.add(index, builder);}
    return (A)this;
  }
  
  public A setToEnvVar(int index,EnvVar item) {
    if (this.envVar == null) {this.envVar = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= envVar.size()) { _visitables.get("envVar").add(builder); envVar.add(builder); } else { _visitables.get("envVar").set(index, builder); envVar.set(index, builder);}
    return (A)this;
  }
  
  public A addToEnvVar(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.envVar == null) {this.envVar = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("envVar").add(builder);this.envVar.add(builder);} return (A)this;
  }
  
  public A addAllToEnvVar(Collection<EnvVar> items) {
    if (this.envVar == null) {this.envVar = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("envVar").add(builder);this.envVar.add(builder);} return (A)this;
  }
  
  public A removeFromEnvVar(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.envVar == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("envVar").remove(builder); this.envVar.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEnvVar(Collection<EnvVar> items) {
    if (this.envVar == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("envVar").remove(builder); this.envVar.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEnvVar(Predicate<EnvVarBuilder> predicate) {
    if (envVar == null) return (A) this;
    final Iterator<EnvVarBuilder> each = envVar.iterator();
    final List visitables = _visitables.get("envVar");
    while (each.hasNext()) {
      EnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EnvVar> buildEnvVar() {
    return this.envVar != null ? build(envVar) : null;
  }
  
  public EnvVar buildEnvVar(int index) {
    return this.envVar.get(index).build();
  }
  
  public EnvVar buildFirstEnvVar() {
    return this.envVar.get(0).build();
  }
  
  public EnvVar buildLastEnvVar() {
    return this.envVar.get(envVar.size() - 1).build();
  }
  
  public EnvVar buildMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : envVar) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : envVar) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnvVar(List<EnvVar> envVar) {
    if (this.envVar != null) {
      this._visitables.get("envVar").clear();
    }
    if (envVar != null) {
        this.envVar = new ArrayList();
        for (EnvVar item : envVar) {
          this.addToEnvVar(item);
        }
    } else {
      this.envVar = null;
    }
    return (A) this;
  }
  
  public A withEnvVar(io.fabric8.kubernetes.api.model.EnvVar... envVar) {
    if (this.envVar != null) {
        this.envVar.clear();
        _visitables.remove("envVar");
    }
    if (envVar != null) {
      for (EnvVar item : envVar) {
        this.addToEnvVar(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEnvVar() {
    return this.envVar != null && !this.envVar.isEmpty();
  }
  
  public EnvVarNested<A> addNewEnvVar() {
    return new EnvVarNested(-1, null);
  }
  
  public EnvVarNested<A> addNewEnvVarLike(EnvVar item) {
    return new EnvVarNested(-1, item);
  }
  
  public EnvVarNested<A> setNewEnvVarLike(int index,EnvVar item) {
    return new EnvVarNested(index, item);
  }
  
  public EnvVarNested<A> editEnvVar(int index) {
    if (envVar.size() <= index) throw new RuntimeException("Can't edit envVar. Index exceeds size.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public EnvVarNested<A> editFirstEnvVar() {
    if (envVar.size() == 0) throw new RuntimeException("Can't edit first envVar. The list is empty.");
    return setNewEnvVarLike(0, buildEnvVar(0));
  }
  
  public EnvVarNested<A> editLastEnvVar() {
    int index = envVar.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last envVar. The list is empty.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public EnvVarNested<A> editMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<envVar.size();i++) { 
    if (predicate.test(envVar.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching envVar. No match found.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public String getImageOverride() {
    return this.imageOverride;
  }
  
  public A withImageOverride(String imageOverride) {
    this.imageOverride = imageOverride;
    return (A) this;
  }
  
  public boolean hasImageOverride() {
    return this.imageOverride != null;
  }
  
  public Integer getReplicaCount() {
    return this.replicaCount;
  }
  
  public A withReplicaCount(Integer replicaCount) {
    this.replicaCount = replicaCount;
    return (A) this;
  }
  
  public boolean hasReplicaCount() {
    return this.replicaCount != null;
  }
  
  public ResourceRequirements buildResources() {
    return this.resources != null ? this.resources.build() : null;
  }
  
  public A withResources(ResourceRequirements resources) {
    this._visitables.remove("resources");
    if (resources != null) {
        this.resources = new ResourceRequirementsBuilder(resources);
        this._visitables.get("resources").add(this.resources);
    } else {
        this.resources = null;
        this._visitables.get("resources").remove(this.resources);
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  
  public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ResourcesNested(item);
  }
  
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentConfigFluent that = (DeploymentConfigFluent) o;
    if (!java.util.Objects.equals(arguments, that.arguments)) return false;
    if (!java.util.Objects.equals(envVar, that.envVar)) return false;
    if (!java.util.Objects.equals(imageOverride, that.imageOverride)) return false;
    if (!java.util.Objects.equals(replicaCount, that.replicaCount)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(arguments,  envVar,  imageOverride,  replicaCount,  resources,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (arguments != null && !arguments.isEmpty()) { sb.append("arguments:"); sb.append(arguments + ","); }
    if (envVar != null && !envVar.isEmpty()) { sb.append("envVar:"); sb.append(envVar + ","); }
    if (imageOverride != null) { sb.append("imageOverride:"); sb.append(imageOverride + ","); }
    if (replicaCount != null) { sb.append("replicaCount:"); sb.append(replicaCount + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EnvVarNested<N> extends EnvVarFluent<EnvVarNested<N>> implements Nested<N>{
    EnvVarNested(int index,EnvVar item) {
      this.index = index;
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarBuilder builder;
    int index;
    
    public N and() {
      return (N) DeploymentConfigFluent.this.setToEnvVar(index,builder.build());
    }
    
    public N endEnvVar() {
      return and();
    }
    
  
  }
  public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) DeploymentConfigFluent.this.withResources(builder.build());
    }
    
    public N endResources() {
      return and();
    }
    
  
  }

}