package io.fabric8.openclustermanagement.api.model.search.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SearchDeploymentsFluent<A extends SearchDeploymentsFluent<A>> extends BaseFluent<A>{
  public SearchDeploymentsFluent() {
  }
  
  public SearchDeploymentsFluent(SearchDeployments instance) {
    this.copyInstance(instance);
  }
  private DeploymentConfigBuilder collector;
  private DeploymentConfigBuilder database;
  private DeploymentConfigBuilder indexer;
  private DeploymentConfigBuilder queryapi;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SearchDeployments instance) {
    instance = (instance != null ? instance : new SearchDeployments());
    if (instance != null) {
          this.withCollector(instance.getCollector());
          this.withDatabase(instance.getDatabase());
          this.withIndexer(instance.getIndexer());
          this.withQueryapi(instance.getQueryapi());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public DeploymentConfig buildCollector() {
    return this.collector != null ? this.collector.build() : null;
  }
  
  public A withCollector(DeploymentConfig collector) {
    this._visitables.remove("collector");
    if (collector != null) {
        this.collector = new DeploymentConfigBuilder(collector);
        this._visitables.get("collector").add(this.collector);
    } else {
        this.collector = null;
        this._visitables.get("collector").remove(this.collector);
    }
    return (A) this;
  }
  
  public boolean hasCollector() {
    return this.collector != null;
  }
  
  public CollectorNested<A> withNewCollector() {
    return new CollectorNested(null);
  }
  
  public CollectorNested<A> withNewCollectorLike(DeploymentConfig item) {
    return new CollectorNested(item);
  }
  
  public CollectorNested<A> editCollector() {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(null));
  }
  
  public CollectorNested<A> editOrNewCollector() {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(new DeploymentConfigBuilder().build()));
  }
  
  public CollectorNested<A> editOrNewCollectorLike(DeploymentConfig item) {
    return withNewCollectorLike(java.util.Optional.ofNullable(buildCollector()).orElse(item));
  }
  
  public DeploymentConfig buildDatabase() {
    return this.database != null ? this.database.build() : null;
  }
  
  public A withDatabase(DeploymentConfig database) {
    this._visitables.remove("database");
    if (database != null) {
        this.database = new DeploymentConfigBuilder(database);
        this._visitables.get("database").add(this.database);
    } else {
        this.database = null;
        this._visitables.get("database").remove(this.database);
    }
    return (A) this;
  }
  
  public boolean hasDatabase() {
    return this.database != null;
  }
  
  public DatabaseNested<A> withNewDatabase() {
    return new DatabaseNested(null);
  }
  
  public DatabaseNested<A> withNewDatabaseLike(DeploymentConfig item) {
    return new DatabaseNested(item);
  }
  
  public DatabaseNested<A> editDatabase() {
    return withNewDatabaseLike(java.util.Optional.ofNullable(buildDatabase()).orElse(null));
  }
  
  public DatabaseNested<A> editOrNewDatabase() {
    return withNewDatabaseLike(java.util.Optional.ofNullable(buildDatabase()).orElse(new DeploymentConfigBuilder().build()));
  }
  
  public DatabaseNested<A> editOrNewDatabaseLike(DeploymentConfig item) {
    return withNewDatabaseLike(java.util.Optional.ofNullable(buildDatabase()).orElse(item));
  }
  
  public DeploymentConfig buildIndexer() {
    return this.indexer != null ? this.indexer.build() : null;
  }
  
  public A withIndexer(DeploymentConfig indexer) {
    this._visitables.remove("indexer");
    if (indexer != null) {
        this.indexer = new DeploymentConfigBuilder(indexer);
        this._visitables.get("indexer").add(this.indexer);
    } else {
        this.indexer = null;
        this._visitables.get("indexer").remove(this.indexer);
    }
    return (A) this;
  }
  
  public boolean hasIndexer() {
    return this.indexer != null;
  }
  
  public IndexerNested<A> withNewIndexer() {
    return new IndexerNested(null);
  }
  
  public IndexerNested<A> withNewIndexerLike(DeploymentConfig item) {
    return new IndexerNested(item);
  }
  
  public IndexerNested<A> editIndexer() {
    return withNewIndexerLike(java.util.Optional.ofNullable(buildIndexer()).orElse(null));
  }
  
  public IndexerNested<A> editOrNewIndexer() {
    return withNewIndexerLike(java.util.Optional.ofNullable(buildIndexer()).orElse(new DeploymentConfigBuilder().build()));
  }
  
  public IndexerNested<A> editOrNewIndexerLike(DeploymentConfig item) {
    return withNewIndexerLike(java.util.Optional.ofNullable(buildIndexer()).orElse(item));
  }
  
  public DeploymentConfig buildQueryapi() {
    return this.queryapi != null ? this.queryapi.build() : null;
  }
  
  public A withQueryapi(DeploymentConfig queryapi) {
    this._visitables.remove("queryapi");
    if (queryapi != null) {
        this.queryapi = new DeploymentConfigBuilder(queryapi);
        this._visitables.get("queryapi").add(this.queryapi);
    } else {
        this.queryapi = null;
        this._visitables.get("queryapi").remove(this.queryapi);
    }
    return (A) this;
  }
  
  public boolean hasQueryapi() {
    return this.queryapi != null;
  }
  
  public QueryapiNested<A> withNewQueryapi() {
    return new QueryapiNested(null);
  }
  
  public QueryapiNested<A> withNewQueryapiLike(DeploymentConfig item) {
    return new QueryapiNested(item);
  }
  
  public QueryapiNested<A> editQueryapi() {
    return withNewQueryapiLike(java.util.Optional.ofNullable(buildQueryapi()).orElse(null));
  }
  
  public QueryapiNested<A> editOrNewQueryapi() {
    return withNewQueryapiLike(java.util.Optional.ofNullable(buildQueryapi()).orElse(new DeploymentConfigBuilder().build()));
  }
  
  public QueryapiNested<A> editOrNewQueryapiLike(DeploymentConfig item) {
    return withNewQueryapiLike(java.util.Optional.ofNullable(buildQueryapi()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SearchDeploymentsFluent that = (SearchDeploymentsFluent) o;
    if (!java.util.Objects.equals(collector, that.collector)) return false;
    if (!java.util.Objects.equals(database, that.database)) return false;
    if (!java.util.Objects.equals(indexer, that.indexer)) return false;
    if (!java.util.Objects.equals(queryapi, that.queryapi)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(collector,  database,  indexer,  queryapi,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (collector != null) { sb.append("collector:"); sb.append(collector + ","); }
    if (database != null) { sb.append("database:"); sb.append(database + ","); }
    if (indexer != null) { sb.append("indexer:"); sb.append(indexer + ","); }
    if (queryapi != null) { sb.append("queryapi:"); sb.append(queryapi + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CollectorNested<N> extends DeploymentConfigFluent<CollectorNested<N>> implements Nested<N>{
    CollectorNested(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigBuilder builder;
    
    public N and() {
      return (N) SearchDeploymentsFluent.this.withCollector(builder.build());
    }
    
    public N endCollector() {
      return and();
    }
    
  
  }
  public class DatabaseNested<N> extends DeploymentConfigFluent<DatabaseNested<N>> implements Nested<N>{
    DatabaseNested(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigBuilder builder;
    
    public N and() {
      return (N) SearchDeploymentsFluent.this.withDatabase(builder.build());
    }
    
    public N endDatabase() {
      return and();
    }
    
  
  }
  public class IndexerNested<N> extends DeploymentConfigFluent<IndexerNested<N>> implements Nested<N>{
    IndexerNested(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigBuilder builder;
    
    public N and() {
      return (N) SearchDeploymentsFluent.this.withIndexer(builder.build());
    }
    
    public N endIndexer() {
      return and();
    }
    
  
  }
  public class QueryapiNested<N> extends DeploymentConfigFluent<QueryapiNested<N>> implements Nested<N>{
    QueryapiNested(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigBuilder builder;
    
    public N and() {
      return (N) SearchDeploymentsFluent.this.withQueryapi(builder.build());
    }
    
    public N endQueryapi() {
      return and();
    }
    
  
  }

}