package io.fabric8.openclustermanagement.api.model.search.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SearchSpecFluent<A extends SearchSpecFluent<A>> extends BaseFluent<A>{
  public SearchSpecFluent() {
  }
  
  public SearchSpecFluent(SearchSpec instance) {
    this.copyInstance(instance);
  }
  private String availabilityConfig;
  private String dbConfig;
  private StorageSpecBuilder dbStorage;
  private SearchDeploymentsBuilder deployments;
  private String externalDBInstance;
  private String imagePullPolicy;
  private String imagePullSecret;
  private Map<String,String> nodeSelector;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SearchSpec instance) {
    instance = (instance != null ? instance : new SearchSpec());
    if (instance != null) {
          this.withAvailabilityConfig(instance.getAvailabilityConfig());
          this.withDbConfig(instance.getDbConfig());
          this.withDbStorage(instance.getDbStorage());
          this.withDeployments(instance.getDeployments());
          this.withExternalDBInstance(instance.getExternalDBInstance());
          this.withImagePullPolicy(instance.getImagePullPolicy());
          this.withImagePullSecret(instance.getImagePullSecret());
          this.withNodeSelector(instance.getNodeSelector());
          this.withTolerations(instance.getTolerations());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAvailabilityConfig() {
    return this.availabilityConfig;
  }
  
  public A withAvailabilityConfig(String availabilityConfig) {
    this.availabilityConfig = availabilityConfig;
    return (A) this;
  }
  
  public boolean hasAvailabilityConfig() {
    return this.availabilityConfig != null;
  }
  
  public String getDbConfig() {
    return this.dbConfig;
  }
  
  public A withDbConfig(String dbConfig) {
    this.dbConfig = dbConfig;
    return (A) this;
  }
  
  public boolean hasDbConfig() {
    return this.dbConfig != null;
  }
  
  public StorageSpec buildDbStorage() {
    return this.dbStorage != null ? this.dbStorage.build() : null;
  }
  
  public A withDbStorage(StorageSpec dbStorage) {
    this._visitables.remove("dbStorage");
    if (dbStorage != null) {
        this.dbStorage = new StorageSpecBuilder(dbStorage);
        this._visitables.get("dbStorage").add(this.dbStorage);
    } else {
        this.dbStorage = null;
        this._visitables.get("dbStorage").remove(this.dbStorage);
    }
    return (A) this;
  }
  
  public boolean hasDbStorage() {
    return this.dbStorage != null;
  }
  
  public DbStorageNested<A> withNewDbStorage() {
    return new DbStorageNested(null);
  }
  
  public DbStorageNested<A> withNewDbStorageLike(StorageSpec item) {
    return new DbStorageNested(item);
  }
  
  public DbStorageNested<A> editDbStorage() {
    return withNewDbStorageLike(java.util.Optional.ofNullable(buildDbStorage()).orElse(null));
  }
  
  public DbStorageNested<A> editOrNewDbStorage() {
    return withNewDbStorageLike(java.util.Optional.ofNullable(buildDbStorage()).orElse(new StorageSpecBuilder().build()));
  }
  
  public DbStorageNested<A> editOrNewDbStorageLike(StorageSpec item) {
    return withNewDbStorageLike(java.util.Optional.ofNullable(buildDbStorage()).orElse(item));
  }
  
  public SearchDeployments buildDeployments() {
    return this.deployments != null ? this.deployments.build() : null;
  }
  
  public A withDeployments(SearchDeployments deployments) {
    this._visitables.remove("deployments");
    if (deployments != null) {
        this.deployments = new SearchDeploymentsBuilder(deployments);
        this._visitables.get("deployments").add(this.deployments);
    } else {
        this.deployments = null;
        this._visitables.get("deployments").remove(this.deployments);
    }
    return (A) this;
  }
  
  public boolean hasDeployments() {
    return this.deployments != null;
  }
  
  public DeploymentsNested<A> withNewDeployments() {
    return new DeploymentsNested(null);
  }
  
  public DeploymentsNested<A> withNewDeploymentsLike(SearchDeployments item) {
    return new DeploymentsNested(item);
  }
  
  public DeploymentsNested<A> editDeployments() {
    return withNewDeploymentsLike(java.util.Optional.ofNullable(buildDeployments()).orElse(null));
  }
  
  public DeploymentsNested<A> editOrNewDeployments() {
    return withNewDeploymentsLike(java.util.Optional.ofNullable(buildDeployments()).orElse(new SearchDeploymentsBuilder().build()));
  }
  
  public DeploymentsNested<A> editOrNewDeploymentsLike(SearchDeployments item) {
    return withNewDeploymentsLike(java.util.Optional.ofNullable(buildDeployments()).orElse(item));
  }
  
  public String getExternalDBInstance() {
    return this.externalDBInstance;
  }
  
  public A withExternalDBInstance(String externalDBInstance) {
    this.externalDBInstance = externalDBInstance;
    return (A) this;
  }
  
  public boolean hasExternalDBInstance() {
    return this.externalDBInstance != null;
  }
  
  public String getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  
  public A withImagePullPolicy(String imagePullPolicy) {
    this.imagePullPolicy = imagePullPolicy;
    return (A) this;
  }
  
  public boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  
  public String getImagePullSecret() {
    return this.imagePullSecret;
  }
  
  public A withImagePullSecret(String imagePullSecret) {
    this.imagePullSecret = imagePullSecret;
    return (A) this;
  }
  
  public boolean hasImagePullSecret() {
    return this.imagePullSecret != null;
  }
  
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) {
      this.nodeSelector = null;
    } else {
      this.nodeSelector = new LinkedHashMap(nodeSelector);
    }
    return (A) this;
  }
  
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  
  public A removeAllFromTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
      for (Toleration item : tolerations) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
      for (Toleration item : tolerations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {
        this.tolerations = new ArrayList();
        for (Toleration item : tolerations) {
          this.addToTolerations(item);
        }
    } else {
      this.tolerations = null;
    }
    return (A) this;
  }
  
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {
        this.tolerations.clear();
        _visitables.remove("tolerations");
    }
    if (tolerations != null) {
      for (Toleration item : tolerations) {
        this.addToTolerations(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTolerations() {
    return this.tolerations != null && !this.tolerations.isEmpty();
  }
  
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SearchSpecFluent that = (SearchSpecFluent) o;
    if (!java.util.Objects.equals(availabilityConfig, that.availabilityConfig)) return false;
    if (!java.util.Objects.equals(dbConfig, that.dbConfig)) return false;
    if (!java.util.Objects.equals(dbStorage, that.dbStorage)) return false;
    if (!java.util.Objects.equals(deployments, that.deployments)) return false;
    if (!java.util.Objects.equals(externalDBInstance, that.externalDBInstance)) return false;
    if (!java.util.Objects.equals(imagePullPolicy, that.imagePullPolicy)) return false;
    if (!java.util.Objects.equals(imagePullSecret, that.imagePullSecret)) return false;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;
    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(availabilityConfig,  dbConfig,  dbStorage,  deployments,  externalDBInstance,  imagePullPolicy,  imagePullSecret,  nodeSelector,  tolerations,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availabilityConfig != null) { sb.append("availabilityConfig:"); sb.append(availabilityConfig + ","); }
    if (dbConfig != null) { sb.append("dbConfig:"); sb.append(dbConfig + ","); }
    if (dbStorage != null) { sb.append("dbStorage:"); sb.append(dbStorage + ","); }
    if (deployments != null) { sb.append("deployments:"); sb.append(deployments + ","); }
    if (externalDBInstance != null) { sb.append("externalDBInstance:"); sb.append(externalDBInstance + ","); }
    if (imagePullPolicy != null) { sb.append("imagePullPolicy:"); sb.append(imagePullPolicy + ","); }
    if (imagePullSecret != null) { sb.append("imagePullSecret:"); sb.append(imagePullSecret + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DbStorageNested<N> extends StorageSpecFluent<DbStorageNested<N>> implements Nested<N>{
    DbStorageNested(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageSpecBuilder builder;
    
    public N and() {
      return (N) SearchSpecFluent.this.withDbStorage(builder.build());
    }
    
    public N endDbStorage() {
      return and();
    }
    
  
  }
  public class DeploymentsNested<N> extends SearchDeploymentsFluent<DeploymentsNested<N>> implements Nested<N>{
    DeploymentsNested(SearchDeployments item) {
      this.builder = new SearchDeploymentsBuilder(this, item);
    }
    SearchDeploymentsBuilder builder;
    
    public N and() {
      return (N) SearchSpecFluent.this.withDeployments(builder.build());
    }
    
    public N endDeployments() {
      return and();
    }
    
  
  }

}