/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.AddOnPlacementScoreItem;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.AddOnPlacementScoreItemBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.AddOnPlacementScoreItemFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.AddOnPlacementScoreStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AddOnPlacementScoreStatusFluent<A extends AddOnPlacementScoreStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<AddOnPlacementScoreItemBuilder> scores = new ArrayList();
    private String validUntil;
    private Map<String, Object> additionalProperties;

    public AddOnPlacementScoreStatusFluent() {
    }

    public AddOnPlacementScoreStatusFluent(AddOnPlacementScoreStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AddOnPlacementScoreStatus instance) {
        AddOnPlacementScoreStatus addOnPlacementScoreStatus = instance = instance != null ? instance : new AddOnPlacementScoreStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withScores(instance.getScores());
            this.withValidUntil(instance.getValidUntil());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToScores(int index, AddOnPlacementScoreItem item) {
        if (this.scores == null) {
            this.scores = new ArrayList();
        }
        AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);
        if (index < 0 || index >= this.scores.size()) {
            this._visitables.get((Object)"scores").add(builder);
            this.scores.add(builder);
        } else {
            this._visitables.get((Object)"scores").add(index, builder);
            this.scores.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToScores(int index, AddOnPlacementScoreItem item) {
        if (this.scores == null) {
            this.scores = new ArrayList();
        }
        AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);
        if (index < 0 || index >= this.scores.size()) {
            this._visitables.get((Object)"scores").add(builder);
            this.scores.add(builder);
        } else {
            this._visitables.get((Object)"scores").set(index, builder);
            this.scores.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToScores(AddOnPlacementScoreItem ... items) {
        if (this.scores == null) {
            this.scores = new ArrayList();
        }
        for (AddOnPlacementScoreItem item : items) {
            AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);
            this._visitables.get((Object)"scores").add(builder);
            this.scores.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToScores(Collection<AddOnPlacementScoreItem> items) {
        if (this.scores == null) {
            this.scores = new ArrayList();
        }
        for (AddOnPlacementScoreItem item : items) {
            AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);
            this._visitables.get((Object)"scores").add(builder);
            this.scores.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromScores(AddOnPlacementScoreItem ... items) {
        if (this.scores == null) {
            return (A)((Object)this);
        }
        for (AddOnPlacementScoreItem item : items) {
            AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);
            this._visitables.get((Object)"scores").remove((Object)builder);
            this.scores.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromScores(Collection<AddOnPlacementScoreItem> items) {
        if (this.scores == null) {
            return (A)((Object)this);
        }
        for (AddOnPlacementScoreItem item : items) {
            AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);
            this._visitables.get((Object)"scores").remove((Object)builder);
            this.scores.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromScores(Predicate<AddOnPlacementScoreItemBuilder> predicate) {
        if (this.scores == null) {
            return (A)((Object)this);
        }
        Iterator<AddOnPlacementScoreItemBuilder> each = this.scores.iterator();
        List visitables = this._visitables.get((Object)"scores");
        while (each.hasNext()) {
            AddOnPlacementScoreItemBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AddOnPlacementScoreItem> buildScores() {
        return this.scores != null ? AddOnPlacementScoreStatusFluent.build(this.scores) : null;
    }

    public AddOnPlacementScoreItem buildScore(int index) {
        return this.scores.get(index).build();
    }

    public AddOnPlacementScoreItem buildFirstScore() {
        return this.scores.get(0).build();
    }

    public AddOnPlacementScoreItem buildLastScore() {
        return this.scores.get(this.scores.size() - 1).build();
    }

    public AddOnPlacementScoreItem buildMatchingScore(Predicate<AddOnPlacementScoreItemBuilder> predicate) {
        for (AddOnPlacementScoreItemBuilder item : this.scores) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingScore(Predicate<AddOnPlacementScoreItemBuilder> predicate) {
        for (AddOnPlacementScoreItemBuilder item : this.scores) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withScores(List<AddOnPlacementScoreItem> scores) {
        if (this.scores != null) {
            this._visitables.get((Object)"scores").clear();
        }
        if (scores != null) {
            this.scores = new ArrayList();
            for (AddOnPlacementScoreItem item : scores) {
                this.addToScores(item);
            }
        } else {
            this.scores = null;
        }
        return (A)((Object)this);
    }

    public A withScores(AddOnPlacementScoreItem ... scores) {
        if (this.scores != null) {
            this.scores.clear();
            this._visitables.remove((Object)"scores");
        }
        if (scores != null) {
            for (AddOnPlacementScoreItem item : scores) {
                this.addToScores(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasScores() {
        return this.scores != null && !this.scores.isEmpty();
    }

    public A addNewScore(String name, Integer value) {
        return this.addToScores(new AddOnPlacementScoreItem(name, value));
    }

    public ScoresNested<A> addNewScore() {
        return new ScoresNested(-1, null);
    }

    public ScoresNested<A> addNewScoreLike(AddOnPlacementScoreItem item) {
        return new ScoresNested(-1, item);
    }

    public ScoresNested<A> setNewScoreLike(int index, AddOnPlacementScoreItem item) {
        return new ScoresNested(index, item);
    }

    public ScoresNested<A> editScore(int index) {
        if (this.scores.size() <= index) {
            throw new RuntimeException("Can't edit scores. Index exceeds size.");
        }
        return this.setNewScoreLike(index, this.buildScore(index));
    }

    public ScoresNested<A> editFirstScore() {
        if (this.scores.size() == 0) {
            throw new RuntimeException("Can't edit first scores. The list is empty.");
        }
        return this.setNewScoreLike(0, this.buildScore(0));
    }

    public ScoresNested<A> editLastScore() {
        int index = this.scores.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last scores. The list is empty.");
        }
        return this.setNewScoreLike(index, this.buildScore(index));
    }

    public ScoresNested<A> editMatchingScore(Predicate<AddOnPlacementScoreItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.scores.size(); ++i) {
            if (!predicate.test(this.scores.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching scores. No match found.");
        }
        return this.setNewScoreLike(index, this.buildScore(index));
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public A withValidUntil(String validUntil) {
        this.validUntil = validUntil;
        return (A)((Object)this);
    }

    public boolean hasValidUntil() {
        return this.validUntil != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddOnPlacementScoreStatusFluent that = (AddOnPlacementScoreStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.scores, that.scores)) {
            return false;
        }
        if (!Objects.equals(this.validUntil, that.validUntil)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.scores, this.validUntil, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.scores != null && !this.scores.isEmpty()) {
            sb.append("scores:");
            sb.append(this.scores + ",");
        }
        if (this.validUntil != null) {
            sb.append("validUntil:");
            sb.append(this.validUntil + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScoresNested<N>
    extends AddOnPlacementScoreItemFluent<ScoresNested<N>>
    implements Nested<N> {
        AddOnPlacementScoreItemBuilder builder;
        int index;

        ScoresNested(int index, AddOnPlacementScoreItem item) {
            this.index = index;
            this.builder = new AddOnPlacementScoreItemBuilder(this, item);
        }

        public N and() {
            return (N)AddOnPlacementScoreStatusFluent.this.setToScores(this.index, this.builder.build());
        }

        public N endScore() {
            return this.and();
        }
    }
}

