/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.observability.v1beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.observability.v1beta2.StorageConfig;
import io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorage;
import io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorageBuilder;
import io.fabric8.openclustermanagement.api.model.shared.PreConfiguredStorageFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StorageConfigFluent<A extends StorageConfigFluent<A>>
extends BaseFluent<A> {
    private String alertmanagerStorageSize;
    private String compactStorageSize;
    private PreConfiguredStorageBuilder metricObjectStorage;
    private String receiveStorageSize;
    private String ruleStorageSize;
    private String storageClass;
    private String storeStorageSize;
    private ArrayList<PreConfiguredStorageBuilder> writeStorage = new ArrayList();
    private Map<String, Object> additionalProperties;

    public StorageConfigFluent() {
    }

    public StorageConfigFluent(StorageConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StorageConfig instance) {
        StorageConfig storageConfig = instance = instance != null ? instance : new StorageConfig();
        if (instance != null) {
            this.withAlertmanagerStorageSize(instance.getAlertmanagerStorageSize());
            this.withCompactStorageSize(instance.getCompactStorageSize());
            this.withMetricObjectStorage(instance.getMetricObjectStorage());
            this.withReceiveStorageSize(instance.getReceiveStorageSize());
            this.withRuleStorageSize(instance.getRuleStorageSize());
            this.withStorageClass(instance.getStorageClass());
            this.withStoreStorageSize(instance.getStoreStorageSize());
            this.withWriteStorage(instance.getWriteStorage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAlertmanagerStorageSize() {
        return this.alertmanagerStorageSize;
    }

    public A withAlertmanagerStorageSize(String alertmanagerStorageSize) {
        this.alertmanagerStorageSize = alertmanagerStorageSize;
        return (A)((Object)this);
    }

    public boolean hasAlertmanagerStorageSize() {
        return this.alertmanagerStorageSize != null;
    }

    public String getCompactStorageSize() {
        return this.compactStorageSize;
    }

    public A withCompactStorageSize(String compactStorageSize) {
        this.compactStorageSize = compactStorageSize;
        return (A)((Object)this);
    }

    public boolean hasCompactStorageSize() {
        return this.compactStorageSize != null;
    }

    public PreConfiguredStorage buildMetricObjectStorage() {
        return this.metricObjectStorage != null ? this.metricObjectStorage.build() : null;
    }

    public A withMetricObjectStorage(PreConfiguredStorage metricObjectStorage) {
        this._visitables.remove((Object)"metricObjectStorage");
        if (metricObjectStorage != null) {
            this.metricObjectStorage = new PreConfiguredStorageBuilder(metricObjectStorage);
            this._visitables.get((Object)"metricObjectStorage").add(this.metricObjectStorage);
        } else {
            this.metricObjectStorage = null;
            this._visitables.get((Object)"metricObjectStorage").remove((Object)this.metricObjectStorage);
        }
        return (A)((Object)this);
    }

    public boolean hasMetricObjectStorage() {
        return this.metricObjectStorage != null;
    }

    public A withNewMetricObjectStorage(String key, String name, Boolean serviceAccountProjection, String tlsSecretMountPath, String tlsSecretName) {
        return this.withMetricObjectStorage(new PreConfiguredStorage(key, name, serviceAccountProjection, tlsSecretMountPath, tlsSecretName));
    }

    public MetricObjectStorageNested<A> withNewMetricObjectStorage() {
        return new MetricObjectStorageNested(null);
    }

    public MetricObjectStorageNested<A> withNewMetricObjectStorageLike(PreConfiguredStorage item) {
        return new MetricObjectStorageNested(item);
    }

    public MetricObjectStorageNested<A> editMetricObjectStorage() {
        return this.withNewMetricObjectStorageLike(Optional.ofNullable(this.buildMetricObjectStorage()).orElse(null));
    }

    public MetricObjectStorageNested<A> editOrNewMetricObjectStorage() {
        return this.withNewMetricObjectStorageLike(Optional.ofNullable(this.buildMetricObjectStorage()).orElse(new PreConfiguredStorageBuilder().build()));
    }

    public MetricObjectStorageNested<A> editOrNewMetricObjectStorageLike(PreConfiguredStorage item) {
        return this.withNewMetricObjectStorageLike(Optional.ofNullable(this.buildMetricObjectStorage()).orElse(item));
    }

    public String getReceiveStorageSize() {
        return this.receiveStorageSize;
    }

    public A withReceiveStorageSize(String receiveStorageSize) {
        this.receiveStorageSize = receiveStorageSize;
        return (A)((Object)this);
    }

    public boolean hasReceiveStorageSize() {
        return this.receiveStorageSize != null;
    }

    public String getRuleStorageSize() {
        return this.ruleStorageSize;
    }

    public A withRuleStorageSize(String ruleStorageSize) {
        this.ruleStorageSize = ruleStorageSize;
        return (A)((Object)this);
    }

    public boolean hasRuleStorageSize() {
        return this.ruleStorageSize != null;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public A withStorageClass(String storageClass) {
        this.storageClass = storageClass;
        return (A)((Object)this);
    }

    public boolean hasStorageClass() {
        return this.storageClass != null;
    }

    public String getStoreStorageSize() {
        return this.storeStorageSize;
    }

    public A withStoreStorageSize(String storeStorageSize) {
        this.storeStorageSize = storeStorageSize;
        return (A)((Object)this);
    }

    public boolean hasStoreStorageSize() {
        return this.storeStorageSize != null;
    }

    public A addToWriteStorage(int index, PreConfiguredStorage item) {
        if (this.writeStorage == null) {
            this.writeStorage = new ArrayList();
        }
        PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);
        if (index < 0 || index >= this.writeStorage.size()) {
            this._visitables.get((Object)"writeStorage").add(builder);
            this.writeStorage.add(builder);
        } else {
            this._visitables.get((Object)"writeStorage").add(index, builder);
            this.writeStorage.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToWriteStorage(int index, PreConfiguredStorage item) {
        if (this.writeStorage == null) {
            this.writeStorage = new ArrayList();
        }
        PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);
        if (index < 0 || index >= this.writeStorage.size()) {
            this._visitables.get((Object)"writeStorage").add(builder);
            this.writeStorage.add(builder);
        } else {
            this._visitables.get((Object)"writeStorage").set(index, builder);
            this.writeStorage.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToWriteStorage(PreConfiguredStorage ... items) {
        if (this.writeStorage == null) {
            this.writeStorage = new ArrayList();
        }
        for (PreConfiguredStorage item : items) {
            PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);
            this._visitables.get((Object)"writeStorage").add(builder);
            this.writeStorage.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToWriteStorage(Collection<PreConfiguredStorage> items) {
        if (this.writeStorage == null) {
            this.writeStorage = new ArrayList();
        }
        for (PreConfiguredStorage item : items) {
            PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);
            this._visitables.get((Object)"writeStorage").add(builder);
            this.writeStorage.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromWriteStorage(PreConfiguredStorage ... items) {
        if (this.writeStorage == null) {
            return (A)((Object)this);
        }
        for (PreConfiguredStorage item : items) {
            PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);
            this._visitables.get((Object)"writeStorage").remove((Object)builder);
            this.writeStorage.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWriteStorage(Collection<PreConfiguredStorage> items) {
        if (this.writeStorage == null) {
            return (A)((Object)this);
        }
        for (PreConfiguredStorage item : items) {
            PreConfiguredStorageBuilder builder = new PreConfiguredStorageBuilder(item);
            this._visitables.get((Object)"writeStorage").remove((Object)builder);
            this.writeStorage.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromWriteStorage(Predicate<PreConfiguredStorageBuilder> predicate) {
        if (this.writeStorage == null) {
            return (A)((Object)this);
        }
        Iterator<PreConfiguredStorageBuilder> each = this.writeStorage.iterator();
        List visitables = this._visitables.get((Object)"writeStorage");
        while (each.hasNext()) {
            PreConfiguredStorageBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PreConfiguredStorage> buildWriteStorage() {
        return this.writeStorage != null ? StorageConfigFluent.build(this.writeStorage) : null;
    }

    public PreConfiguredStorage buildWriteStorage(int index) {
        return this.writeStorage.get(index).build();
    }

    public PreConfiguredStorage buildFirstWriteStorage() {
        return this.writeStorage.get(0).build();
    }

    public PreConfiguredStorage buildLastWriteStorage() {
        return this.writeStorage.get(this.writeStorage.size() - 1).build();
    }

    public PreConfiguredStorage buildMatchingWriteStorage(Predicate<PreConfiguredStorageBuilder> predicate) {
        for (PreConfiguredStorageBuilder item : this.writeStorage) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingWriteStorage(Predicate<PreConfiguredStorageBuilder> predicate) {
        for (PreConfiguredStorageBuilder item : this.writeStorage) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWriteStorage(List<PreConfiguredStorage> writeStorage) {
        if (this.writeStorage != null) {
            this._visitables.get((Object)"writeStorage").clear();
        }
        if (writeStorage != null) {
            this.writeStorage = new ArrayList();
            for (PreConfiguredStorage item : writeStorage) {
                this.addToWriteStorage(item);
            }
        } else {
            this.writeStorage = null;
        }
        return (A)((Object)this);
    }

    public A withWriteStorage(PreConfiguredStorage ... writeStorage) {
        if (this.writeStorage != null) {
            this.writeStorage.clear();
            this._visitables.remove((Object)"writeStorage");
        }
        if (writeStorage != null) {
            for (PreConfiguredStorage item : writeStorage) {
                this.addToWriteStorage(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasWriteStorage() {
        return this.writeStorage != null && !this.writeStorage.isEmpty();
    }

    public A addNewWriteStorage(String key, String name, Boolean serviceAccountProjection, String tlsSecretMountPath, String tlsSecretName) {
        return this.addToWriteStorage(new PreConfiguredStorage(key, name, serviceAccountProjection, tlsSecretMountPath, tlsSecretName));
    }

    public WriteStorageNested<A> addNewWriteStorage() {
        return new WriteStorageNested(-1, null);
    }

    public WriteStorageNested<A> addNewWriteStorageLike(PreConfiguredStorage item) {
        return new WriteStorageNested(-1, item);
    }

    public WriteStorageNested<A> setNewWriteStorageLike(int index, PreConfiguredStorage item) {
        return new WriteStorageNested(index, item);
    }

    public WriteStorageNested<A> editWriteStorage(int index) {
        if (this.writeStorage.size() <= index) {
            throw new RuntimeException("Can't edit writeStorage. Index exceeds size.");
        }
        return this.setNewWriteStorageLike(index, this.buildWriteStorage(index));
    }

    public WriteStorageNested<A> editFirstWriteStorage() {
        if (this.writeStorage.size() == 0) {
            throw new RuntimeException("Can't edit first writeStorage. The list is empty.");
        }
        return this.setNewWriteStorageLike(0, this.buildWriteStorage(0));
    }

    public WriteStorageNested<A> editLastWriteStorage() {
        int index = this.writeStorage.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last writeStorage. The list is empty.");
        }
        return this.setNewWriteStorageLike(index, this.buildWriteStorage(index));
    }

    public WriteStorageNested<A> editMatchingWriteStorage(Predicate<PreConfiguredStorageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.writeStorage.size(); ++i) {
            if (!predicate.test(this.writeStorage.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching writeStorage. No match found.");
        }
        return this.setNewWriteStorageLike(index, this.buildWriteStorage(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageConfigFluent that = (StorageConfigFluent)((Object)o);
        if (!Objects.equals(this.alertmanagerStorageSize, that.alertmanagerStorageSize)) {
            return false;
        }
        if (!Objects.equals(this.compactStorageSize, that.compactStorageSize)) {
            return false;
        }
        if (!Objects.equals((Object)this.metricObjectStorage, (Object)that.metricObjectStorage)) {
            return false;
        }
        if (!Objects.equals(this.receiveStorageSize, that.receiveStorageSize)) {
            return false;
        }
        if (!Objects.equals(this.ruleStorageSize, that.ruleStorageSize)) {
            return false;
        }
        if (!Objects.equals(this.storageClass, that.storageClass)) {
            return false;
        }
        if (!Objects.equals(this.storeStorageSize, that.storeStorageSize)) {
            return false;
        }
        if (!Objects.equals(this.writeStorage, that.writeStorage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alertmanagerStorageSize, this.compactStorageSize, this.metricObjectStorage, this.receiveStorageSize, this.ruleStorageSize, this.storageClass, this.storeStorageSize, this.writeStorage, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alertmanagerStorageSize != null) {
            sb.append("alertmanagerStorageSize:");
            sb.append(this.alertmanagerStorageSize + ",");
        }
        if (this.compactStorageSize != null) {
            sb.append("compactStorageSize:");
            sb.append(this.compactStorageSize + ",");
        }
        if (this.metricObjectStorage != null) {
            sb.append("metricObjectStorage:");
            sb.append(this.metricObjectStorage + ",");
        }
        if (this.receiveStorageSize != null) {
            sb.append("receiveStorageSize:");
            sb.append(this.receiveStorageSize + ",");
        }
        if (this.ruleStorageSize != null) {
            sb.append("ruleStorageSize:");
            sb.append(this.ruleStorageSize + ",");
        }
        if (this.storageClass != null) {
            sb.append("storageClass:");
            sb.append(this.storageClass + ",");
        }
        if (this.storeStorageSize != null) {
            sb.append("storeStorageSize:");
            sb.append(this.storeStorageSize + ",");
        }
        if (this.writeStorage != null && !this.writeStorage.isEmpty()) {
            sb.append("writeStorage:");
            sb.append(this.writeStorage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WriteStorageNested<N>
    extends PreConfiguredStorageFluent<WriteStorageNested<N>>
    implements Nested<N> {
        PreConfiguredStorageBuilder builder;
        int index;

        WriteStorageNested(int index, PreConfiguredStorage item) {
            this.index = index;
            this.builder = new PreConfiguredStorageBuilder(this, item);
        }

        public N and() {
            return (N)StorageConfigFluent.this.setToWriteStorage(this.index, this.builder.build());
        }

        public N endWriteStorage() {
            return this.and();
        }
    }

    public class MetricObjectStorageNested<N>
    extends PreConfiguredStorageFluent<MetricObjectStorageNested<N>>
    implements Nested<N> {
        PreConfiguredStorageBuilder builder;

        MetricObjectStorageNested(PreConfiguredStorage item) {
            this.builder = new PreConfiguredStorageBuilder(this, item);
        }

        public N and() {
            return (N)StorageConfigFluent.this.withMetricObjectStorage(this.builder.build());
        }

        public N endMetricObjectStorage() {
            return this.and();
        }
    }
}

