/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1.BindingOverrides;
import io.fabric8.openclustermanagement.api.model.policy.v1.BindingOverridesBuilder;
import io.fabric8.openclustermanagement.api.model.policy.v1.BindingOverridesFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1.PlacementBinding;
import io.fabric8.openclustermanagement.api.model.policy.v1.PlacementBindingStatus;
import io.fabric8.openclustermanagement.api.model.policy.v1.PlacementBindingStatusBuilder;
import io.fabric8.openclustermanagement.api.model.policy.v1.PlacementBindingStatusFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1.PlacementSubject;
import io.fabric8.openclustermanagement.api.model.policy.v1.PlacementSubjectBuilder;
import io.fabric8.openclustermanagement.api.model.policy.v1.PlacementSubjectFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1.Subject;
import io.fabric8.openclustermanagement.api.model.policy.v1.SubjectBuilder;
import io.fabric8.openclustermanagement.api.model.policy.v1.SubjectFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlacementBindingFluent<A extends PlacementBindingFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private BindingOverridesBuilder bindingOverrides;
    private String kind;
    private ObjectMetaBuilder metadata;
    private PlacementSubjectBuilder placementRef;
    private PlacementBindingStatusBuilder status;
    private String subFilter;
    private ArrayList<SubjectBuilder> subjects = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PlacementBindingFluent() {
    }

    public PlacementBindingFluent(PlacementBinding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PlacementBinding instance) {
        PlacementBinding placementBinding = instance = instance != null ? instance : new PlacementBinding();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withBindingOverrides(instance.getBindingOverrides());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withPlacementRef(instance.getPlacementRef());
            this.withStatus(instance.getStatus());
            this.withSubFilter(instance.getSubFilter());
            this.withSubjects(instance.getSubjects());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public BindingOverrides buildBindingOverrides() {
        return this.bindingOverrides != null ? this.bindingOverrides.build() : null;
    }

    public A withBindingOverrides(BindingOverrides bindingOverrides) {
        this._visitables.remove((Object)"bindingOverrides");
        if (bindingOverrides != null) {
            this.bindingOverrides = new BindingOverridesBuilder(bindingOverrides);
            this._visitables.get((Object)"bindingOverrides").add(this.bindingOverrides);
        } else {
            this.bindingOverrides = null;
            this._visitables.get((Object)"bindingOverrides").remove((Object)this.bindingOverrides);
        }
        return (A)((Object)this);
    }

    public boolean hasBindingOverrides() {
        return this.bindingOverrides != null;
    }

    public A withNewBindingOverrides(String remediationAction) {
        return this.withBindingOverrides(new BindingOverrides(remediationAction));
    }

    public BindingOverridesNested<A> withNewBindingOverrides() {
        return new BindingOverridesNested(null);
    }

    public BindingOverridesNested<A> withNewBindingOverridesLike(BindingOverrides item) {
        return new BindingOverridesNested(item);
    }

    public BindingOverridesNested<A> editBindingOverrides() {
        return this.withNewBindingOverridesLike(Optional.ofNullable(this.buildBindingOverrides()).orElse(null));
    }

    public BindingOverridesNested<A> editOrNewBindingOverrides() {
        return this.withNewBindingOverridesLike(Optional.ofNullable(this.buildBindingOverrides()).orElse(new BindingOverridesBuilder().build()));
    }

    public BindingOverridesNested<A> editOrNewBindingOverridesLike(BindingOverrides item) {
        return this.withNewBindingOverridesLike(Optional.ofNullable(this.buildBindingOverrides()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public PlacementSubject buildPlacementRef() {
        return this.placementRef != null ? this.placementRef.build() : null;
    }

    public A withPlacementRef(PlacementSubject placementRef) {
        this._visitables.remove((Object)"placementRef");
        if (placementRef != null) {
            this.placementRef = new PlacementSubjectBuilder(placementRef);
            this._visitables.get((Object)"placementRef").add(this.placementRef);
        } else {
            this.placementRef = null;
            this._visitables.get((Object)"placementRef").remove((Object)this.placementRef);
        }
        return (A)((Object)this);
    }

    public boolean hasPlacementRef() {
        return this.placementRef != null;
    }

    public A withNewPlacementRef(String apiGroup, String kind, String name) {
        return this.withPlacementRef(new PlacementSubject(apiGroup, kind, name));
    }

    public PlacementRefNested<A> withNewPlacementRef() {
        return new PlacementRefNested(null);
    }

    public PlacementRefNested<A> withNewPlacementRefLike(PlacementSubject item) {
        return new PlacementRefNested(item);
    }

    public PlacementRefNested<A> editPlacementRef() {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(null));
    }

    public PlacementRefNested<A> editOrNewPlacementRef() {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(new PlacementSubjectBuilder().build()));
    }

    public PlacementRefNested<A> editOrNewPlacementRefLike(PlacementSubject item) {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(item));
    }

    public PlacementBindingStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(PlacementBindingStatus status) {
        this._visitables.remove((Object)"status");
        if (status != null) {
            this.status = new PlacementBindingStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(PlacementBindingStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new PlacementBindingStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(PlacementBindingStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public String getSubFilter() {
        return this.subFilter;
    }

    public A withSubFilter(String subFilter) {
        this.subFilter = subFilter;
        return (A)((Object)this);
    }

    public boolean hasSubFilter() {
        return this.subFilter != null;
    }

    public A addToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get((Object)"subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get((Object)"subjects").add(index, builder);
            this.subjects.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get((Object)"subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get((Object)"subjects").set(index, builder);
            this.subjects.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get((Object)"subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get((Object)"subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSubjects(Subject ... items) {
        if (this.subjects == null) {
            return (A)((Object)this);
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get((Object)"subjects").remove((Object)builder);
            this.subjects.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            return (A)((Object)this);
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get((Object)"subjects").remove((Object)builder);
            this.subjects.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)((Object)this);
        }
        Iterator<SubjectBuilder> each = this.subjects.iterator();
        List visitables = this._visitables.get((Object)"subjects");
        while (each.hasNext()) {
            SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Subject> buildSubjects() {
        return this.subjects != null ? PlacementBindingFluent.build(this.subjects) : null;
    }

    public Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    public Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    public Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjects(List<Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get((Object)"subjects").clear();
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)((Object)this);
    }

    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove((Object)"subjects");
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    public A addNewSubject(String apiGroup, String kind, String name) {
        return this.addToSubjects(new Subject(apiGroup, kind, name));
    }

    public SubjectsNested<A> addNewSubject() {
        return new SubjectsNested(-1, null);
    }

    public SubjectsNested<A> addNewSubjectLike(Subject item) {
        return new SubjectsNested(-1, item);
    }

    public SubjectsNested<A> setNewSubjectLike(int index, Subject item) {
        return new SubjectsNested(index, item);
    }

    public SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    public SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlacementBindingFluent that = (PlacementBindingFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals((Object)this.bindingOverrides, (Object)that.bindingOverrides)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.placementRef, (Object)that.placementRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.status, (Object)that.status)) {
            return false;
        }
        if (!Objects.equals(this.subFilter, that.subFilter)) {
            return false;
        }
        if (!Objects.equals(this.subjects, that.subjects)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.bindingOverrides, this.kind, this.metadata, this.placementRef, this.status, this.subFilter, this.subjects, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.bindingOverrides != null) {
            sb.append("bindingOverrides:");
            sb.append(this.bindingOverrides + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.placementRef != null) {
            sb.append("placementRef:");
            sb.append(this.placementRef + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.subFilter != null) {
            sb.append("subFilter:");
            sb.append(this.subFilter + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubjectsNested<N>
    extends SubjectFluent<SubjectsNested<N>>
    implements Nested<N> {
        SubjectBuilder builder;
        int index;

        SubjectsNested(int index, Subject item) {
            this.index = index;
            this.builder = new SubjectBuilder(this, item);
        }

        public N and() {
            return (N)PlacementBindingFluent.this.setToSubjects(this.index, this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends PlacementBindingStatusFluent<StatusNested<N>>
    implements Nested<N> {
        PlacementBindingStatusBuilder builder;

        StatusNested(PlacementBindingStatus item) {
            this.builder = new PlacementBindingStatusBuilder(this, item);
        }

        public N and() {
            return (N)PlacementBindingFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class PlacementRefNested<N>
    extends PlacementSubjectFluent<PlacementRefNested<N>>
    implements Nested<N> {
        PlacementSubjectBuilder builder;

        PlacementRefNested(PlacementSubject item) {
            this.builder = new PlacementSubjectBuilder(this, item);
        }

        public N and() {
            return (N)PlacementBindingFluent.this.withPlacementRef(this.builder.build());
        }

        public N endPlacementRef() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)PlacementBindingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class BindingOverridesNested<N>
    extends BindingOverridesFluent<BindingOverridesNested<N>>
    implements Nested<N> {
        BindingOverridesBuilder builder;

        BindingOverridesNested(BindingOverrides item) {
            this.builder = new BindingOverridesBuilder(this, item);
        }

        public N and() {
            return (N)PlacementBindingFluent.this.withBindingOverrides(this.builder.build());
        }

        public N endBindingOverrides() {
            return this.and();
        }
    }
}

