/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.PolicySetSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicySetSpecFluent<A extends PolicySetSpecFluent<A>>
extends BaseFluent<A> {
    private String description;
    private List<String> policies = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public PolicySetSpecFluent() {
    }

    public PolicySetSpecFluent(PolicySetSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PolicySetSpec instance) {
        PolicySetSpec policySetSpec = instance = instance != null ? instance : new PolicySetSpec();
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withPolicies(instance.getPolicies());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public A addToPolicies(int index, String item) {
        if (this.policies == null) {
            this.policies = new ArrayList<String>();
        }
        this.policies.add(index, item);
        return (A)((Object)this);
    }

    public A setToPolicies(int index, String item) {
        if (this.policies == null) {
            this.policies = new ArrayList<String>();
        }
        this.policies.set(index, item);
        return (A)((Object)this);
    }

    public A addToPolicies(String ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList<String>();
        }
        for (String item : items) {
            this.policies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPolicies(Collection<String> items) {
        if (this.policies == null) {
            this.policies = new ArrayList<String>();
        }
        for (String item : items) {
            this.policies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicies(String ... items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.policies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPolicies(Collection<String> items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.policies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPolicies() {
        return this.policies;
    }

    public String getPolicy(int index) {
        return this.policies.get(index);
    }

    public String getFirstPolicy() {
        return this.policies.get(0);
    }

    public String getLastPolicy() {
        return this.policies.get(this.policies.size() - 1);
    }

    public String getMatchingPolicy(Predicate<String> predicate) {
        for (String item : this.policies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPolicy(Predicate<String> predicate) {
        for (String item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicies(List<String> policies) {
        if (policies != null) {
            this.policies = new ArrayList<String>();
            for (String item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)((Object)this);
    }

    public A withPolicies(String ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove((Object)"policies");
        }
        if (policies != null) {
            for (String item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicySetSpecFluent that = (PolicySetSpecFluent)((Object)o);
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.policies, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

