/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedComplianceHistory;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedComplianceHistoryBuilder;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedComplianceHistoryFluent;
import io.fabric8.openclustermanagement.api.model.policy.v1beta1.ReplicatedDetailsPerTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ReplicatedDetailsPerTemplateFluent<A extends ReplicatedDetailsPerTemplateFluent<A>>
extends BaseFluent<A> {
    private String compliant;
    private ArrayList<ReplicatedComplianceHistoryBuilder> history = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ReplicatedDetailsPerTemplateFluent() {
    }

    public ReplicatedDetailsPerTemplateFluent(ReplicatedDetailsPerTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ReplicatedDetailsPerTemplate instance) {
        ReplicatedDetailsPerTemplate replicatedDetailsPerTemplate = instance = instance != null ? instance : new ReplicatedDetailsPerTemplate();
        if (instance != null) {
            this.withCompliant(instance.getCompliant());
            this.withHistory(instance.getHistory());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCompliant() {
        return this.compliant;
    }

    public A withCompliant(String compliant) {
        this.compliant = compliant;
        return (A)((Object)this);
    }

    public boolean hasCompliant() {
        return this.compliant != null;
    }

    public A addToHistory(int index, ReplicatedComplianceHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);
        if (index < 0 || index >= this.history.size()) {
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        } else {
            this._visitables.get((Object)"history").add(index, builder);
            this.history.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHistory(int index, ReplicatedComplianceHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);
        if (index < 0 || index >= this.history.size()) {
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        } else {
            this._visitables.get((Object)"history").set(index, builder);
            this.history.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHistory(ReplicatedComplianceHistory ... items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (ReplicatedComplianceHistory item : items) {
            ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHistory(Collection<ReplicatedComplianceHistory> items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (ReplicatedComplianceHistory item : items) {
            ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHistory(ReplicatedComplianceHistory ... items) {
        if (this.history == null) {
            return (A)((Object)this);
        }
        for (ReplicatedComplianceHistory item : items) {
            ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").remove((Object)builder);
            this.history.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHistory(Collection<ReplicatedComplianceHistory> items) {
        if (this.history == null) {
            return (A)((Object)this);
        }
        for (ReplicatedComplianceHistory item : items) {
            ReplicatedComplianceHistoryBuilder builder = new ReplicatedComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").remove((Object)builder);
            this.history.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHistory(Predicate<ReplicatedComplianceHistoryBuilder> predicate) {
        if (this.history == null) {
            return (A)((Object)this);
        }
        Iterator<ReplicatedComplianceHistoryBuilder> each = this.history.iterator();
        List visitables = this._visitables.get((Object)"history");
        while (each.hasNext()) {
            ReplicatedComplianceHistoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ReplicatedComplianceHistory> buildHistory() {
        return this.history != null ? ReplicatedDetailsPerTemplateFluent.build(this.history) : null;
    }

    public ReplicatedComplianceHistory buildHistory(int index) {
        return this.history.get(index).build();
    }

    public ReplicatedComplianceHistory buildFirstHistory() {
        return this.history.get(0).build();
    }

    public ReplicatedComplianceHistory buildLastHistory() {
        return this.history.get(this.history.size() - 1).build();
    }

    public ReplicatedComplianceHistory buildMatchingHistory(Predicate<ReplicatedComplianceHistoryBuilder> predicate) {
        for (ReplicatedComplianceHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHistory(Predicate<ReplicatedComplianceHistoryBuilder> predicate) {
        for (ReplicatedComplianceHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHistory(List<ReplicatedComplianceHistory> history) {
        if (this.history != null) {
            this._visitables.get((Object)"history").clear();
        }
        if (history != null) {
            this.history = new ArrayList();
            for (ReplicatedComplianceHistory item : history) {
                this.addToHistory(item);
            }
        } else {
            this.history = null;
        }
        return (A)((Object)this);
    }

    public A withHistory(ReplicatedComplianceHistory ... history) {
        if (this.history != null) {
            this.history.clear();
            this._visitables.remove((Object)"history");
        }
        if (history != null) {
            for (ReplicatedComplianceHistory item : history) {
                this.addToHistory(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHistory() {
        return this.history != null && !this.history.isEmpty();
    }

    public A addNewHistory(String lastTimestamp, String message) {
        return this.addToHistory(new ReplicatedComplianceHistory(lastTimestamp, message));
    }

    public HistoryNested<A> addNewHistory() {
        return new HistoryNested(-1, null);
    }

    public HistoryNested<A> addNewHistoryLike(ReplicatedComplianceHistory item) {
        return new HistoryNested(-1, item);
    }

    public HistoryNested<A> setNewHistoryLike(int index, ReplicatedComplianceHistory item) {
        return new HistoryNested(index, item);
    }

    public HistoryNested<A> editHistory(int index) {
        if (this.history.size() <= index) {
            throw new RuntimeException("Can't edit history. Index exceeds size.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public HistoryNested<A> editFirstHistory() {
        if (this.history.size() == 0) {
            throw new RuntimeException("Can't edit first history. The list is empty.");
        }
        return this.setNewHistoryLike(0, this.buildHistory(0));
    }

    public HistoryNested<A> editLastHistory() {
        int index = this.history.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last history. The list is empty.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public HistoryNested<A> editMatchingHistory(Predicate<ReplicatedComplianceHistoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.history.size(); ++i) {
            if (!predicate.test(this.history.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching history. No match found.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicatedDetailsPerTemplateFluent that = (ReplicatedDetailsPerTemplateFluent)((Object)o);
        if (!Objects.equals(this.compliant, that.compliant)) {
            return false;
        }
        if (!Objects.equals(this.history, that.history)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compliant, this.history, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compliant != null) {
            sb.append("compliant:");
            sb.append(this.compliant + ",");
        }
        if (this.history != null && !this.history.isEmpty()) {
            sb.append("history:");
            sb.append(this.history + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HistoryNested<N>
    extends ReplicatedComplianceHistoryFluent<HistoryNested<N>>
    implements Nested<N> {
        ReplicatedComplianceHistoryBuilder builder;
        int index;

        HistoryNested(int index, ReplicatedComplianceHistory item) {
            this.index = index;
            this.builder = new ReplicatedComplianceHistoryBuilder(this, item);
        }

        public N and() {
            return (N)ReplicatedDetailsPerTemplateFluent.this.setToHistory(this.index, this.builder.build());
        }

        public N endHistory() {
            return this.and();
        }
    }
}

