/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.search.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.DeploymentConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DeploymentConfigFluent<A extends DeploymentConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> arguments = new ArrayList<String>();
    private ArrayList<EnvVarBuilder> envVar = new ArrayList();
    private String imageOverride;
    private Integer replicaCount;
    private ResourceRequirementsBuilder resources;
    private Map<String, Object> additionalProperties;

    public DeploymentConfigFluent() {
    }

    public DeploymentConfigFluent(DeploymentConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeploymentConfig instance) {
        DeploymentConfig deploymentConfig = instance = instance != null ? instance : new DeploymentConfig();
        if (instance != null) {
            this.withArguments(instance.getArguments());
            this.withEnvVar(instance.getEnvVar());
            this.withImageOverride(instance.getImageOverride());
            this.withReplicaCount(instance.getReplicaCount());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToArguments(int index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(index, item);
        return (A)((Object)this);
    }

    public A setToArguments(int index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.set(index, item);
        return (A)((Object)this);
    }

    public A addToArguments(String ... items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToArguments(Collection<String> items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromArguments(String ... items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.arguments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromArguments(Collection<String> items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.arguments.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String getArgument(int index) {
        return this.arguments.get(index);
    }

    public String getFirstArgument() {
        return this.arguments.get(0);
    }

    public String getLastArgument() {
        return this.arguments.get(this.arguments.size() - 1);
    }

    public String getMatchingArgument(Predicate<String> predicate) {
        for (String item : this.arguments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingArgument(Predicate<String> predicate) {
        for (String item : this.arguments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withArguments(List<String> arguments) {
        if (arguments != null) {
            this.arguments = new ArrayList<String>();
            for (String item : arguments) {
                this.addToArguments(item);
            }
        } else {
            this.arguments = null;
        }
        return (A)((Object)this);
    }

    public A withArguments(String ... arguments) {
        if (this.arguments != null) {
            this.arguments.clear();
            this._visitables.remove((Object)"arguments");
        }
        if (arguments != null) {
            for (String item : arguments) {
                this.addToArguments(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public A addToEnvVar(int index, EnvVar item) {
        if (this.envVar == null) {
            this.envVar = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.envVar.size()) {
            this._visitables.get((Object)"envVar").add(builder);
            this.envVar.add(builder);
        } else {
            this._visitables.get((Object)"envVar").add(index, builder);
            this.envVar.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnvVar(int index, EnvVar item) {
        if (this.envVar == null) {
            this.envVar = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.envVar.size()) {
            this._visitables.get((Object)"envVar").add(builder);
            this.envVar.add(builder);
        } else {
            this._visitables.get((Object)"envVar").set(index, builder);
            this.envVar.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnvVar(EnvVar ... items) {
        if (this.envVar == null) {
            this.envVar = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"envVar").add(builder);
            this.envVar.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnvVar(Collection<EnvVar> items) {
        if (this.envVar == null) {
            this.envVar = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"envVar").add(builder);
            this.envVar.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvVar(EnvVar ... items) {
        if (this.envVar == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"envVar").remove(builder);
            this.envVar.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnvVar(Collection<EnvVar> items) {
        if (this.envVar == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"envVar").remove(builder);
            this.envVar.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnvVar(Predicate<EnvVarBuilder> predicate) {
        if (this.envVar == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.envVar.iterator();
        List visitables = this._visitables.get((Object)"envVar");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EnvVar> buildEnvVar() {
        return this.envVar != null ? DeploymentConfigFluent.build(this.envVar) : null;
    }

    public EnvVar buildEnvVar(int index) {
        return this.envVar.get(index).build();
    }

    public EnvVar buildFirstEnvVar() {
        return this.envVar.get(0).build();
    }

    public EnvVar buildLastEnvVar() {
        return this.envVar.get(this.envVar.size() - 1).build();
    }

    public EnvVar buildMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.envVar) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.envVar) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnvVar(List<EnvVar> envVar) {
        if (this.envVar != null) {
            this._visitables.get((Object)"envVar").clear();
        }
        if (envVar != null) {
            this.envVar = new ArrayList();
            for (EnvVar item : envVar) {
                this.addToEnvVar(item);
            }
        } else {
            this.envVar = null;
        }
        return (A)((Object)this);
    }

    public A withEnvVar(EnvVar ... envVar) {
        if (this.envVar != null) {
            this.envVar.clear();
            this._visitables.remove((Object)"envVar");
        }
        if (envVar != null) {
            for (EnvVar item : envVar) {
                this.addToEnvVar(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnvVar() {
        return this.envVar != null && !this.envVar.isEmpty();
    }

    public EnvVarNested<A> addNewEnvVar() {
        return new EnvVarNested(-1, null);
    }

    public EnvVarNested<A> addNewEnvVarLike(EnvVar item) {
        return new EnvVarNested(-1, item);
    }

    public EnvVarNested<A> setNewEnvVarLike(int index, EnvVar item) {
        return new EnvVarNested(index, item);
    }

    public EnvVarNested<A> editEnvVar(int index) {
        if (this.envVar.size() <= index) {
            throw new RuntimeException("Can't edit envVar. Index exceeds size.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public EnvVarNested<A> editFirstEnvVar() {
        if (this.envVar.size() == 0) {
            throw new RuntimeException("Can't edit first envVar. The list is empty.");
        }
        return this.setNewEnvVarLike(0, this.buildEnvVar(0));
    }

    public EnvVarNested<A> editLastEnvVar() {
        int index = this.envVar.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envVar. The list is empty.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public EnvVarNested<A> editMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envVar.size(); ++i) {
            if (!predicate.test(this.envVar.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envVar. No match found.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public String getImageOverride() {
        return this.imageOverride;
    }

    public A withImageOverride(String imageOverride) {
        this.imageOverride = imageOverride;
        return (A)((Object)this);
    }

    public boolean hasImageOverride() {
        return this.imageOverride != null;
    }

    public Integer getReplicaCount() {
        return this.replicaCount;
    }

    public A withReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
        return (A)((Object)this);
    }

    public boolean hasReplicaCount() {
        return this.replicaCount != null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove(this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigFluent that = (DeploymentConfigFluent)((Object)o);
        if (!Objects.equals(this.arguments, that.arguments)) {
            return false;
        }
        if (!Objects.equals(this.envVar, that.envVar)) {
            return false;
        }
        if (!Objects.equals(this.imageOverride, that.imageOverride)) {
            return false;
        }
        if (!Objects.equals(this.replicaCount, that.replicaCount)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.arguments, this.envVar, this.imageOverride, this.replicaCount, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arguments != null && !this.arguments.isEmpty()) {
            sb.append("arguments:");
            sb.append(this.arguments + ",");
        }
        if (this.envVar != null && !this.envVar.isEmpty()) {
            sb.append("envVar:");
            sb.append(this.envVar + ",");
        }
        if (this.imageOverride != null) {
            sb.append("imageOverride:");
            sb.append(this.imageOverride + ",");
        }
        if (this.replicaCount != null) {
            sb.append("replicaCount:");
            sb.append(this.replicaCount + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)DeploymentConfigFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class EnvVarNested<N>
    extends EnvVarFluent<EnvVarNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvVarNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder((EnvVarFluent)this, item);
        }

        public N and() {
            return (N)DeploymentConfigFluent.this.setToEnvVar(this.index, this.builder.build());
        }

        public N endEnvVar() {
            return this.and();
        }
    }
}

