/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.search.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openclustermanagement.api.model.search.v1alpha1.StorageSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class StorageSpecFluent<A extends StorageSpecFluent<A>>
extends BaseFluent<A> {
    private Quantity size;
    private String storageClassName;
    private Map<String, Object> additionalProperties;

    public StorageSpecFluent() {
    }

    public StorageSpecFluent(StorageSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StorageSpec instance) {
        StorageSpec storageSpec = instance = instance != null ? instance : new StorageSpec();
        if (instance != null) {
            this.withSize(instance.getSize());
            this.withStorageClassName(instance.getStorageClassName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Quantity getSize() {
        return this.size;
    }

    public A withSize(Quantity size) {
        this.size = size;
        return (A)((Object)this);
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public A withNewSize(String amount, String format) {
        return this.withSize(new Quantity(amount, format));
    }

    public A withNewSize(String amount) {
        return this.withSize(new Quantity(amount));
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)((Object)this);
    }

    public boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageSpecFluent that = (StorageSpecFluent)((Object)o);
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        if (!Objects.equals(this.storageClassName, that.storageClassName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.storageClassName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size + ",");
        }
        if (this.storageClassName != null) {
            sb.append("storageClassName:");
            sb.append(this.storageClassName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

