/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openclustermanagement.api.model.agent.v1.KlusterletAddonConfigStatus;
import io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfig;
import io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigBuilder;
import io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KlusterletAddonConfigStatusFluent<A extends KlusterletAddonConfigStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ProxyConfigBuilder ocpGlobalProxy;
    private Map<String, Object> additionalProperties;

    public KlusterletAddonConfigStatusFluent() {
    }

    public KlusterletAddonConfigStatusFluent(KlusterletAddonConfigStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KlusterletAddonConfigStatus instance) {
        KlusterletAddonConfigStatus klusterletAddonConfigStatus = instance = instance != null ? instance : new KlusterletAddonConfigStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withOcpGlobalProxy(instance.getOcpGlobalProxy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ProxyConfig buildOcpGlobalProxy() {
        return this.ocpGlobalProxy != null ? this.ocpGlobalProxy.build() : null;
    }

    public A withOcpGlobalProxy(ProxyConfig ocpGlobalProxy) {
        this._visitables.remove((Object)"ocpGlobalProxy");
        if (ocpGlobalProxy != null) {
            this.ocpGlobalProxy = new ProxyConfigBuilder(ocpGlobalProxy);
            this._visitables.get((Object)"ocpGlobalProxy").add(this.ocpGlobalProxy);
        } else {
            this.ocpGlobalProxy = null;
            this._visitables.get((Object)"ocpGlobalProxy").remove((Object)this.ocpGlobalProxy);
        }
        return (A)((Object)this);
    }

    public boolean hasOcpGlobalProxy() {
        return this.ocpGlobalProxy != null;
    }

    public A withNewOcpGlobalProxy(String httpProxy, String httpsProxy, String noProxy) {
        return this.withOcpGlobalProxy(new ProxyConfig(httpProxy, httpsProxy, noProxy));
    }

    public OcpGlobalProxyNested<A> withNewOcpGlobalProxy() {
        return new OcpGlobalProxyNested(null);
    }

    public OcpGlobalProxyNested<A> withNewOcpGlobalProxyLike(ProxyConfig item) {
        return new OcpGlobalProxyNested(item);
    }

    public OcpGlobalProxyNested<A> editOcpGlobalProxy() {
        return this.withNewOcpGlobalProxyLike(Optional.ofNullable(this.buildOcpGlobalProxy()).orElse(null));
    }

    public OcpGlobalProxyNested<A> editOrNewOcpGlobalProxy() {
        return this.withNewOcpGlobalProxyLike(Optional.ofNullable(this.buildOcpGlobalProxy()).orElse(new ProxyConfigBuilder().build()));
    }

    public OcpGlobalProxyNested<A> editOrNewOcpGlobalProxyLike(ProxyConfig item) {
        return this.withNewOcpGlobalProxyLike(Optional.ofNullable(this.buildOcpGlobalProxy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KlusterletAddonConfigStatusFluent that = (KlusterletAddonConfigStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.ocpGlobalProxy, (Object)that.ocpGlobalProxy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this.ocpGlobalProxy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.ocpGlobalProxy != null) {
            sb.append("ocpGlobalProxy:");
            sb.append(this.ocpGlobalProxy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OcpGlobalProxyNested<N>
    extends ProxyConfigFluent<OcpGlobalProxyNested<N>>
    implements Nested<N> {
        ProxyConfigBuilder builder;

        OcpGlobalProxyNested(ProxyConfig item) {
            this.builder = new ProxyConfigBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletAddonConfigStatusFluent.this.withOcpGlobalProxy(this.builder.build());
        }

        public N endOcpGlobalProxy() {
            return this.and();
        }
    }
}

