/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.apps.v1.Overrides;
import io.fabric8.openclustermanagement.api.model.apps.v1.PackageOverride;
import io.fabric8.openclustermanagement.api.model.apps.v1.PackageOverrideBuilder;
import io.fabric8.openclustermanagement.api.model.apps.v1.PackageOverrideFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OverridesFluent<A extends OverridesFluent<A>>
extends BaseFluent<A> {
    private String packageAlias;
    private String packageName;
    private ArrayList<PackageOverrideBuilder> packageOverrides = new ArrayList();
    private Map<String, Object> additionalProperties;

    public OverridesFluent() {
    }

    public OverridesFluent(Overrides instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Overrides instance) {
        Overrides overrides = instance = instance != null ? instance : new Overrides();
        if (instance != null) {
            this.withPackageAlias(instance.getPackageAlias());
            this.withPackageName(instance.getPackageName());
            this.withPackageOverrides(instance.getPackageOverrides());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getPackageAlias() {
        return this.packageAlias;
    }

    public A withPackageAlias(String packageAlias) {
        this.packageAlias = packageAlias;
        return (A)((Object)this);
    }

    public boolean hasPackageAlias() {
        return this.packageAlias != null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public A withPackageName(String packageName) {
        this.packageName = packageName;
        return (A)((Object)this);
    }

    public boolean hasPackageName() {
        return this.packageName != null;
    }

    public A addToPackageOverrides(int index, PackageOverride item) {
        if (this.packageOverrides == null) {
            this.packageOverrides = new ArrayList();
        }
        PackageOverrideBuilder builder = new PackageOverrideBuilder(item);
        if (index < 0 || index >= this.packageOverrides.size()) {
            this._visitables.get((Object)"packageOverrides").add(builder);
            this.packageOverrides.add(builder);
        } else {
            this._visitables.get((Object)"packageOverrides").add(index, builder);
            this.packageOverrides.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPackageOverrides(int index, PackageOverride item) {
        if (this.packageOverrides == null) {
            this.packageOverrides = new ArrayList();
        }
        PackageOverrideBuilder builder = new PackageOverrideBuilder(item);
        if (index < 0 || index >= this.packageOverrides.size()) {
            this._visitables.get((Object)"packageOverrides").add(builder);
            this.packageOverrides.add(builder);
        } else {
            this._visitables.get((Object)"packageOverrides").set(index, builder);
            this.packageOverrides.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPackageOverrides(PackageOverride ... items) {
        if (this.packageOverrides == null) {
            this.packageOverrides = new ArrayList();
        }
        for (PackageOverride item : items) {
            PackageOverrideBuilder builder = new PackageOverrideBuilder(item);
            this._visitables.get((Object)"packageOverrides").add(builder);
            this.packageOverrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPackageOverrides(Collection<PackageOverride> items) {
        if (this.packageOverrides == null) {
            this.packageOverrides = new ArrayList();
        }
        for (PackageOverride item : items) {
            PackageOverrideBuilder builder = new PackageOverrideBuilder(item);
            this._visitables.get((Object)"packageOverrides").add(builder);
            this.packageOverrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPackageOverrides(PackageOverride ... items) {
        if (this.packageOverrides == null) {
            return (A)((Object)this);
        }
        for (PackageOverride item : items) {
            PackageOverrideBuilder builder = new PackageOverrideBuilder(item);
            this._visitables.get((Object)"packageOverrides").remove((Object)builder);
            this.packageOverrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPackageOverrides(Collection<PackageOverride> items) {
        if (this.packageOverrides == null) {
            return (A)((Object)this);
        }
        for (PackageOverride item : items) {
            PackageOverrideBuilder builder = new PackageOverrideBuilder(item);
            this._visitables.get((Object)"packageOverrides").remove((Object)builder);
            this.packageOverrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPackageOverrides(Predicate<PackageOverrideBuilder> predicate) {
        if (this.packageOverrides == null) {
            return (A)((Object)this);
        }
        Iterator<PackageOverrideBuilder> each = this.packageOverrides.iterator();
        List visitables = this._visitables.get((Object)"packageOverrides");
        while (each.hasNext()) {
            PackageOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PackageOverride> buildPackageOverrides() {
        return this.packageOverrides != null ? OverridesFluent.build(this.packageOverrides) : null;
    }

    public PackageOverride buildPackageOverride(int index) {
        return this.packageOverrides.get(index).build();
    }

    public PackageOverride buildFirstPackageOverride() {
        return this.packageOverrides.get(0).build();
    }

    public PackageOverride buildLastPackageOverride() {
        return this.packageOverrides.get(this.packageOverrides.size() - 1).build();
    }

    public PackageOverride buildMatchingPackageOverride(Predicate<PackageOverrideBuilder> predicate) {
        for (PackageOverrideBuilder item : this.packageOverrides) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPackageOverride(Predicate<PackageOverrideBuilder> predicate) {
        for (PackageOverrideBuilder item : this.packageOverrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPackageOverrides(List<PackageOverride> packageOverrides) {
        if (this.packageOverrides != null) {
            this._visitables.get((Object)"packageOverrides").clear();
        }
        if (packageOverrides != null) {
            this.packageOverrides = new ArrayList();
            for (PackageOverride item : packageOverrides) {
                this.addToPackageOverrides(item);
            }
        } else {
            this.packageOverrides = null;
        }
        return (A)((Object)this);
    }

    public A withPackageOverrides(PackageOverride ... packageOverrides) {
        if (this.packageOverrides != null) {
            this.packageOverrides.clear();
            this._visitables.remove((Object)"packageOverrides");
        }
        if (packageOverrides != null) {
            for (PackageOverride item : packageOverrides) {
                this.addToPackageOverrides(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPackageOverrides() {
        return this.packageOverrides != null && !this.packageOverrides.isEmpty();
    }

    public PackageOverridesNested<A> addNewPackageOverride() {
        return new PackageOverridesNested(-1, null);
    }

    public PackageOverridesNested<A> addNewPackageOverrideLike(PackageOverride item) {
        return new PackageOverridesNested(-1, item);
    }

    public PackageOverridesNested<A> setNewPackageOverrideLike(int index, PackageOverride item) {
        return new PackageOverridesNested(index, item);
    }

    public PackageOverridesNested<A> editPackageOverride(int index) {
        if (this.packageOverrides.size() <= index) {
            throw new RuntimeException("Can't edit packageOverrides. Index exceeds size.");
        }
        return this.setNewPackageOverrideLike(index, this.buildPackageOverride(index));
    }

    public PackageOverridesNested<A> editFirstPackageOverride() {
        if (this.packageOverrides.size() == 0) {
            throw new RuntimeException("Can't edit first packageOverrides. The list is empty.");
        }
        return this.setNewPackageOverrideLike(0, this.buildPackageOverride(0));
    }

    public PackageOverridesNested<A> editLastPackageOverride() {
        int index = this.packageOverrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last packageOverrides. The list is empty.");
        }
        return this.setNewPackageOverrideLike(index, this.buildPackageOverride(index));
    }

    public PackageOverridesNested<A> editMatchingPackageOverride(Predicate<PackageOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.packageOverrides.size(); ++i) {
            if (!predicate.test(this.packageOverrides.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching packageOverrides. No match found.");
        }
        return this.setNewPackageOverrideLike(index, this.buildPackageOverride(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OverridesFluent that = (OverridesFluent)((Object)o);
        if (!Objects.equals(this.packageAlias, that.packageAlias)) {
            return false;
        }
        if (!Objects.equals(this.packageName, that.packageName)) {
            return false;
        }
        if (!Objects.equals(this.packageOverrides, that.packageOverrides)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.packageAlias, this.packageName, this.packageOverrides, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.packageAlias != null) {
            sb.append("packageAlias:");
            sb.append(this.packageAlias + ",");
        }
        if (this.packageName != null) {
            sb.append("packageName:");
            sb.append(this.packageName + ",");
        }
        if (this.packageOverrides != null && !this.packageOverrides.isEmpty()) {
            sb.append("packageOverrides:");
            sb.append(this.packageOverrides + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PackageOverridesNested<N>
    extends PackageOverrideFluent<PackageOverridesNested<N>>
    implements Nested<N> {
        PackageOverrideBuilder builder;
        int index;

        PackageOverridesNested(int index, PackageOverride item) {
            this.index = index;
            this.builder = new PackageOverrideBuilder(this, item);
        }

        public N and() {
            return (N)OverridesFluent.this.setToPackageOverrides(this.index, this.builder.build());
        }

        public N endPackageOverride() {
            return this.and();
        }
    }
}

