/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.SpreadConstraintsTerm;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.SpreadConstraintsTermBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.SpreadConstraintsTermFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1beta1.SpreadPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SpreadPolicyFluent<A extends SpreadPolicyFluent<A>>
extends BaseFluent<A> {
    private ArrayList<SpreadConstraintsTermBuilder> spreadConstraints = new ArrayList();
    private Map<String, Object> additionalProperties;

    public SpreadPolicyFluent() {
    }

    public SpreadPolicyFluent(SpreadPolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SpreadPolicy instance) {
        SpreadPolicy spreadPolicy = instance = instance != null ? instance : new SpreadPolicy();
        if (instance != null) {
            this.withSpreadConstraints(instance.getSpreadConstraints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToSpreadConstraints(int index, SpreadConstraintsTerm item) {
        if (this.spreadConstraints == null) {
            this.spreadConstraints = new ArrayList();
        }
        SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);
        if (index < 0 || index >= this.spreadConstraints.size()) {
            this._visitables.get((Object)"spreadConstraints").add(builder);
            this.spreadConstraints.add(builder);
        } else {
            this._visitables.get((Object)"spreadConstraints").add(index, builder);
            this.spreadConstraints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSpreadConstraints(int index, SpreadConstraintsTerm item) {
        if (this.spreadConstraints == null) {
            this.spreadConstraints = new ArrayList();
        }
        SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);
        if (index < 0 || index >= this.spreadConstraints.size()) {
            this._visitables.get((Object)"spreadConstraints").add(builder);
            this.spreadConstraints.add(builder);
        } else {
            this._visitables.get((Object)"spreadConstraints").set(index, builder);
            this.spreadConstraints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSpreadConstraints(SpreadConstraintsTerm ... items) {
        if (this.spreadConstraints == null) {
            this.spreadConstraints = new ArrayList();
        }
        for (SpreadConstraintsTerm item : items) {
            SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);
            this._visitables.get((Object)"spreadConstraints").add(builder);
            this.spreadConstraints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSpreadConstraints(Collection<SpreadConstraintsTerm> items) {
        if (this.spreadConstraints == null) {
            this.spreadConstraints = new ArrayList();
        }
        for (SpreadConstraintsTerm item : items) {
            SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);
            this._visitables.get((Object)"spreadConstraints").add(builder);
            this.spreadConstraints.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSpreadConstraints(SpreadConstraintsTerm ... items) {
        if (this.spreadConstraints == null) {
            return (A)((Object)this);
        }
        for (SpreadConstraintsTerm item : items) {
            SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);
            this._visitables.get((Object)"spreadConstraints").remove((Object)builder);
            this.spreadConstraints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSpreadConstraints(Collection<SpreadConstraintsTerm> items) {
        if (this.spreadConstraints == null) {
            return (A)((Object)this);
        }
        for (SpreadConstraintsTerm item : items) {
            SpreadConstraintsTermBuilder builder = new SpreadConstraintsTermBuilder(item);
            this._visitables.get((Object)"spreadConstraints").remove((Object)builder);
            this.spreadConstraints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSpreadConstraints(Predicate<SpreadConstraintsTermBuilder> predicate) {
        if (this.spreadConstraints == null) {
            return (A)((Object)this);
        }
        Iterator<SpreadConstraintsTermBuilder> each = this.spreadConstraints.iterator();
        List visitables = this._visitables.get((Object)"spreadConstraints");
        while (each.hasNext()) {
            SpreadConstraintsTermBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SpreadConstraintsTerm> buildSpreadConstraints() {
        return this.spreadConstraints != null ? SpreadPolicyFluent.build(this.spreadConstraints) : null;
    }

    public SpreadConstraintsTerm buildSpreadConstraint(int index) {
        return this.spreadConstraints.get(index).build();
    }

    public SpreadConstraintsTerm buildFirstSpreadConstraint() {
        return this.spreadConstraints.get(0).build();
    }

    public SpreadConstraintsTerm buildLastSpreadConstraint() {
        return this.spreadConstraints.get(this.spreadConstraints.size() - 1).build();
    }

    public SpreadConstraintsTerm buildMatchingSpreadConstraint(Predicate<SpreadConstraintsTermBuilder> predicate) {
        for (SpreadConstraintsTermBuilder item : this.spreadConstraints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSpreadConstraint(Predicate<SpreadConstraintsTermBuilder> predicate) {
        for (SpreadConstraintsTermBuilder item : this.spreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSpreadConstraints(List<SpreadConstraintsTerm> spreadConstraints) {
        if (this.spreadConstraints != null) {
            this._visitables.get((Object)"spreadConstraints").clear();
        }
        if (spreadConstraints != null) {
            this.spreadConstraints = new ArrayList();
            for (SpreadConstraintsTerm item : spreadConstraints) {
                this.addToSpreadConstraints(item);
            }
        } else {
            this.spreadConstraints = null;
        }
        return (A)((Object)this);
    }

    public A withSpreadConstraints(SpreadConstraintsTerm ... spreadConstraints) {
        if (this.spreadConstraints != null) {
            this.spreadConstraints.clear();
            this._visitables.remove((Object)"spreadConstraints");
        }
        if (spreadConstraints != null) {
            for (SpreadConstraintsTerm item : spreadConstraints) {
                this.addToSpreadConstraints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSpreadConstraints() {
        return this.spreadConstraints != null && !this.spreadConstraints.isEmpty();
    }

    public A addNewSpreadConstraint(Integer maxSkew, String topologyKey, String topologyKeyType, String whenUnsatisfiable) {
        return this.addToSpreadConstraints(new SpreadConstraintsTerm(maxSkew, topologyKey, topologyKeyType, whenUnsatisfiable));
    }

    public SpreadConstraintsNested<A> addNewSpreadConstraint() {
        return new SpreadConstraintsNested(-1, null);
    }

    public SpreadConstraintsNested<A> addNewSpreadConstraintLike(SpreadConstraintsTerm item) {
        return new SpreadConstraintsNested(-1, item);
    }

    public SpreadConstraintsNested<A> setNewSpreadConstraintLike(int index, SpreadConstraintsTerm item) {
        return new SpreadConstraintsNested(index, item);
    }

    public SpreadConstraintsNested<A> editSpreadConstraint(int index) {
        if (this.spreadConstraints.size() <= index) {
            throw new RuntimeException("Can't edit spreadConstraints. Index exceeds size.");
        }
        return this.setNewSpreadConstraintLike(index, this.buildSpreadConstraint(index));
    }

    public SpreadConstraintsNested<A> editFirstSpreadConstraint() {
        if (this.spreadConstraints.size() == 0) {
            throw new RuntimeException("Can't edit first spreadConstraints. The list is empty.");
        }
        return this.setNewSpreadConstraintLike(0, this.buildSpreadConstraint(0));
    }

    public SpreadConstraintsNested<A> editLastSpreadConstraint() {
        int index = this.spreadConstraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last spreadConstraints. The list is empty.");
        }
        return this.setNewSpreadConstraintLike(index, this.buildSpreadConstraint(index));
    }

    public SpreadConstraintsNested<A> editMatchingSpreadConstraint(Predicate<SpreadConstraintsTermBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.spreadConstraints.size(); ++i) {
            if (!predicate.test(this.spreadConstraints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching spreadConstraints. No match found.");
        }
        return this.setNewSpreadConstraintLike(index, this.buildSpreadConstraint(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpreadPolicyFluent that = (SpreadPolicyFluent)((Object)o);
        if (!Objects.equals(this.spreadConstraints, that.spreadConstraints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.spreadConstraints, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.spreadConstraints != null && !this.spreadConstraints.isEmpty()) {
            sb.append("spreadConstraints:");
            sb.append(this.spreadConstraints + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SpreadConstraintsNested<N>
    extends SpreadConstraintsTermFluent<SpreadConstraintsNested<N>>
    implements Nested<N> {
        SpreadConstraintsTermBuilder builder;
        int index;

        SpreadConstraintsNested(int index, SpreadConstraintsTerm item) {
            this.index = index;
            this.builder = new SpreadConstraintsTermBuilder(this, item);
        }

        public N and() {
            return (N)SpreadPolicyFluent.this.setToSpreadConstraints(this.index, this.builder.build());
        }

        public N endSpreadConstraint() {
            return this.and();
        }
    }
}

