/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.BackupConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.BackupConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.BackupConfigFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.ExternalDNSConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.ExternalDNSConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.ExternalDNSConfigFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.FailedProvisionConfig;
import io.fabric8.openclustermanagement.api.model.operator.v1.FailedProvisionConfigBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.FailedProvisionConfigFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.HiveConfigSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HiveConfigSpecFluent<A extends HiveConfigSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<LocalObjectReferenceBuilder> additionalCertificateAuthorities = new ArrayList();
    private BackupConfigBuilder backup;
    private ExternalDNSConfigBuilder externalDNS;
    private FailedProvisionConfigBuilder failedProvisionConfig;
    private LocalObjectReferenceBuilder globalPullSecret;
    private Boolean maintenanceMode;
    private Map<String, Object> additionalProperties;

    public HiveConfigSpecFluent() {
    }

    public HiveConfigSpecFluent(HiveConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HiveConfigSpec instance) {
        HiveConfigSpec hiveConfigSpec = instance = instance != null ? instance : new HiveConfigSpec();
        if (instance != null) {
            this.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
            this.withBackup(instance.getBackup());
            this.withExternalDNS(instance.getExternalDNS());
            this.withFailedProvisionConfig(instance.getFailedProvisionConfig());
            this.withGlobalPullSecret(instance.getGlobalPullSecret());
            this.withMaintenanceMode(instance.getMaintenanceMode());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalCertificateAuthorities(int index, LocalObjectReference item) {
        if (this.additionalCertificateAuthorities == null) {
            this.additionalCertificateAuthorities = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.additionalCertificateAuthorities.size()) {
            this._visitables.get((Object)"additionalCertificateAuthorities").add(builder);
            this.additionalCertificateAuthorities.add(builder);
        } else {
            this._visitables.get((Object)"additionalCertificateAuthorities").add(index, builder);
            this.additionalCertificateAuthorities.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAdditionalCertificateAuthorities(int index, LocalObjectReference item) {
        if (this.additionalCertificateAuthorities == null) {
            this.additionalCertificateAuthorities = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.additionalCertificateAuthorities.size()) {
            this._visitables.get((Object)"additionalCertificateAuthorities").add(builder);
            this.additionalCertificateAuthorities.add(builder);
        } else {
            this._visitables.get((Object)"additionalCertificateAuthorities").set(index, builder);
            this.additionalCertificateAuthorities.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalCertificateAuthorities(LocalObjectReference ... items) {
        if (this.additionalCertificateAuthorities == null) {
            this.additionalCertificateAuthorities = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"additionalCertificateAuthorities").add(builder);
            this.additionalCertificateAuthorities.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAdditionalCertificateAuthorities(Collection<LocalObjectReference> items) {
        if (this.additionalCertificateAuthorities == null) {
            this.additionalCertificateAuthorities = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"additionalCertificateAuthorities").add(builder);
            this.additionalCertificateAuthorities.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalCertificateAuthorities(LocalObjectReference ... items) {
        if (this.additionalCertificateAuthorities == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"additionalCertificateAuthorities").remove(builder);
            this.additionalCertificateAuthorities.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAdditionalCertificateAuthorities(Collection<LocalObjectReference> items) {
        if (this.additionalCertificateAuthorities == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"additionalCertificateAuthorities").remove(builder);
            this.additionalCertificateAuthorities.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAdditionalCertificateAuthorities(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.additionalCertificateAuthorities == null) {
            return (A)((Object)this);
        }
        Iterator<LocalObjectReferenceBuilder> each = this.additionalCertificateAuthorities.iterator();
        List visitables = this._visitables.get((Object)"additionalCertificateAuthorities");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LocalObjectReference> buildAdditionalCertificateAuthorities() {
        return this.additionalCertificateAuthorities != null ? HiveConfigSpecFluent.build(this.additionalCertificateAuthorities) : null;
    }

    public LocalObjectReference buildAdditionalCertificateAuthority(int index) {
        return this.additionalCertificateAuthorities.get(index).build();
    }

    public LocalObjectReference buildFirstAdditionalCertificateAuthority() {
        return this.additionalCertificateAuthorities.get(0).build();
    }

    public LocalObjectReference buildLastAdditionalCertificateAuthority() {
        return this.additionalCertificateAuthorities.get(this.additionalCertificateAuthorities.size() - 1).build();
    }

    public LocalObjectReference buildMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.additionalCertificateAuthorities) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.additionalCertificateAuthorities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalCertificateAuthorities(List<LocalObjectReference> additionalCertificateAuthorities) {
        if (this.additionalCertificateAuthorities != null) {
            this._visitables.get((Object)"additionalCertificateAuthorities").clear();
        }
        if (additionalCertificateAuthorities != null) {
            this.additionalCertificateAuthorities = new ArrayList();
            for (LocalObjectReference item : additionalCertificateAuthorities) {
                this.addToAdditionalCertificateAuthorities(item);
            }
        } else {
            this.additionalCertificateAuthorities = null;
        }
        return (A)((Object)this);
    }

    public A withAdditionalCertificateAuthorities(LocalObjectReference ... additionalCertificateAuthorities) {
        if (this.additionalCertificateAuthorities != null) {
            this.additionalCertificateAuthorities.clear();
            this._visitables.remove((Object)"additionalCertificateAuthorities");
        }
        if (additionalCertificateAuthorities != null) {
            for (LocalObjectReference item : additionalCertificateAuthorities) {
                this.addToAdditionalCertificateAuthorities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAdditionalCertificateAuthorities() {
        return this.additionalCertificateAuthorities != null && !this.additionalCertificateAuthorities.isEmpty();
    }

    public A addNewAdditionalCertificateAuthority(String name) {
        return this.addToAdditionalCertificateAuthorities(new LocalObjectReference(name));
    }

    public AdditionalCertificateAuthoritiesNested<A> addNewAdditionalCertificateAuthority() {
        return new AdditionalCertificateAuthoritiesNested(-1, null);
    }

    public AdditionalCertificateAuthoritiesNested<A> addNewAdditionalCertificateAuthorityLike(LocalObjectReference item) {
        return new AdditionalCertificateAuthoritiesNested(-1, item);
    }

    public AdditionalCertificateAuthoritiesNested<A> setNewAdditionalCertificateAuthorityLike(int index, LocalObjectReference item) {
        return new AdditionalCertificateAuthoritiesNested(index, item);
    }

    public AdditionalCertificateAuthoritiesNested<A> editAdditionalCertificateAuthority(int index) {
        if (this.additionalCertificateAuthorities.size() <= index) {
            throw new RuntimeException("Can't edit additionalCertificateAuthorities. Index exceeds size.");
        }
        return this.setNewAdditionalCertificateAuthorityLike(index, this.buildAdditionalCertificateAuthority(index));
    }

    public AdditionalCertificateAuthoritiesNested<A> editFirstAdditionalCertificateAuthority() {
        if (this.additionalCertificateAuthorities.size() == 0) {
            throw new RuntimeException("Can't edit first additionalCertificateAuthorities. The list is empty.");
        }
        return this.setNewAdditionalCertificateAuthorityLike(0, this.buildAdditionalCertificateAuthority(0));
    }

    public AdditionalCertificateAuthoritiesNested<A> editLastAdditionalCertificateAuthority() {
        int index = this.additionalCertificateAuthorities.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last additionalCertificateAuthorities. The list is empty.");
        }
        return this.setNewAdditionalCertificateAuthorityLike(index, this.buildAdditionalCertificateAuthority(index));
    }

    public AdditionalCertificateAuthoritiesNested<A> editMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.additionalCertificateAuthorities.size(); ++i) {
            if (!predicate.test(this.additionalCertificateAuthorities.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching additionalCertificateAuthorities. No match found.");
        }
        return this.setNewAdditionalCertificateAuthorityLike(index, this.buildAdditionalCertificateAuthority(index));
    }

    public BackupConfig buildBackup() {
        return this.backup != null ? this.backup.build() : null;
    }

    public A withBackup(BackupConfig backup) {
        this._visitables.remove((Object)"backup");
        if (backup != null) {
            this.backup = new BackupConfigBuilder(backup);
            this._visitables.get((Object)"backup").add(this.backup);
        } else {
            this.backup = null;
            this._visitables.get((Object)"backup").remove((Object)this.backup);
        }
        return (A)((Object)this);
    }

    public boolean hasBackup() {
        return this.backup != null;
    }

    public BackupNested<A> withNewBackup() {
        return new BackupNested(null);
    }

    public BackupNested<A> withNewBackupLike(BackupConfig item) {
        return new BackupNested(item);
    }

    public BackupNested<A> editBackup() {
        return this.withNewBackupLike(Optional.ofNullable(this.buildBackup()).orElse(null));
    }

    public BackupNested<A> editOrNewBackup() {
        return this.withNewBackupLike(Optional.ofNullable(this.buildBackup()).orElse(new BackupConfigBuilder().build()));
    }

    public BackupNested<A> editOrNewBackupLike(BackupConfig item) {
        return this.withNewBackupLike(Optional.ofNullable(this.buildBackup()).orElse(item));
    }

    public ExternalDNSConfig buildExternalDNS() {
        return this.externalDNS != null ? this.externalDNS.build() : null;
    }

    public A withExternalDNS(ExternalDNSConfig externalDNS) {
        this._visitables.remove((Object)"externalDNS");
        if (externalDNS != null) {
            this.externalDNS = new ExternalDNSConfigBuilder(externalDNS);
            this._visitables.get((Object)"externalDNS").add(this.externalDNS);
        } else {
            this.externalDNS = null;
            this._visitables.get((Object)"externalDNS").remove((Object)this.externalDNS);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalDNS() {
        return this.externalDNS != null;
    }

    public ExternalDNSNested<A> withNewExternalDNS() {
        return new ExternalDNSNested(null);
    }

    public ExternalDNSNested<A> withNewExternalDNSLike(ExternalDNSConfig item) {
        return new ExternalDNSNested(item);
    }

    public ExternalDNSNested<A> editExternalDNS() {
        return this.withNewExternalDNSLike(Optional.ofNullable(this.buildExternalDNS()).orElse(null));
    }

    public ExternalDNSNested<A> editOrNewExternalDNS() {
        return this.withNewExternalDNSLike(Optional.ofNullable(this.buildExternalDNS()).orElse(new ExternalDNSConfigBuilder().build()));
    }

    public ExternalDNSNested<A> editOrNewExternalDNSLike(ExternalDNSConfig item) {
        return this.withNewExternalDNSLike(Optional.ofNullable(this.buildExternalDNS()).orElse(item));
    }

    public FailedProvisionConfig buildFailedProvisionConfig() {
        return this.failedProvisionConfig != null ? this.failedProvisionConfig.build() : null;
    }

    public A withFailedProvisionConfig(FailedProvisionConfig failedProvisionConfig) {
        this._visitables.remove((Object)"failedProvisionConfig");
        if (failedProvisionConfig != null) {
            this.failedProvisionConfig = new FailedProvisionConfigBuilder(failedProvisionConfig);
            this._visitables.get((Object)"failedProvisionConfig").add(this.failedProvisionConfig);
        } else {
            this.failedProvisionConfig = null;
            this._visitables.get((Object)"failedProvisionConfig").remove((Object)this.failedProvisionConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasFailedProvisionConfig() {
        return this.failedProvisionConfig != null;
    }

    public A withNewFailedProvisionConfig(Boolean skipGatherLogs) {
        return this.withFailedProvisionConfig(new FailedProvisionConfig(skipGatherLogs));
    }

    public FailedProvisionConfigNested<A> withNewFailedProvisionConfig() {
        return new FailedProvisionConfigNested(null);
    }

    public FailedProvisionConfigNested<A> withNewFailedProvisionConfigLike(FailedProvisionConfig item) {
        return new FailedProvisionConfigNested(item);
    }

    public FailedProvisionConfigNested<A> editFailedProvisionConfig() {
        return this.withNewFailedProvisionConfigLike(Optional.ofNullable(this.buildFailedProvisionConfig()).orElse(null));
    }

    public FailedProvisionConfigNested<A> editOrNewFailedProvisionConfig() {
        return this.withNewFailedProvisionConfigLike(Optional.ofNullable(this.buildFailedProvisionConfig()).orElse(new FailedProvisionConfigBuilder().build()));
    }

    public FailedProvisionConfigNested<A> editOrNewFailedProvisionConfigLike(FailedProvisionConfig item) {
        return this.withNewFailedProvisionConfigLike(Optional.ofNullable(this.buildFailedProvisionConfig()).orElse(item));
    }

    public LocalObjectReference buildGlobalPullSecret() {
        return this.globalPullSecret != null ? this.globalPullSecret.build() : null;
    }

    public A withGlobalPullSecret(LocalObjectReference globalPullSecret) {
        this._visitables.remove((Object)"globalPullSecret");
        if (globalPullSecret != null) {
            this.globalPullSecret = new LocalObjectReferenceBuilder(globalPullSecret);
            this._visitables.get((Object)"globalPullSecret").add(this.globalPullSecret);
        } else {
            this.globalPullSecret = null;
            this._visitables.get((Object)"globalPullSecret").remove(this.globalPullSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasGlobalPullSecret() {
        return this.globalPullSecret != null;
    }

    public A withNewGlobalPullSecret(String name) {
        return this.withGlobalPullSecret(new LocalObjectReference(name));
    }

    public GlobalPullSecretNested<A> withNewGlobalPullSecret() {
        return new GlobalPullSecretNested(null);
    }

    public GlobalPullSecretNested<A> withNewGlobalPullSecretLike(LocalObjectReference item) {
        return new GlobalPullSecretNested(item);
    }

    public GlobalPullSecretNested<A> editGlobalPullSecret() {
        return this.withNewGlobalPullSecretLike(Optional.ofNullable(this.buildGlobalPullSecret()).orElse(null));
    }

    public GlobalPullSecretNested<A> editOrNewGlobalPullSecret() {
        return this.withNewGlobalPullSecretLike(Optional.ofNullable(this.buildGlobalPullSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public GlobalPullSecretNested<A> editOrNewGlobalPullSecretLike(LocalObjectReference item) {
        return this.withNewGlobalPullSecretLike(Optional.ofNullable(this.buildGlobalPullSecret()).orElse(item));
    }

    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public A withMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
        return (A)((Object)this);
    }

    public boolean hasMaintenanceMode() {
        return this.maintenanceMode != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HiveConfigSpecFluent that = (HiveConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.additionalCertificateAuthorities, that.additionalCertificateAuthorities)) {
            return false;
        }
        if (!Objects.equals((Object)this.backup, (Object)that.backup)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalDNS, (Object)that.externalDNS)) {
            return false;
        }
        if (!Objects.equals((Object)this.failedProvisionConfig, (Object)that.failedProvisionConfig)) {
            return false;
        }
        if (!Objects.equals(this.globalPullSecret, that.globalPullSecret)) {
            return false;
        }
        if (!Objects.equals(this.maintenanceMode, that.maintenanceMode)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalCertificateAuthorities, this.backup, this.externalDNS, this.failedProvisionConfig, this.globalPullSecret, this.maintenanceMode, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalCertificateAuthorities != null && !this.additionalCertificateAuthorities.isEmpty()) {
            sb.append("additionalCertificateAuthorities:");
            sb.append(this.additionalCertificateAuthorities + ",");
        }
        if (this.backup != null) {
            sb.append("backup:");
            sb.append(this.backup + ",");
        }
        if (this.externalDNS != null) {
            sb.append("externalDNS:");
            sb.append(this.externalDNS + ",");
        }
        if (this.failedProvisionConfig != null) {
            sb.append("failedProvisionConfig:");
            sb.append(this.failedProvisionConfig + ",");
        }
        if (this.globalPullSecret != null) {
            sb.append("globalPullSecret:");
            sb.append(this.globalPullSecret + ",");
        }
        if (this.maintenanceMode != null) {
            sb.append("maintenanceMode:");
            sb.append(this.maintenanceMode + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withMaintenanceMode() {
        return this.withMaintenanceMode(true);
    }

    public class GlobalPullSecretNested<N>
    extends LocalObjectReferenceFluent<GlobalPullSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        GlobalPullSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)HiveConfigSpecFluent.this.withGlobalPullSecret(this.builder.build());
        }

        public N endGlobalPullSecret() {
            return this.and();
        }
    }

    public class FailedProvisionConfigNested<N>
    extends FailedProvisionConfigFluent<FailedProvisionConfigNested<N>>
    implements Nested<N> {
        FailedProvisionConfigBuilder builder;

        FailedProvisionConfigNested(FailedProvisionConfig item) {
            this.builder = new FailedProvisionConfigBuilder(this, item);
        }

        public N and() {
            return (N)HiveConfigSpecFluent.this.withFailedProvisionConfig(this.builder.build());
        }

        public N endFailedProvisionConfig() {
            return this.and();
        }
    }

    public class ExternalDNSNested<N>
    extends ExternalDNSConfigFluent<ExternalDNSNested<N>>
    implements Nested<N> {
        ExternalDNSConfigBuilder builder;

        ExternalDNSNested(ExternalDNSConfig item) {
            this.builder = new ExternalDNSConfigBuilder(this, item);
        }

        public N and() {
            return (N)HiveConfigSpecFluent.this.withExternalDNS(this.builder.build());
        }

        public N endExternalDNS() {
            return this.and();
        }
    }

    public class BackupNested<N>
    extends BackupConfigFluent<BackupNested<N>>
    implements Nested<N> {
        BackupConfigBuilder builder;

        BackupNested(BackupConfig item) {
            this.builder = new BackupConfigBuilder(this, item);
        }

        public N and() {
            return (N)HiveConfigSpecFluent.this.withBackup(this.builder.build());
        }

        public N endBackup() {
            return this.and();
        }
    }

    public class AdditionalCertificateAuthoritiesNested<N>
    extends LocalObjectReferenceFluent<AdditionalCertificateAuthoritiesNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        AdditionalCertificateAuthoritiesNested(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)HiveConfigSpecFluent.this.setToAdditionalCertificateAuthorities(this.index, this.builder.build());
        }

        public N endAdditionalCertificateAuthority() {
            return this.and();
        }
    }
}

